/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.scio.testing.util;

import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.services.cloudresourcemanager.CloudResourceManager;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.cloud.hadoop.util.ChainingHttpRequestInitializer;
import com.google.common.collect.ImmutableList;
import com.spotify.scio.bigquery.BigQueryClient$;
import com.spotify.scio.testing.util.DefaultBucket$;
import java.util.Collection;
import java.util.UUID;
import org.apache.beam.sdk.extensions.gcp.auth.NullCredentialInitializer;
import org.apache.beam.sdk.extensions.gcp.options.CloudResourceManagerOptions;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.util.RetryHttpRequestInitializer;
import org.apache.beam.sdk.util.Transport;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.sys.package$;

public final class ItUtils$ {
    public static ItUtils$ MODULE$;

    static {
        new ItUtils$();
    }

    public String project() {
        return package$.MODULE$.props().apply((Object)BigQueryClient$.MODULE$.PROJECT_KEY()) != null ? (String)package$.MODULE$.props().apply((Object)BigQueryClient$.MODULE$.PROJECT_KEY()) : new GcpOptions.DefaultProjectFactory().create(null);
    }

    public String gcpTempLocation(String prefix) {
        GcpOptions opts = (GcpOptions)PipelineOptionsFactory.as(GcpOptions.class);
        opts.setProject(this.project());
        String bucket = DefaultBucket$.MODULE$.tryCreateDefaultBucket((PipelineOptions)opts, this.newCloudResourceManagerClient((CloudResourceManagerOptions)opts.as(CloudResourceManagerOptions.class)));
        String uuid = UUID.randomUUID().toString();
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bucket, prefix, uuid}));
    }

    private CloudResourceManager newCloudResourceManagerClient(CloudResourceManagerOptions options) {
        Credentials credentials = options.getGcpCredential();
        if (credentials == null) {
            NullCredentialInitializer.throwNullCredentialException();
        }
        return new CloudResourceManager.Builder(Transport.getTransport(), Transport.getJsonFactory(), this.chainHttpRequestInitializer(credentials, (HttpRequestInitializer)new RetryHttpRequestInitializer((Collection)ImmutableList.of((Object)Predef$.MODULE$.int2Integer(404))))).setApplicationName(options.getAppName()).setGoogleClientRequestInitializer((GoogleClientRequestInitializer)options.getGoogleApiTrace()).build();
    }

    private HttpRequestInitializer chainHttpRequestInitializer(Credentials credential, HttpRequestInitializer httpRequestInitializer) {
        return credential == null ? new ChainingHttpRequestInitializer(new HttpRequestInitializer[]{new NullCredentialInitializer(), httpRequestInitializer}) : new ChainingHttpRequestInitializer(new HttpRequestInitializer[]{new HttpCredentialsAdapter(credential), httpRequestInitializer});
    }

    private ItUtils$() {
        MODULE$ = this;
    }
}

