/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx;

import com.google.cloud.datastore.Datastore;
import com.google.common.io.Closer;
import com.spotify.apollo.AppInit;
import com.spotify.apollo.Environment;
import com.spotify.apollo.route.Route;
import com.spotify.styx.api.CliResource;
import com.spotify.styx.api.StyxConfigResource;
import com.spotify.styx.api.WorkflowResource;
import com.spotify.styx.storage.AggregateStorage;
import com.spotify.styx.storage.EventStorage;
import com.spotify.styx.storage.Storage;
import com.spotify.styx.util.Connections;
import com.spotify.styx.util.EventStorageFactory;
import com.spotify.styx.util.Singleton;
import com.spotify.styx.util.StorageFactory;
import com.typesafe.config.Config;
import java.io.Closeable;
import java.time.Duration;
import java.util.Objects;
import org.apache.hadoop.hbase.client.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StyxApi
implements AppInit {
    public static final String SERVICE_NAME = "styx-api";
    public static final String SCHEDULER_SERVICE_BASE_URL = "styx.scheduler.base-url";
    public static final String DEFAULT_SCHEDULER_SERVICE_BASE_URL = "http://localhost:8080";
    public static final Duration DEFAULT_RETRY_BASE_DELAY_BT = Duration.ofSeconds(1L);
    private static final Logger LOG = LoggerFactory.getLogger(StyxApi.class);
    private final StorageFactory storageFactory;
    private final EventStorageFactory eventStorageFactory;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static StyxApi createDefault() {
        return StyxApi.newBuilder().build();
    }

    private StyxApi(StorageFactory storageFactory, EventStorageFactory eventStorageFactory) {
        this.storageFactory = Objects.requireNonNull(storageFactory);
        this.eventStorageFactory = Objects.requireNonNull(eventStorageFactory);
    }

    public void create(Environment environment) {
        Config config = environment.config();
        String schedulerServiceBaseUrl = config.hasPath(SCHEDULER_SERVICE_BASE_URL) ? config.getString(SCHEDULER_SERVICE_BASE_URL) : DEFAULT_SCHEDULER_SERVICE_BASE_URL;
        Storage storage = (Storage)this.storageFactory.apply((Object)environment);
        EventStorage eventStorage = (EventStorage)this.eventStorageFactory.apply((Object)environment);
        WorkflowResource workflowResource = new WorkflowResource(storage);
        StyxConfigResource styxConfigResource = new StyxConfigResource(storage);
        CliResource cliResource = new CliResource(schedulerServiceBaseUrl, eventStorage);
        environment.routingEngine().registerAutoRoute(Route.sync((String)"GET", (String)"/ping", rc -> "pong")).registerRoutes(workflowResource.routes()).registerRoutes(styxConfigResource.routes()).registerRoutes(cliResource.routes());
    }

    private static AggregateStorage storage(Environment environment) {
        Config config = environment.config();
        Closer closer = environment.closer();
        Connection bigTable = (Connection)closer.register((Closeable)Connections.createBigTableConnection((Config)config));
        Datastore datastore = Connections.createDatastore((Config)config);
        return new AggregateStorage(bigTable, datastore, DEFAULT_RETRY_BASE_DELAY_BT);
    }

    public static class Builder {
        private final Singleton<AggregateStorage> storage = Singleton.create(x$0 -> StyxApi.access$100(x$0));
        private StorageFactory storageFactory = arg_0 -> this.storage.apply(arg_0);
        private EventStorageFactory eventStorageFactory = arg_0 -> this.storage.apply(arg_0);

        public Builder setStorageFactory(StorageFactory storageFactory) {
            this.storageFactory = storageFactory;
            return this;
        }

        public Builder setEventStorageFactory(EventStorageFactory eventStorageFactory) {
            this.eventStorageFactory = eventStorageFactory;
            return this;
        }

        public StyxApi build() {
            return new StyxApi(this.storageFactory, this.eventStorageFactory);
        }
    }
}

