/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.client.util.Lists;
import com.google.common.base.Throwables;
import com.spotify.apollo.Client;
import com.spotify.apollo.Request;
import com.spotify.apollo.RequestContext;
import com.spotify.apollo.Response;
import com.spotify.apollo.entity.EntityCodec;
import com.spotify.apollo.entity.EntityMiddleware;
import com.spotify.apollo.entity.JacksonEntityCodec;
import com.spotify.apollo.route.AsyncHandler;
import com.spotify.apollo.route.Middleware;
import com.spotify.apollo.route.Route;
import com.spotify.styx.api.Api;
import com.spotify.styx.api.Middlewares;
import com.spotify.styx.api.cli.ActiveStatesPayload;
import com.spotify.styx.api.cli.EventsPayload;
import com.spotify.styx.model.Event;
import com.spotify.styx.model.EventSerializer;
import com.spotify.styx.model.EventVisitor;
import com.spotify.styx.model.ExecutionDescription;
import com.spotify.styx.model.SequenceEvent;
import com.spotify.styx.model.WorkflowId;
import com.spotify.styx.model.WorkflowInstance;
import com.spotify.styx.state.RunState;
import com.spotify.styx.storage.EventStorage;
import com.spotify.styx.util.ReplayEvents;
import com.spotify.styx.util.StreamUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedSet;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import okio.ByteString;

public class CliResource {
    public static final String BASE = "/cli";
    public static final String SCHEDULER_BASE_PATH = "/api/v0";
    private final String schedulerServiceBaseUrl;
    private final EventStorage eventStorage;
    private final EventVisitor<Boolean> lastExecutionEventVisitor = new LastExecutionEventVisitor();

    public CliResource(String schedulerServiceBaseUrl, EventStorage eventStorage) {
        this.schedulerServiceBaseUrl = Objects.requireNonNull(schedulerServiceBaseUrl);
        this.eventStorage = Objects.requireNonNull(eventStorage);
    }

    public Stream<? extends Route<? extends AsyncHandler<? extends Response<ByteString>>>> routes() {
        EntityMiddleware em = EntityMiddleware.forCodec((EntityCodec)JacksonEntityCodec.forMapper((ObjectMapper)Middlewares.OBJECT_MAPPER));
        List routes = Stream.of(Route.with((Middleware)em.serializerDirect(ActiveStatesPayload.class), (String)"GET", (String)"/cli/activeStates", this::activeStates), Route.with((Middleware)em.serializerDirect(EventsPayload.class), (String)"GET", (String)"/cli/events/<cid>/<eid>/<iid>", rc -> this.eventsForWorkflowInstance(CliResource.arg("cid", rc), CliResource.arg("eid", rc), CliResource.arg("iid", rc)))).map(r -> r.withMiddleware(Middleware::syncToAsync)).collect(Collectors.toList());
        List<Route> proxies = Arrays.asList(Route.async((String)"POST", (String)"/cli/events", this::injectEventProxy), Route.async((String)"POST", (String)"/cli/trigger", this::triggerWorkflowInstanceProxy));
        return StreamUtil.cat((Stream[])new Stream[]{routes.stream().map(r -> r.withPrefix(Api.Version.V0.prefix())), routes.stream().map(r -> r.withPrefix(Api.Version.V1.prefix())), proxies.stream().map(r -> r.withPrefix(Api.Version.V0.prefix())), proxies.stream().map(r -> r.withPrefix(Api.Version.V1.prefix()))});
    }

    private static String arg(String name, RequestContext rc) {
        return (String)rc.pathArgs().get(name);
    }

    private ActiveStatesPayload activeStates(RequestContext requestContext) {
        Optional componentOpt = requestContext.request().parameter("component");
        ArrayList runStates = Lists.newArrayList();
        try {
            Map activeStates = componentOpt.isPresent() ? this.eventStorage.readActiveWorkflowInstances((String)componentOpt.get()) : this.eventStorage.readActiveWorkflowInstances();
            Map map = ReplayEvents.replayActiveStates((Map)activeStates, (EventStorage)this.eventStorage, (boolean)false);
            runStates.addAll(map.keySet().stream().map(this::runStateToActiveState).collect(Collectors.toList()));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return ActiveStatesPayload.create((List)runStates);
    }

    private ActiveStatesPayload.ActiveState runStateToActiveState(RunState state) {
        return ActiveStatesPayload.ActiveState.create((WorkflowInstance)state.workflowInstance(), (String)state.state().toString(), (String)state.executionId().orElse("<no execution id>"), this.getPreviousExecutionLastEvent(state));
    }

    private Optional<EventSerializer.PersistentEvent> getPreviousExecutionLastEvent(RunState state) {
        Optional<EventSerializer.PersistentEvent> lastEvent;
        try {
            SortedSet sequenceEvents = this.eventStorage.readEvents(state.workflowInstance());
            Optional<SequenceEvent> lastExecutionSequenceEvent = sequenceEvents.stream().filter(sequenceEvent -> (Boolean)sequenceEvent.event().accept(this.lastExecutionEventVisitor)).reduce((a, b) -> b);
            lastEvent = lastExecutionSequenceEvent.isPresent() ? Optional.of(EventSerializer.convertEventToPersistentEvent((Event)lastExecutionSequenceEvent.get().event())) : Optional.empty();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return lastEvent;
    }

    private EventsPayload eventsForWorkflowInstance(String cid, String eid, String iid) {
        WorkflowId workflowId = WorkflowId.create((String)cid, (String)eid);
        WorkflowInstance workflowInstance = WorkflowInstance.create((WorkflowId)workflowId, (String)iid);
        try {
            SortedSet sequenceEvents = this.eventStorage.readEvents(workflowInstance);
            List timestampedPersistentEvents = sequenceEvents.stream().map(sequenceEvent -> EventsPayload.TimestampedPersistentEvent.create((EventSerializer.PersistentEvent)EventSerializer.convertEventToPersistentEvent((Event)sequenceEvent.event()), (long)sequenceEvent.timestamp())).collect(Collectors.toList());
            return EventsPayload.create(timestampedPersistentEvents);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private CompletionStage<Response<ByteString>> injectEventProxy(RequestContext requestContext) {
        Client client = requestContext.requestScopedClient();
        Request proxyRequest = requestContext.request().withUri(this.schedulerServiceBaseUrl + SCHEDULER_BASE_PATH + "/events");
        return client.send(proxyRequest);
    }

    private CompletionStage<Response<ByteString>> triggerWorkflowInstanceProxy(RequestContext requestContext) {
        Client client = requestContext.requestScopedClient();
        Request proxyRequest = requestContext.request().withUri(this.schedulerServiceBaseUrl + SCHEDULER_BASE_PATH + "/trigger");
        return client.send(proxyRequest);
    }

    private class LastExecutionEventVisitor
    implements EventVisitor<Boolean> {
        private LastExecutionEventVisitor() {
        }

        public Boolean timeTrigger(WorkflowInstance workflowInstance) {
            return Boolean.FALSE;
        }

        public Boolean triggerExecution(WorkflowInstance workflowInstance, String triggerId) {
            return Boolean.FALSE;
        }

        public Boolean created(WorkflowInstance workflowInstance, String executionId, String dockerImage) {
            return Boolean.FALSE;
        }

        public Boolean submit(WorkflowInstance workflowInstance, ExecutionDescription executionDescription) {
            return Boolean.FALSE;
        }

        public Boolean submitted(WorkflowInstance workflowInstance, String executionId) {
            return Boolean.FALSE;
        }

        public Boolean started(WorkflowInstance workflowInstance) {
            return Boolean.FALSE;
        }

        public Boolean terminate(WorkflowInstance workflowInstance, int exitCode) {
            return Boolean.TRUE;
        }

        public Boolean runError(WorkflowInstance workflowInstance, String message) {
            return Boolean.TRUE;
        }

        public Boolean success(WorkflowInstance workflowInstance) {
            return Boolean.FALSE;
        }

        public Boolean retryAfter(WorkflowInstance workflowInstance, long delayMillis) {
            return Boolean.FALSE;
        }

        public Boolean retry(WorkflowInstance workflowInstance) {
            return Boolean.FALSE;
        }

        public Boolean stop(WorkflowInstance workflowInstance) {
            return Boolean.FALSE;
        }

        public Boolean timeout(WorkflowInstance workflowInstance) {
            return Boolean.FALSE;
        }

        public Boolean halt(WorkflowInstance workflowInstance) {
            return Boolean.FALSE;
        }
    }
}

