/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Throwables;
import com.spotify.apollo.Request;
import com.spotify.apollo.RequestContext;
import com.spotify.apollo.Response;
import com.spotify.apollo.Status;
import com.spotify.apollo.StatusType;
import com.spotify.apollo.route.AsyncHandler;
import com.spotify.apollo.route.Route;
import com.spotify.styx.api.Api;
import com.spotify.styx.api.Middlewares;
import com.spotify.styx.model.Workflow;
import com.spotify.styx.model.WorkflowId;
import com.spotify.styx.model.WorkflowInstance;
import com.spotify.styx.model.WorkflowInstanceExecutionData;
import com.spotify.styx.model.WorkflowState;
import com.spotify.styx.storage.Storage;
import com.spotify.styx.util.Json;
import com.spotify.styx.util.ResourceNotFoundException;
import com.spotify.styx.util.StreamUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import okio.ByteString;

public final class WorkflowResource {
    public static final String BASE = "/workflows";
    public static final ObjectMapper OBJECT_MAPPER = Json.OBJECT_MAPPER;
    private final Storage storage;

    public WorkflowResource(Storage storage) {
        this.storage = Objects.requireNonNull(storage);
    }

    public Stream<? extends Route<? extends AsyncHandler<? extends Response<ByteString>>>> routes() {
        List<Route> v0 = Arrays.asList(Route.with(Middlewares.json(), (String)"GET", (String)"/workflows/<cid>/<eid>", rc -> this.workflow(WorkflowResource.arg("cid", rc), WorkflowResource.arg("eid", rc))), Route.with(Middlewares.json(), (String)"GET", (String)"/workflows/<cid>/<eid>/instances", rc -> Response.forStatus((StatusType)Status.NOT_FOUND.withReasonPhrase("Use v1 api"))), Route.with(Middlewares.json(), (String)"GET", (String)"/workflows/<cid>/<eid>/instances/<iid>", rc -> Response.forStatus((StatusType)Status.NOT_FOUND.withReasonPhrase("Use v1 api"))), Route.with(Middlewares.json(), (String)"GET", (String)"/workflows/<cid>/<eid>/state", rc -> this.state(WorkflowResource.arg("cid", rc), WorkflowResource.arg("eid", rc))), Route.with(Middlewares.json(), (String)"PATCH", (String)"/workflows/<cid>/<eid>/state", rc -> this.patchState(WorkflowResource.arg("cid", rc), WorkflowResource.arg("eid", rc), rc.request())), Route.with(Middlewares.json(), (String)"PATCH", (String)"/workflows/<cid>/state", rc -> this.patchState(WorkflowResource.arg("cid", rc), rc.request())));
        List<Route> v1 = Arrays.asList(Route.with(Middlewares.json(), (String)"GET", (String)"/workflows/<cid>/<eid>/instances", rc -> this.instances(WorkflowResource.arg("cid", rc), WorkflowResource.arg("eid", rc))), Route.with(Middlewares.json(), (String)"GET", (String)"/workflows/<cid>/<eid>/instances/<iid>", rc -> this.instance(WorkflowResource.arg("cid", rc), WorkflowResource.arg("eid", rc), WorkflowResource.arg("iid", rc))));
        return StreamUtil.cat((Stream[])new Stream[]{v0.stream().map(r -> r.withPrefix(Api.Version.V0.prefix())), v0.stream().map(r -> r.withPrefix(Api.Version.V1.prefix())), v1.stream().map(r -> r.withPrefix(Api.Version.V1.prefix()))});
    }

    private Response<WorkflowState> patchState(String componentId, String endpointId, Request request) {
        WorkflowState patchState;
        Optional payload = request.payload();
        if (!payload.isPresent()) {
            return Response.forStatus((StatusType)Status.BAD_REQUEST.withReasonPhrase("Missing payload."));
        }
        WorkflowId workflowId = WorkflowId.create((String)componentId, (String)endpointId);
        try {
            patchState = (WorkflowState)OBJECT_MAPPER.readValue(((ByteString)payload.get()).toByteArray(), WorkflowState.class);
        }
        catch (IOException e) {
            return Response.forStatus((StatusType)Status.BAD_REQUEST.withReasonPhrase("Invalid payload."));
        }
        if (patchState.commitSha().isPresent() && !WorkflowResource.isValidSHA1((String)patchState.commitSha().get())) {
            return Response.forStatus((StatusType)Status.BAD_REQUEST.withReasonPhrase("Invalid SHA-1."));
        }
        try {
            this.storage.patchState(workflowId, patchState);
        }
        catch (ResourceNotFoundException e) {
            return Response.forStatus((StatusType)Status.NOT_FOUND.withReasonPhrase(e.getMessage()));
        }
        catch (IOException e) {
            return Response.forStatus((StatusType)Status.INTERNAL_SERVER_ERROR.withReasonPhrase("Failed to update the state."));
        }
        return this.state(componentId, endpointId);
    }

    private Response<WorkflowState> patchState(String componentId, Request request) {
        WorkflowState patchState;
        Optional payload = request.payload();
        if (!payload.isPresent()) {
            return Response.forStatus((StatusType)Status.BAD_REQUEST.withReasonPhrase("Missing payload."));
        }
        try {
            patchState = (WorkflowState)OBJECT_MAPPER.readValue(((ByteString)payload.get()).toByteArray(), WorkflowState.class);
        }
        catch (IOException e) {
            return Response.forStatus((StatusType)Status.BAD_REQUEST.withReasonPhrase("Invalid payload."));
        }
        if (patchState.enabled().isPresent()) {
            return Response.forStatus((StatusType)Status.BAD_REQUEST.withReasonPhrase("Enabled flag not supported for components."));
        }
        if (patchState.commitSha().isPresent() && !WorkflowResource.isValidSHA1((String)patchState.commitSha().get())) {
            return Response.forStatus((StatusType)Status.BAD_REQUEST.withReasonPhrase("Invalid SHA-1."));
        }
        try {
            this.storage.patchState(componentId, patchState);
        }
        catch (ResourceNotFoundException e) {
            return Response.forStatus((StatusType)Status.NOT_FOUND.withReasonPhrase(e.getMessage()));
        }
        catch (IOException e) {
            return Response.forStatus((StatusType)Status.INTERNAL_SERVER_ERROR.withReasonPhrase("Failed to update the state."));
        }
        return Response.forPayload((Object)patchState);
    }

    private Response<Workflow> workflow(String componentId, String endpointId) {
        Optional workflowOpt;
        WorkflowId workflowId = WorkflowId.create((String)componentId, (String)endpointId);
        try {
            workflowOpt = this.storage.workflow(workflowId);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        if (!workflowOpt.isPresent()) {
            return Response.forStatus((StatusType)Status.NOT_FOUND);
        }
        return Response.forPayload(workflowOpt.get());
    }

    private Response<WorkflowState> state(String componentId, String endpointId) {
        WorkflowState workflowState;
        WorkflowId workflowId = WorkflowId.create((String)componentId, (String)endpointId);
        try {
            workflowState = this.storage.workflowState(workflowId);
        }
        catch (IOException e) {
            return Response.forStatus((StatusType)Status.INTERNAL_SERVER_ERROR.withReasonPhrase("Couldn't fetch state."));
        }
        return Response.forPayload((Object)workflowState);
    }

    private Response<List<WorkflowInstanceExecutionData>> instances(String componentId, String endpointId) {
        List data;
        WorkflowId workflowId = WorkflowId.create((String)componentId, (String)endpointId);
        try {
            data = this.storage.executionData(workflowId);
        }
        catch (IOException e) {
            return Response.forStatus((StatusType)Status.INTERNAL_SERVER_ERROR.withReasonPhrase("Couldn't fetch execution info."));
        }
        return Response.forPayload((Object)data);
    }

    private Response<WorkflowInstanceExecutionData> instance(String componentId, String endpointId, String instanceId) {
        WorkflowId workflowId = WorkflowId.create((String)componentId, (String)endpointId);
        WorkflowInstance workflowInstance = WorkflowInstance.create((WorkflowId)workflowId, (String)instanceId);
        try {
            WorkflowInstanceExecutionData workflowInstanceExecutionData = this.storage.executionData(workflowInstance);
            return Response.forPayload((Object)workflowInstanceExecutionData);
        }
        catch (IOException e) {
            return Response.forStatus((StatusType)Status.INTERNAL_SERVER_ERROR.withReasonPhrase("Couldn't fetch execution info."));
        }
    }

    private static boolean isValidSHA1(String s) {
        return s.matches("[a-fA-F0-9]{40}");
    }

    private static String arg(String name, RequestContext rc) {
        return (String)rc.pathArgs().get(name);
    }
}

