/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Throwables;
import com.spotify.apollo.RequestContext;
import com.spotify.apollo.Response;
import com.spotify.apollo.Status;
import com.spotify.apollo.StatusType;
import com.spotify.apollo.entity.EntityCodec;
import com.spotify.apollo.entity.EntityMiddleware;
import com.spotify.apollo.entity.JacksonEntityCodec;
import com.spotify.apollo.route.AsyncHandler;
import com.spotify.apollo.route.Middleware;
import com.spotify.apollo.route.Route;
import com.spotify.styx.api.Api;
import com.spotify.styx.api.BackfillPayload;
import com.spotify.styx.api.BackfillsPayload;
import com.spotify.styx.api.cli.RunStateDataPayload;
import com.spotify.styx.model.Backfill;
import com.spotify.styx.model.BackfillBuilder;
import com.spotify.styx.model.BackfillInput;
import com.spotify.styx.model.Partitioning;
import com.spotify.styx.model.Workflow;
import com.spotify.styx.model.WorkflowId;
import com.spotify.styx.model.WorkflowInstance;
import com.spotify.styx.serialization.Json;
import com.spotify.styx.state.RunState;
import com.spotify.styx.state.StateData;
import com.spotify.styx.storage.Storage;
import com.spotify.styx.util.ParameterUtil;
import com.spotify.styx.util.RandomGenerator;
import com.spotify.styx.util.ReplayEvents;
import java.io.IOException;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import okio.ByteString;

public final class BackfillResource {
    static final String BASE = "/backfills";
    private final Storage storage;

    public BackfillResource(Storage storage) {
        this.storage = Objects.requireNonNull(storage);
    }

    public Stream<? extends Route<? extends AsyncHandler<? extends Response<ByteString>>>> routes() {
        EntityMiddleware em = EntityMiddleware.forCodec((EntityCodec)JacksonEntityCodec.forMapper((ObjectMapper)Json.OBJECT_MAPPER));
        List<Route<AsyncHandler<Response<ByteString>>>> routes = Stream.of(Route.with((Middleware)em.serializerDirect(BackfillsPayload.class), (String)"GET", (String)BASE, this::getBackfills), Route.with((Middleware)em.response(BackfillInput.class, Backfill.class), (String)"POST", (String)BASE, rc -> this::postBackfill), Route.with((Middleware)em.serializerResponse(BackfillPayload.class), (String)"GET", (String)"/backfills/<bid>", rc -> this.getBackfill(BackfillResource.arg("bid", rc))), Route.with((Middleware)em.serializerResponse(Void.class), (String)"DELETE", (String)"/backfills/<bid>", rc -> this.haltBackfill(BackfillResource.arg("bid", rc))), Route.with((Middleware)em.response(Backfill.class), (String)"PUT", (String)"/backfills/<bid>", rc -> payload -> this.updateBackfill(BackfillResource.arg("bid", rc), (Backfill)payload))).map(r -> r.withMiddleware(Middleware::syncToAsync)).collect(Collectors.toList());
        return Api.prefixRoutes(routes, Api.Version.V1);
    }

    private BackfillsPayload getBackfills(RequestContext requestContext) {
        Stream<Object> backfills;
        Optional componentOpt = requestContext.request().parameter("component");
        Optional workflowOpt = requestContext.request().parameter("workflow");
        Optional statusesFlagOpt = requestContext.request().parameter("status");
        try {
            backfills = this.storage.backfills().stream();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        if (componentOpt.isPresent()) {
            String component = (String)componentOpt.get();
            backfills = backfills.filter(backfill -> backfill.workflowId().componentId().equals(component));
        }
        if (workflowOpt.isPresent()) {
            String workflow = (String)workflowOpt.get();
            backfills = backfills.filter(backfill -> backfill.workflowId().endpointId().equals(workflow));
        }
        List backfillPayloads = backfills.map(backfill -> BackfillPayload.create((Backfill)backfill, "true".equals(statusesFlagOpt.orElse("false")) ? Optional.of(RunStateDataPayload.create(this.retrieveBackfillStatuses((Backfill)backfill))) : Optional.empty())).collect(Collectors.toList());
        return BackfillsPayload.create(backfillPayloads);
    }

    private Response<BackfillPayload> getBackfill(String id) {
        try {
            Optional backfillOpt = this.storage.backfill(id);
            if (backfillOpt.isPresent()) {
                List<RunStateDataPayload.RunStateData> statuses = this.retrieveBackfillStatuses((Backfill)backfillOpt.get());
                return Response.forPayload((Object)BackfillPayload.create((Backfill)((Backfill)backfillOpt.get()), Optional.of(RunStateDataPayload.create(statuses))));
            }
            return Response.forStatus((StatusType)Status.NOT_FOUND);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private Response<Void> haltBackfill(String id) {
        try {
            Optional backfillOptional = this.storage.backfill(id);
            if (!backfillOptional.isPresent()) {
                return Response.forStatus((StatusType)Status.NOT_FOUND.withReasonPhrase("backfill not found"));
            }
            this.storage.storeBackfill(((Backfill)backfillOptional.get()).builder().halted(true).build());
        }
        catch (IOException e) {
            return Response.forStatus((StatusType)Status.INTERNAL_SERVER_ERROR.withReasonPhrase("could not halt backfill: " + e.getMessage()));
        }
        return Response.ok();
    }

    private Response<Backfill> postBackfill(BackfillInput input) {
        Partitioning partitioning;
        Set activeWorkflowInstances;
        BackfillBuilder builder = Backfill.newBuilder();
        String id = RandomGenerator.DEFAULT.generateUniqueId("backfill");
        WorkflowId workflowId = WorkflowId.create((String)input.component(), (String)input.workflow());
        try {
            activeWorkflowInstances = this.storage.readActiveWorkflowInstances(input.component()).keySet();
            Optional workflowOpt = this.storage.workflow(workflowId);
            if (!workflowOpt.isPresent()) {
                return Response.forStatus((StatusType)Status.NOT_FOUND.withReasonPhrase("workflow not found"));
            }
            partitioning = ((Workflow)workflowOpt.get()).schedule().partitioning();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        if (ParameterUtil.truncateInstant((Instant)input.start(), (Partitioning)partitioning) != input.start()) {
            return Response.forStatus((StatusType)Status.BAD_REQUEST.withReasonPhrase("start parameter not aligned with partitioning"));
        }
        if (ParameterUtil.truncateInstant((Instant)input.end(), (Partitioning)partitioning) != input.end()) {
            return Response.forStatus((StatusType)Status.BAD_REQUEST.withReasonPhrase("end parameter not aligned with partitioning"));
        }
        List alreadyActive = ParameterUtil.rangeOfInstants((Instant)input.start(), (Instant)input.end(), (Partitioning)partitioning).stream().map(instant -> WorkflowInstance.create((WorkflowId)workflowId, (String)ParameterUtil.toParameter((Partitioning)partitioning, (Instant)instant))).filter(activeWorkflowInstances::contains).collect(Collectors.toList());
        if (!alreadyActive.isEmpty()) {
            String alreadyActiveMessage = alreadyActive.stream().map(WorkflowInstance::parameter).collect(Collectors.joining(", "));
            return Response.forStatus((StatusType)Status.CONFLICT.withReasonPhrase("these partitions are already active: " + alreadyActiveMessage));
        }
        builder.id(id).completed(false).workflowId(workflowId).concurrency(input.concurrency()).start(input.start()).end(input.end()).partitioning(partitioning).nextTrigger(input.start()).halted(false);
        Backfill backfill = builder.build();
        try {
            this.storage.storeBackfill(backfill);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return Response.forPayload((Object)backfill);
    }

    private Response<Backfill> updateBackfill(String id, Backfill backfill) {
        if (!backfill.id().equals(id)) {
            return Response.forStatus((StatusType)Status.BAD_REQUEST.withReasonPhrase("ID of payload does not match ID in uri."));
        }
        try {
            this.storage.storeBackfill(backfill);
        }
        catch (IOException e) {
            return Response.forStatus((StatusType)Status.INTERNAL_SERVER_ERROR.withReasonPhrase("Failed to store backfill."));
        }
        return Response.forStatus((StatusType)Status.OK).withPayload((Object)backfill);
    }

    private List<RunStateDataPayload.RunStateData> retrieveBackfillStatuses(Backfill backfill) {
        List processedInstants = ParameterUtil.rangeOfInstants((Instant)backfill.start(), (Instant)backfill.nextTrigger(), (Partitioning)backfill.partitioning());
        List processedStates = processedInstants.stream().map(instant -> {
            WorkflowInstance wfi = WorkflowInstance.create((WorkflowId)backfill.workflowId(), (String)ParameterUtil.toParameter((Partitioning)backfill.partitioning(), (Instant)instant));
            Optional restoredStateOpt = ReplayEvents.getBackfillRunState((WorkflowInstance)wfi, (Storage)this.storage, (String)backfill.id());
            if (restoredStateOpt.isPresent()) {
                RunState state = (RunState)restoredStateOpt.get();
                return RunStateDataPayload.RunStateData.create((WorkflowInstance)state.workflowInstance(), (String)state.state().name(), (StateData)state.data());
            }
            return RunStateDataPayload.RunStateData.create((WorkflowInstance)wfi, (String)"UNKNOWN", (StateData)StateData.zero());
        }).collect(Collectors.toList());
        List waitingInstants = ParameterUtil.rangeOfInstants((Instant)backfill.nextTrigger(), (Instant)backfill.end(), (Partitioning)backfill.partitioning());
        List waitingStates = waitingInstants.stream().map(instant -> {
            WorkflowInstance wfi = WorkflowInstance.create((WorkflowId)backfill.workflowId(), (String)ParameterUtil.toParameter((Partitioning)backfill.partitioning(), (Instant)instant));
            return RunStateDataPayload.RunStateData.create((WorkflowInstance)wfi, (String)"WAITING", (StateData)StateData.zero());
        }).collect(Collectors.toList());
        return Stream.concat(processedStates.stream(), waitingStates.stream()).collect(Collectors.toList());
    }

    private static String arg(String name, RequestContext rc) {
        return (String)rc.pathArgs().get(name);
    }
}

