/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.client.util.Lists;
import com.google.common.base.Throwables;
import com.spotify.apollo.RequestContext;
import com.spotify.apollo.Response;
import com.spotify.apollo.entity.EntityCodec;
import com.spotify.apollo.entity.EntityMiddleware;
import com.spotify.apollo.entity.JacksonEntityCodec;
import com.spotify.apollo.route.AsyncHandler;
import com.spotify.apollo.route.Middleware;
import com.spotify.apollo.route.Route;
import com.spotify.styx.api.Api;
import com.spotify.styx.api.cli.EventsPayload;
import com.spotify.styx.api.cli.RunStateDataPayload;
import com.spotify.styx.model.Event;
import com.spotify.styx.model.WorkflowId;
import com.spotify.styx.model.WorkflowInstance;
import com.spotify.styx.serialization.Json;
import com.spotify.styx.state.RunState;
import com.spotify.styx.state.StateData;
import com.spotify.styx.storage.Storage;
import com.spotify.styx.util.ReplayEvents;
import com.spotify.styx.util.StreamUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedSet;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import okio.ByteString;

public class CliResource {
    public static final String BASE = "/cli";
    public static final String SCHEDULER_BASE_PATH = "/api/v0";
    private final String schedulerServiceBaseUrl;
    private final Storage storage;

    public CliResource(String schedulerServiceBaseUrl, Storage storage) {
        this.schedulerServiceBaseUrl = Objects.requireNonNull(schedulerServiceBaseUrl);
        this.storage = Objects.requireNonNull(storage);
    }

    public Stream<? extends Route<? extends AsyncHandler<? extends Response<ByteString>>>> routes() {
        EntityMiddleware em = EntityMiddleware.forCodec((EntityCodec)JacksonEntityCodec.forMapper((ObjectMapper)Json.OBJECT_MAPPER));
        List<Route<AsyncHandler<Response<ByteString>>>> routes = Stream.of(Route.with((Middleware)em.serializerDirect(RunStateDataPayload.class), (String)"GET", (String)"/cli/activeStates", this::activeStates), Route.with((Middleware)em.serializerDirect(EventsPayload.class), (String)"GET", (String)"/cli/events/<cid>/<eid>/<iid>", rc -> this.eventsForWorkflowInstance(CliResource.arg("cid", rc), CliResource.arg("eid", rc), CliResource.arg("iid", rc)))).map(r -> r.withMiddleware(Middleware::syncToAsync)).collect(Collectors.toList());
        List<Route<AsyncHandler<Response<ByteString>>>> schedulerProxies = Arrays.asList(Route.async((String)"GET", (String)"/cli/<endpoint:path>", rc -> this.proxyToScheduler("/" + CliResource.arg("endpoint", rc), rc)), Route.async((String)"POST", (String)"/cli/<endpoint:path>", rc -> this.proxyToScheduler("/" + CliResource.arg("endpoint", rc), rc)), Route.async((String)"DELETE", (String)"/cli/<endpoint:path>", rc -> this.proxyToScheduler("/" + CliResource.arg("endpoint", rc), rc)), Route.async((String)"PATCH", (String)"/cli/<endpoint:path>", rc -> this.proxyToScheduler("/" + CliResource.arg("endpoint", rc), rc)), Route.async((String)"PUT", (String)"/cli/<endpoint:path>", rc -> this.proxyToScheduler("/" + CliResource.arg("endpoint", rc), rc)));
        return StreamUtil.cat((Stream[])new Stream[]{Api.prefixRoutes(routes, Api.Version.V0, Api.Version.V1), Api.prefixRoutes(schedulerProxies, Api.Version.V0, Api.Version.V1)});
    }

    private CompletionStage<Response<ByteString>> proxyToScheduler(String path, RequestContext rc) {
        return rc.requestScopedClient().send(rc.request().withUri(this.schedulerServiceBaseUrl + SCHEDULER_BASE_PATH + path));
    }

    private static String arg(String name, RequestContext rc) {
        return (String)rc.pathArgs().get(name);
    }

    private RunStateDataPayload activeStates(RequestContext requestContext) {
        Optional componentOpt = requestContext.request().parameter("component");
        ArrayList runStates = Lists.newArrayList();
        try {
            Map activeStates = componentOpt.isPresent() ? this.storage.readActiveWorkflowInstances((String)componentOpt.get()) : this.storage.readActiveWorkflowInstances();
            Map map = ReplayEvents.replayActiveStates((Map)activeStates, (Storage)this.storage, (boolean)false);
            runStates.addAll(map.keySet().stream().map(this::runStateToRunStateData).collect(Collectors.toList()));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return RunStateDataPayload.create((List)runStates);
    }

    private RunStateDataPayload.RunStateData runStateToRunStateData(RunState state) {
        return RunStateDataPayload.RunStateData.create((WorkflowInstance)state.workflowInstance(), (String)state.state().toString(), (StateData)state.data());
    }

    private EventsPayload eventsForWorkflowInstance(String cid, String eid, String iid) {
        WorkflowId workflowId = WorkflowId.create((String)cid, (String)eid);
        WorkflowInstance workflowInstance = WorkflowInstance.create((WorkflowId)workflowId, (String)iid);
        try {
            SortedSet sequenceEvents = this.storage.readEvents(workflowInstance);
            List timestampedEvents = sequenceEvents.stream().map(sequenceEvent -> EventsPayload.TimestampedEvent.create((Event)sequenceEvent.event(), (long)sequenceEvent.timestamp())).collect(Collectors.toList());
            return EventsPayload.create(timestampedEvents);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

