/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.spotify.apollo.Response;
import com.spotify.apollo.Status;
import com.spotify.apollo.StatusType;
import com.spotify.apollo.route.AsyncHandler;
import com.spotify.apollo.route.Middleware;
import com.spotify.apollo.route.SyncHandler;
import com.spotify.styx.serialization.Json;
import okio.ByteString;

public final class Middlewares {
    private Middlewares() {
    }

    public static Middleware<SyncHandler<? extends Response<?>>, AsyncHandler<Response<ByteString>>> json() {
        return innerHandler -> (AsyncHandler)Middlewares.jsonAsync().apply((Object)Middleware.syncToAsync((SyncHandler)innerHandler));
    }

    public static Middleware<AsyncHandler<? extends Response<?>>, AsyncHandler<Response<ByteString>>> jsonAsync() {
        return innerHandler -> innerHandler.map(response -> {
            if (!response.payload().isPresent()) {
                return response;
            }
            Object tPayload = response.payload().get();
            try {
                byte[] bytes = Json.OBJECT_MAPPER.writeValueAsBytes(tPayload);
                ByteString payload = ByteString.of((byte[])bytes);
                return response.withPayload((Object)payload).withHeader("Content-Type", "application/json");
            }
            catch (JsonProcessingException e) {
                return Response.forStatus((StatusType)Status.INTERNAL_SERVER_ERROR.withReasonPhrase("Failed to serialize response " + e.getMessage()));
            }
        });
    }
}

