/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Throwables;
import com.spotify.apollo.Client;
import com.spotify.apollo.Request;
import com.spotify.apollo.RequestContext;
import com.spotify.apollo.Response;
import com.spotify.apollo.Status;
import com.spotify.apollo.StatusType;
import com.spotify.apollo.entity.EntityCodec;
import com.spotify.apollo.entity.EntityMiddleware;
import com.spotify.apollo.entity.JacksonEntityCodec;
import com.spotify.apollo.route.AsyncHandler;
import com.spotify.apollo.route.Middleware;
import com.spotify.apollo.route.Route;
import com.spotify.futures.CompletableFutures;
import com.spotify.styx.api.Api;
import com.spotify.styx.api.BackfillPayload;
import com.spotify.styx.api.BackfillsPayload;
import com.spotify.styx.api.RunStateDataPayload;
import com.spotify.styx.model.Backfill;
import com.spotify.styx.model.BackfillBuilder;
import com.spotify.styx.model.BackfillInput;
import com.spotify.styx.model.Event;
import com.spotify.styx.model.Schedule;
import com.spotify.styx.model.Workflow;
import com.spotify.styx.model.WorkflowId;
import com.spotify.styx.model.WorkflowInstance;
import com.spotify.styx.serialization.Json;
import com.spotify.styx.state.RunState;
import com.spotify.styx.state.StateData;
import com.spotify.styx.storage.Storage;
import com.spotify.styx.util.ParameterUtil;
import com.spotify.styx.util.RandomGenerator;
import com.spotify.styx.util.ReplayEvents;
import com.spotify.styx.util.StreamUtil;
import com.spotify.styx.util.TimeUtil;
import java.io.IOException;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import okio.ByteString;

public final class BackfillResource {
    static final String BASE = "/backfills";
    private static final String SCHEDULER_BASE_PATH = "/api/v0";
    private static final String UNKNOWN = "UNKNOWN";
    private static final String WAITING = "WAITING";
    private final Storage storage;
    private final String schedulerServiceBaseUrl;

    public BackfillResource(String schedulerServiceBaseUrl, Storage storage) {
        this.schedulerServiceBaseUrl = Objects.requireNonNull(schedulerServiceBaseUrl);
        this.storage = Objects.requireNonNull(storage);
    }

    public Stream<? extends Route<? extends AsyncHandler<? extends Response<ByteString>>>> routes() {
        EntityMiddleware em = EntityMiddleware.forCodec((EntityCodec)JacksonEntityCodec.forMapper((ObjectMapper)Json.OBJECT_MAPPER));
        List<Route<AsyncHandler<Response<ByteString>>>> entityRoutes = Stream.of(Route.with((Middleware)em.serializerDirect(BackfillsPayload.class), (String)"GET", (String)BASE, this::getBackfills), Route.with((Middleware)em.response(BackfillInput.class, Backfill.class), (String)"POST", (String)BASE, rc -> this::postBackfill), Route.with((Middleware)em.serializerResponse(BackfillPayload.class), (String)"GET", (String)"/backfills/<bid>", rc -> this.getBackfill((String)rc.pathArgs().get("bid"))), Route.with((Middleware)em.response(Backfill.class), (String)"PUT", (String)"/backfills/<bid>", rc -> payload -> this.updateBackfill((String)rc.pathArgs().get("bid"), (Backfill)payload))).map(r -> r.withMiddleware(Middleware::syncToAsync)).collect(Collectors.toList());
        List<Route<AsyncHandler<Response<ByteString>>>> routes = Collections.singletonList(Route.async((String)"DELETE", (String)"/backfills/<bid>", rc -> this.haltBackfill((String)rc.pathArgs().get("bid"), rc)));
        return StreamUtil.cat((Stream[])new Stream[]{Api.prefixRoutes(entityRoutes, Api.Version.V2), Api.prefixRoutes(routes, Api.Version.V2)});
    }

    public BackfillsPayload getBackfills(RequestContext rc) {
        Stream backfills;
        Optional componentOpt = rc.request().parameter("component");
        Optional workflowOpt = rc.request().parameter("workflow");
        boolean includeStatuses = rc.request().parameter("status").orElse("false").equals("true");
        boolean showAll = rc.request().parameter("showAll").orElse("false").equals("true");
        try {
            if (componentOpt.isPresent() && workflowOpt.isPresent()) {
                WorkflowId workflowId = WorkflowId.create((String)((String)componentOpt.get()), (String)((String)workflowOpt.get()));
                backfills = this.storage.backfillsForWorkflowId(showAll, workflowId).stream();
            } else if (componentOpt.isPresent()) {
                String component = (String)componentOpt.get();
                backfills = this.storage.backfillsForComponent(showAll, component).stream();
            } else if (workflowOpt.isPresent()) {
                String workflow = (String)workflowOpt.get();
                backfills = this.storage.backfillsForWorkflow(showAll, workflow).stream();
            } else {
                backfills = this.storage.backfills(showAll).stream();
            }
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        List backfillPayloads = ((Stream)backfills.parallel()).map(backfill -> BackfillPayload.create((Backfill)backfill, includeStatuses ? Optional.of(RunStateDataPayload.create(this.retrieveBackfillStatuses((Backfill)backfill))) : Optional.empty())).collect(Collectors.toList());
        return BackfillsPayload.create(backfillPayloads);
    }

    public Response<BackfillPayload> getBackfill(String id) {
        try {
            Optional backfillOpt = this.storage.backfill(id);
            if (backfillOpt.isPresent()) {
                List<RunStateDataPayload.RunStateData> statuses = this.retrieveBackfillStatuses((Backfill)backfillOpt.get());
                return Response.forPayload((Object)BackfillPayload.create((Backfill)((Backfill)backfillOpt.get()), Optional.of(RunStateDataPayload.create(statuses))));
            }
            return Response.forStatus((StatusType)Status.NOT_FOUND);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private String schedulerApiUrl(CharSequence ... parts) {
        return this.schedulerServiceBaseUrl + SCHEDULER_BASE_PATH + "/" + String.join((CharSequence)"/", parts);
    }

    public CompletionStage<Response<ByteString>> haltBackfill(String id, RequestContext rc) {
        try {
            Optional backfillOptional = this.storage.backfill(id);
            if (backfillOptional.isPresent()) {
                Backfill backfill = (Backfill)backfillOptional.get();
                this.storage.storeBackfill(backfill.builder().halted(true).build());
                return this.haltActiveBackfillInstances(backfill, rc.requestScopedClient());
            }
            return CompletableFuture.completedFuture(Response.forStatus((StatusType)Status.NOT_FOUND.withReasonPhrase("backfill not found")));
        }
        catch (IOException e) {
            return CompletableFuture.completedFuture(Response.forStatus((StatusType)Status.INTERNAL_SERVER_ERROR.withReasonPhrase("could not halt backfill: " + e.getMessage())));
        }
    }

    private CompletionStage<Response<ByteString>> haltActiveBackfillInstances(Backfill backfill, Client client) {
        return CompletableFutures.allAsList(this.retrieveBackfillStatuses(backfill).stream().filter(BackfillResource::isActiveState).map(RunStateDataPayload.RunStateData::workflowInstance).map(workflowInstance -> this.haltActiveBackfillInstance((WorkflowInstance)workflowInstance, client)).collect(Collectors.toList())).handle((result, throwable) -> {
            if (throwable != null || result.contains(Boolean.FALSE)) {
                return Response.forStatus((StatusType)Status.INTERNAL_SERVER_ERROR.withReasonPhrase("some active instances cannot be halted, however no new ones will be triggered"));
            }
            return Response.ok();
        });
    }

    private CompletionStage<Boolean> haltActiveBackfillInstance(WorkflowInstance workflowInstance, Client client) {
        try {
            ByteString payload = Json.serialize((Object)Event.halt((WorkflowInstance)workflowInstance));
            Request request = Request.forUri((String)this.schedulerApiUrl("events"), (String)"POST").withPayload(payload);
            return client.send(request).thenApply(response -> response.status().family().equals((Object)StatusType.Family.SUCCESSFUL));
        }
        catch (JsonProcessingException e) {
            return CompletableFuture.completedFuture(false);
        }
    }

    private static boolean isActiveState(RunStateDataPayload.RunStateData runStateData) {
        String state;
        switch (state = runStateData.state()) {
            case "UNKNOWN": {
                return false;
            }
            case "WAITING": {
                return false;
            }
        }
        return !RunState.State.valueOf((String)state).isTerminal();
    }

    public Response<Backfill> postBackfill(BackfillInput input) {
        Schedule schedule;
        Set activeWorkflowInstances;
        BackfillBuilder builder = Backfill.newBuilder();
        String id = RandomGenerator.DEFAULT.generateUniqueId("backfill");
        WorkflowId workflowId = WorkflowId.create((String)input.component(), (String)input.workflow());
        try {
            activeWorkflowInstances = this.storage.readActiveWorkflowInstances(input.component()).keySet();
            Optional workflowOpt = this.storage.workflow(workflowId);
            if (!workflowOpt.isPresent()) {
                return Response.forStatus((StatusType)Status.NOT_FOUND.withReasonPhrase("workflow not found"));
            }
            schedule = ((Workflow)workflowOpt.get()).configuration().schedule();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        if (!TimeUtil.isAligned((Instant)input.start(), (Schedule)schedule)) {
            return Response.forStatus((StatusType)Status.BAD_REQUEST.withReasonPhrase("start parameter not aligned with schedule"));
        }
        if (!TimeUtil.isAligned((Instant)input.end(), (Schedule)schedule)) {
            return Response.forStatus((StatusType)Status.BAD_REQUEST.withReasonPhrase("end parameter not aligned with schedule"));
        }
        List alreadyActive = ParameterUtil.rangeOfInstants((Instant)input.start(), (Instant)input.end(), (Schedule)schedule).stream().map(instant -> WorkflowInstance.create((WorkflowId)workflowId, (String)ParameterUtil.toParameter((Schedule)schedule, (Instant)instant))).filter(activeWorkflowInstances::contains).collect(Collectors.toList());
        if (!alreadyActive.isEmpty()) {
            String alreadyActiveMessage = alreadyActive.stream().map(WorkflowInstance::parameter).collect(Collectors.joining(", "));
            return Response.forStatus((StatusType)Status.CONFLICT.withReasonPhrase("these partitions are already active: " + alreadyActiveMessage));
        }
        builder.id(id).allTriggered(false).workflowId(workflowId).concurrency(input.concurrency()).start(input.start()).end(input.end()).schedule(schedule).nextTrigger(input.start()).halted(false);
        Backfill backfill = builder.build();
        try {
            this.storage.storeBackfill(backfill);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return Response.forPayload((Object)backfill);
    }

    public Response<Backfill> updateBackfill(String id, Backfill backfill) {
        if (!backfill.id().equals(id)) {
            return Response.forStatus((StatusType)Status.BAD_REQUEST.withReasonPhrase("ID of payload does not match ID in uri."));
        }
        try {
            this.storage.storeBackfill(backfill);
        }
        catch (IOException e) {
            return Response.forStatus((StatusType)Status.INTERNAL_SERVER_ERROR.withReasonPhrase("Failed to store backfill."));
        }
        return Response.forStatus((StatusType)Status.OK).withPayload((Object)backfill);
    }

    private List<RunStateDataPayload.RunStateData> retrieveBackfillStatuses(Backfill backfill) {
        Map activeWorkflowInstances;
        try {
            activeWorkflowInstances = this.storage.readActiveWorkflowInstances();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        List processedInstants = ParameterUtil.rangeOfInstants((Instant)backfill.start(), (Instant)backfill.nextTrigger(), (Schedule)backfill.schedule());
        List processedStates = processedInstants.parallelStream().map(instant -> {
            WorkflowInstance wfi = WorkflowInstance.create((WorkflowId)backfill.workflowId(), (String)ParameterUtil.toParameter((Schedule)backfill.schedule(), (Instant)instant));
            Optional restoredStateOpt = ReplayEvents.getBackfillRunState((WorkflowInstance)wfi, (Map)activeWorkflowInstances, (Storage)this.storage, (String)backfill.id());
            if (restoredStateOpt.isPresent()) {
                RunState state = (RunState)restoredStateOpt.get();
                return RunStateDataPayload.RunStateData.create((WorkflowInstance)state.workflowInstance(), (String)state.state().name(), (StateData)state.data());
            }
            return RunStateDataPayload.RunStateData.create((WorkflowInstance)wfi, (String)UNKNOWN, (StateData)StateData.zero());
        }).collect(Collectors.toList());
        List waitingInstants = ParameterUtil.rangeOfInstants((Instant)backfill.nextTrigger(), (Instant)backfill.end(), (Schedule)backfill.schedule());
        List waitingStates = waitingInstants.stream().map(instant -> {
            WorkflowInstance wfi = WorkflowInstance.create((WorkflowId)backfill.workflowId(), (String)ParameterUtil.toParameter((Schedule)backfill.schedule(), (Instant)instant));
            return RunStateDataPayload.RunStateData.create((WorkflowInstance)wfi, (String)WAITING, (StateData)StateData.zero());
        }).collect(Collectors.toList());
        return Stream.concat(processedStates.stream(), waitingStates.stream()).collect(Collectors.toList());
    }
}

