/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.ImmutableList;
import com.spotify.apollo.RequestContext;
import com.spotify.apollo.Response;
import com.spotify.apollo.Status;
import com.spotify.apollo.StatusType;
import com.spotify.apollo.route.AsyncHandler;
import com.spotify.apollo.route.Middleware;
import com.spotify.apollo.route.SyncHandler;
import com.spotify.styx.serialization.Json;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import okio.ByteString;

public final class Middlewares {
    private Middlewares() {
    }

    public static Middleware<SyncHandler<? extends Response<?>>, AsyncHandler<Response<ByteString>>> json() {
        return innerHandler -> (AsyncHandler)Middlewares.jsonAsync().apply((Object)Middleware.syncToAsync((SyncHandler)innerHandler));
    }

    public static Middleware<AsyncHandler<? extends Response<?>>, AsyncHandler<Response<ByteString>>> jsonAsync() {
        return innerHandler -> innerHandler.map(response -> {
            if (!response.payload().isPresent()) {
                return response;
            }
            Object tPayload = response.payload().get();
            try {
                byte[] bytes = Json.OBJECT_MAPPER.writeValueAsBytes(tPayload);
                ByteString payload = ByteString.of((byte[])bytes);
                return response.withPayload((Object)payload).withHeader("Content-Type", "application/json");
            }
            catch (JsonProcessingException e) {
                return Response.forStatus((StatusType)Status.INTERNAL_SERVER_ERROR.withReasonPhrase("Failed to serialize response " + e.getMessage()));
            }
        });
    }

    public static Middleware<AsyncHandler<? extends Response<?>>, AsyncHandler<? extends Response<ByteString>>> clientValidator(Supplier<Optional<List<String>>> supplier) {
        return innerHandler -> arg_0 -> Middlewares.lambda$null$4((Supplier)supplier, innerHandler, arg_0);
    }

    private static /* synthetic */ CompletionStage lambda$null$4(Supplier supplier, AsyncHandler innerHandler, RequestContext requestContext) {
        if (requestContext.request().header("User-Agent").map(arg_0 -> Middlewares.lambda$null$3((Supplier)supplier, arg_0)).orElse(false).booleanValue()) {
            return CompletableFuture.completedFuture(Response.forStatus((StatusType)Status.NOT_ACCEPTABLE.withReasonPhrase("blacklisted client version, please upgrade")));
        }
        return innerHandler.invoke(requestContext);
    }

    private static /* synthetic */ Boolean lambda$null$3(Supplier supplier, String header) {
        return ((List)((Optional)supplier.get()).orElse(ImmutableList.of())).contains(header);
    }
}

