/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.api;

import com.spotify.apollo.RequestContext;
import com.spotify.apollo.Response;
import com.spotify.apollo.route.AsyncHandler;
import com.spotify.apollo.route.Route;
import com.spotify.styx.api.Api;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.stream.Stream;
import okio.ByteString;

public class SchedulerResource {
    static final String BASE = "/scheduler";
    private static final String SCHEDULER_BASE_PATH = "/api/v0";
    private final String schedulerServiceBaseUrl;

    public SchedulerResource(String schedulerServiceBaseUrl) {
        this.schedulerServiceBaseUrl = Objects.requireNonNull(schedulerServiceBaseUrl);
    }

    public Stream<? extends Route<? extends AsyncHandler<? extends Response<ByteString>>>> routes() {
        List<Route<AsyncHandler<Response<ByteString>>>> schedulerProxies = Arrays.asList(Route.async((String)"GET", (String)"/scheduler/<endpoint:path>", rc -> this.proxyToScheduler("/" + (String)rc.pathArgs().get("endpoint"), rc)), Route.async((String)"POST", (String)"/scheduler/<endpoint:path>", rc -> this.proxyToScheduler("/" + (String)rc.pathArgs().get("endpoint"), rc)), Route.async((String)"DELETE", (String)"/scheduler/<endpoint:path>", rc -> this.proxyToScheduler("/" + (String)rc.pathArgs().get("endpoint"), rc)), Route.async((String)"PATCH", (String)"/scheduler/<endpoint:path>", rc -> this.proxyToScheduler("/" + (String)rc.pathArgs().get("endpoint"), rc)), Route.async((String)"PUT", (String)"/scheduler/<endpoint:path>", rc -> this.proxyToScheduler("/" + (String)rc.pathArgs().get("endpoint"), rc)));
        return Api.prefixRoutes(schedulerProxies, Api.Version.V2);
    }

    private CompletionStage<Response<ByteString>> proxyToScheduler(String path, RequestContext rc) {
        return rc.requestScopedClient().send(rc.request().withUri(this.schedulerServiceBaseUrl + SCHEDULER_BASE_PATH + path));
    }
}

