/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Throwables;
import com.spotify.apollo.Request;
import com.spotify.apollo.Response;
import com.spotify.apollo.Status;
import com.spotify.apollo.StatusType;
import com.spotify.apollo.route.AsyncHandler;
import com.spotify.apollo.route.Route;
import com.spotify.styx.api.Api;
import com.spotify.styx.api.AutoValue_StyxConfigResource_StyxConfig;
import com.spotify.styx.api.Middlewares;
import com.spotify.styx.storage.Storage;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import okio.ByteString;

public class StyxConfigResource {
    static final String BASE = "/config";
    private final Storage storage;

    public StyxConfigResource(Storage storage) {
        this.storage = Objects.requireNonNull(storage);
    }

    public Stream<? extends Route<? extends AsyncHandler<? extends Response<ByteString>>>> routes() {
        List<Route<AsyncHandler<Response<ByteString>>>> routes = Arrays.asList(Route.with(Middlewares.json(), (String)"GET", (String)BASE, rc -> this.styxConfig()), Route.with(Middlewares.json(), (String)"PATCH", (String)BASE, rc -> this.patchStyxConfig(rc.request())));
        return Api.prefixRoutes(routes, Api.Version.V0, Api.Version.V1, Api.Version.V2);
    }

    private Response<StyxConfig> styxConfig() {
        boolean enabled;
        try {
            enabled = this.storage.globalEnabled();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return Response.forPayload((Object)StyxConfig.create(enabled));
    }

    private Response<StyxConfig> patchStyxConfig(Request request) {
        Optional enabledParameter = request.parameter("enabled");
        if (!enabledParameter.isPresent()) {
            return Response.forStatus((StatusType)Status.BAD_REQUEST.withReasonPhrase("Missing 'enabled' query parameter"));
        }
        boolean enabled = Boolean.parseBoolean((String)enabledParameter.get());
        try {
            this.storage.setGlobalEnabled(enabled);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return Response.forPayload((Object)StyxConfig.create(enabled));
    }

    static abstract class StyxConfig {
        StyxConfig() {
        }

        @JsonProperty
        public abstract boolean enabled();

        static StyxConfig create(boolean enabled) {
            return new AutoValue_StyxConfigResource_StyxConfig(enabled);
        }
    }
}

