/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.api.deprecated;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.spotify.apollo.RequestContext;
import com.spotify.apollo.Response;
import com.spotify.apollo.entity.EntityCodec;
import com.spotify.apollo.entity.EntityMiddleware;
import com.spotify.apollo.entity.JacksonEntityCodec;
import com.spotify.apollo.route.AsyncHandler;
import com.spotify.apollo.route.Middleware;
import com.spotify.apollo.route.Route;
import com.spotify.styx.api.Api;
import com.spotify.styx.api.deprecated.BackfillPayload;
import com.spotify.styx.api.deprecated.BackfillsPayload;
import com.spotify.styx.model.Backfill;
import com.spotify.styx.model.BackfillInput;
import com.spotify.styx.serialization.Json;
import com.spotify.styx.util.StreamUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import okio.ByteString;

@Deprecated
public final class BackfillResource {
    static final String BASE = "/backfills";
    private final com.spotify.styx.api.BackfillResource backfillResource;

    public BackfillResource(com.spotify.styx.api.BackfillResource backfillResource) {
        this.backfillResource = Objects.requireNonNull(backfillResource);
    }

    public Stream<? extends Route<? extends AsyncHandler<? extends Response<ByteString>>>> routes() {
        EntityMiddleware em = EntityMiddleware.forCodec((EntityCodec)JacksonEntityCodec.forMapper((ObjectMapper)Json.OBJECT_MAPPER));
        List<Route<AsyncHandler<Response<ByteString>>>> entityRoutes = Stream.of(Route.with((Middleware)em.serializerDirect(BackfillsPayload.class), (String)"GET", (String)BASE, this::getBackfills), Route.with((Middleware)em.response(BackfillInput.class, com.spotify.styx.model.deprecated.Backfill.class), (String)"POST", (String)BASE, rc -> this::postBackfill), Route.with((Middleware)em.serializerResponse(BackfillPayload.class), (String)"GET", (String)"/backfills/<bid>", rc -> this.getBackfill((String)rc.pathArgs().get("bid"))), Route.with((Middleware)em.response(com.spotify.styx.model.deprecated.Backfill.class), (String)"PUT", (String)"/backfills/<bid>", rc -> payload -> this.updateBackfill((String)rc.pathArgs().get("bid"), (com.spotify.styx.model.deprecated.Backfill)payload))).map(r -> r.withMiddleware(Middleware::syncToAsync)).collect(Collectors.toList());
        List<Route<AsyncHandler<Response<ByteString>>>> routes = Collections.singletonList(Route.async((String)"DELETE", (String)"/backfills/<bid>", rc -> this.haltBackfill((String)rc.pathArgs().get("bid"), rc)));
        return StreamUtil.cat((Stream[])new Stream[]{Api.prefixRoutes(entityRoutes, Api.Version.V1), Api.prefixRoutes(routes, Api.Version.V1)});
    }

    private BackfillsPayload getBackfills(RequestContext requestContext) {
        return BackfillsPayload.create((com.spotify.styx.api.BackfillsPayload)this.backfillResource.getBackfills(requestContext));
    }

    private Response<BackfillPayload> getBackfill(String id) {
        Response<com.spotify.styx.api.BackfillPayload> response = this.backfillResource.getBackfill(id);
        return response.withPayload(response.payload().map(BackfillPayload::create).orElse(null));
    }

    private CompletionStage<Response<ByteString>> haltBackfill(String id, RequestContext rc) {
        return this.backfillResource.haltBackfill(id, rc);
    }

    private Response<com.spotify.styx.model.deprecated.Backfill> postBackfill(BackfillInput input) {
        Response<Backfill> response = this.backfillResource.postBackfill(input);
        return response.withPayload(response.payload().map(com.spotify.styx.model.deprecated.Backfill::create).orElse(null));
    }

    private Response<com.spotify.styx.model.deprecated.Backfill> updateBackfill(String id, com.spotify.styx.model.deprecated.Backfill backfill) {
        Response<Backfill> response = this.backfillResource.updateBackfill(id, com.spotify.styx.model.deprecated.Backfill.create((com.spotify.styx.model.deprecated.Backfill)backfill));
        return response.withPayload(response.payload().map(com.spotify.styx.model.deprecated.Backfill::create).orElse(null));
    }
}

