/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.spotify.apollo.Client;
import com.spotify.apollo.Request;
import com.spotify.apollo.RequestContext;
import com.spotify.apollo.Response;
import com.spotify.apollo.Status;
import com.spotify.apollo.StatusType;
import com.spotify.apollo.route.AsyncHandler;
import com.spotify.apollo.route.Middleware;
import com.spotify.apollo.route.Route;
import com.spotify.styx.api.Api;
import com.spotify.styx.api.Middlewares;
import com.spotify.styx.model.Workflow;
import com.spotify.styx.model.WorkflowConfiguration;
import com.spotify.styx.model.WorkflowId;
import com.spotify.styx.model.WorkflowInstance;
import com.spotify.styx.model.WorkflowState;
import com.spotify.styx.model.data.WorkflowInstanceExecutionData;
import com.spotify.styx.serialization.Json;
import com.spotify.styx.storage.Storage;
import com.spotify.styx.util.DockerImageValidator;
import com.spotify.styx.util.ResourceNotFoundException;
import com.spotify.styx.util.StreamUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Stream;
import okio.ByteString;

public final class WorkflowResource {
    private static final String BASE = "/workflows";
    private static final int DEFAULT_PAGE_LIMIT = 168;
    private static final String SCHEDULER_BASE_PATH = "/api/v0";
    private final DockerImageValidator dockerImageValidator;
    private final String schedulerServiceBaseUrl;
    private final Storage storage;
    private final Client forwardingClient;

    public WorkflowResource(Storage storage, String schedulerServiceBaseUrl, DockerImageValidator dockerImageValidator, Client forwardingClient) {
        this.storage = Objects.requireNonNull(storage);
        this.dockerImageValidator = Objects.requireNonNull(dockerImageValidator, "dockerImageValidator");
        this.schedulerServiceBaseUrl = Objects.requireNonNull(schedulerServiceBaseUrl);
        this.forwardingClient = Objects.requireNonNull(forwardingClient);
    }

    public Stream<Route<AsyncHandler<Response<ByteString>>>> routes() {
        List<Route> routes = Arrays.asList(Route.with((Middleware)Middlewares.json(), (String)"GET", (String)"/workflows/<cid>/<wfid>", rc -> this.workflow(WorkflowResource.arg("cid", rc), WorkflowResource.arg("wfid", rc))), Route.with((Middleware)Middlewares.json(), (String)"GET", (String)BASE, rc -> this.workflows()), Route.with((Middleware)Middlewares.json(), (String)"GET", (String)"/workflows/<cid>", rc -> this.workflows(WorkflowResource.arg("cid", rc))), Route.with((Middleware)Middlewares.json(), (String)"GET", (String)"/workflows/<cid>/<wfid>/instances", rc -> this.instances(WorkflowResource.arg("cid", rc), WorkflowResource.arg("wfid", rc), rc.request())), Route.with((Middleware)Middlewares.json(), (String)"GET", (String)"/workflows/<cid>/<wfid>/instances/<iid>", rc -> this.instance(WorkflowResource.arg("cid", rc), WorkflowResource.arg("wfid", rc), WorkflowResource.arg("iid", rc))), Route.with((Middleware)Middlewares.json(), (String)"GET", (String)"/workflows/<cid>/<wfid>/state", rc -> this.state(WorkflowResource.arg("cid", rc), WorkflowResource.arg("wfid", rc))), Route.with((Middleware)Middlewares.json(), (String)"PATCH", (String)"/workflows/<cid>/<wfid>/state", rc -> this.patchState(WorkflowResource.arg("cid", rc), WorkflowResource.arg("wfid", rc), rc.request())));
        List<Route> forwardedRoutes = Arrays.asList(Route.async((String)"POST", (String)"/workflows/<cid>", rc -> this.createOrUpdateWorkflow(WorkflowResource.arg("cid", rc), rc)), Route.async((String)"DELETE", (String)"/workflows/<cid>/<wfid>", rc -> this.deleteWorkflow(WorkflowResource.arg("cid", rc), WorkflowResource.arg("wfid", rc), rc)));
        return StreamUtil.cat((Stream[])new Stream[]{Api.prefixRoutes(routes, (Api.Version[])new Api.Version[]{Api.Version.V3}), Api.prefixRoutes(forwardedRoutes, (Api.Version[])new Api.Version[]{Api.Version.V3})});
    }

    private CompletionStage<Response<ByteString>> deleteWorkflow(String cid, String wfid, RequestContext rc) {
        return this.forwardingClient.send(rc.request().withUri(this.schedulerApiUrl("workflows", cid, wfid)));
    }

    private CompletionStage<Response<ByteString>> createOrUpdateWorkflow(String componentId, RequestContext rc) {
        Collection errors;
        WorkflowConfiguration workflowConfig;
        Optional payload = rc.request().payload();
        if (!payload.isPresent()) {
            return CompletableFuture.completedFuture(Response.forStatus((StatusType)Status.BAD_REQUEST.withReasonPhrase("Missing payload.")));
        }
        try {
            workflowConfig = (WorkflowConfiguration)Json.OBJECT_MAPPER.readValue(((ByteString)payload.get()).toByteArray(), WorkflowConfiguration.class);
        }
        catch (IOException e) {
            return CompletableFuture.completedFuture(Response.forStatus((StatusType)Status.BAD_REQUEST.withReasonPhrase("Invalid payload. " + e.getMessage())));
        }
        Optional dockerImage = workflowConfig.dockerImage();
        if (dockerImage.isPresent() && !(errors = this.dockerImageValidator.validateImageReference((String)dockerImage.get())).isEmpty()) {
            return CompletableFuture.completedFuture(Response.forStatus((StatusType)Status.BAD_REQUEST.withReasonPhrase("Invalid docker image: " + errors)));
        }
        return this.forwardingClient.send(rc.request().withPayload((ByteString)payload.get()).withUri(this.schedulerApiUrl("workflows", componentId)));
    }

    private Response<Collection<Workflow>> workflows() {
        try {
            return Response.forPayload(this.storage.workflows().values());
        }
        catch (IOException e) {
            return Response.forStatus((StatusType)Status.INTERNAL_SERVER_ERROR.withReasonPhrase("Failed to get workflows"));
        }
    }

    private Response<List<Workflow>> workflows(String componentId) {
        try {
            return Response.forPayload((Object)this.storage.workflows(componentId));
        }
        catch (IOException e) {
            return Response.forStatus((StatusType)Status.INTERNAL_SERVER_ERROR.withReasonPhrase("Failed to get workflows of component " + componentId));
        }
    }

    private Response<WorkflowState> patchState(String componentId, String id, Request request) {
        WorkflowState patchState;
        Optional payload = request.payload();
        if (!payload.isPresent()) {
            return Response.forStatus((StatusType)Status.BAD_REQUEST.withReasonPhrase("Missing payload."));
        }
        WorkflowId workflowId = WorkflowId.create((String)componentId, (String)id);
        try {
            JsonNode json = Json.OBJECT_MAPPER.readTree(((ByteString)payload.get()).toByteArray());
            if (json.has("commit_sha") || json.has("docker_image")) {
                return Response.forStatus((StatusType)Status.BAD_REQUEST.withReasonPhrase("Invalid payload: commit_sha and docker_image not allowed."));
            }
            patchState = (WorkflowState)Json.OBJECT_MAPPER.readValue(((ByteString)payload.get()).toByteArray(), WorkflowState.class);
        }
        catch (IOException e) {
            return Response.forStatus((StatusType)Status.BAD_REQUEST.withReasonPhrase("Invalid payload."));
        }
        try {
            this.storage.patchState(workflowId, patchState);
        }
        catch (ResourceNotFoundException e) {
            return Response.forStatus((StatusType)Status.NOT_FOUND.withReasonPhrase(e.getMessage()));
        }
        catch (IOException e) {
            return Response.forStatus((StatusType)Status.INTERNAL_SERVER_ERROR.withReasonPhrase("Failed to update the state."));
        }
        return this.state(componentId, id);
    }

    private Response<Workflow> workflow(String componentId, String id) {
        try {
            return this.storage.workflow(WorkflowId.create((String)componentId, (String)id)).map(Response::forPayload).orElse(Response.forStatus((StatusType)Status.NOT_FOUND));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private Response<WorkflowState> state(String componentId, String id) {
        try {
            return Response.forPayload((Object)this.storage.workflowState(WorkflowId.create((String)componentId, (String)id)));
        }
        catch (IOException e) {
            return Response.forStatus((StatusType)Status.INTERNAL_SERVER_ERROR.withReasonPhrase("Couldn't fetch state."));
        }
    }

    private Response<List<WorkflowInstanceExecutionData>> instances(String componentId, String id, Request request) {
        List data;
        WorkflowId workflowId = WorkflowId.create((String)componentId, (String)id);
        String offset = request.parameter("offset").orElse("");
        int limit = request.parameter("limit").map(Integer::parseInt).orElse(168);
        String start = request.parameter("start").orElse("");
        String stop = request.parameter("stop").orElse("");
        try {
            data = Strings.isNullOrEmpty((String)start) ? this.storage.executionData(workflowId, offset, limit) : this.storage.executionData(workflowId, start, stop);
        }
        catch (IOException e) {
            return Response.forStatus((StatusType)Status.INTERNAL_SERVER_ERROR.withReasonPhrase("Couldn't fetch execution info."));
        }
        return Response.forPayload((Object)data);
    }

    private Response<WorkflowInstanceExecutionData> instance(String componentId, String id, String instanceId) {
        WorkflowId workflowId = WorkflowId.create((String)componentId, (String)id);
        WorkflowInstance workflowInstance = WorkflowInstance.create((WorkflowId)workflowId, (String)instanceId);
        try {
            WorkflowInstanceExecutionData workflowInstanceExecutionData = this.storage.executionData(workflowInstance);
            return Response.forPayload((Object)workflowInstanceExecutionData);
        }
        catch (IOException e) {
            return Response.forStatus((StatusType)Status.INTERNAL_SERVER_ERROR.withReasonPhrase("Couldn't fetch execution info."));
        }
    }

    private String schedulerApiUrl(CharSequence ... parts) {
        return this.schedulerServiceBaseUrl + SCHEDULER_BASE_PATH + "/" + String.join((CharSequence)"/", parts);
    }

    private static String arg(String name, RequestContext rc) {
        return (String)rc.pathArgs().get(name);
    }
}

