/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx;

import com.google.cloud.datastore.Datastore;
import com.google.common.io.Closer;
import com.spotify.apollo.AppInit;
import com.spotify.apollo.Environment;
import com.spotify.apollo.route.Route;
import com.spotify.metrics.core.SemanticMetricRegistry;
import com.spotify.styx.api.Api;
import com.spotify.styx.api.BackfillResource;
import com.spotify.styx.api.ResourceResource;
import com.spotify.styx.api.SchedulerProxyResource;
import com.spotify.styx.api.StatusResource;
import com.spotify.styx.api.WorkflowResource;
import com.spotify.styx.api.workflow.WorkflowInitializer;
import com.spotify.styx.model.StyxConfig;
import com.spotify.styx.model.Workflow;
import com.spotify.styx.monitoring.MeteredStorageProxy;
import com.spotify.styx.monitoring.MetricsStats;
import com.spotify.styx.monitoring.Stats;
import com.spotify.styx.monitoring.StatsFactory;
import com.spotify.styx.storage.AggregateStorage;
import com.spotify.styx.storage.InstrumentedDatastore;
import com.spotify.styx.storage.Storage;
import com.spotify.styx.util.CachedSupplier;
import com.spotify.styx.util.Connections;
import com.spotify.styx.util.CounterSnapshotFactory;
import com.spotify.styx.util.DockerImageValidator;
import com.spotify.styx.util.ShardedCounter;
import com.spotify.styx.util.ShardedCounterSnapshotFactory;
import com.spotify.styx.util.StorageFactory;
import com.spotify.styx.util.StreamUtil;
import com.spotify.styx.util.Time;
import com.spotify.styx.util.WorkflowValidator;
import com.typesafe.config.Config;
import java.io.Closeable;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.hadoop.hbase.client.Connection;

public class StyxApi
implements AppInit {
    public static final String SERVICE_NAME = "styx-api";
    public static final String SCHEDULER_SERVICE_BASE_URL = "styx.scheduler.base-url";
    public static final String DEFAULT_SCHEDULER_SERVICE_BASE_URL = "http://localhost:8080";
    public static final Duration DEFAULT_RETRY_BASE_DELAY_BT = Duration.ofSeconds(1L);
    private final String serviceName;
    private final StorageFactory storageFactory;
    private final WorkflowConsumerFactory workflowConsumerFactory;
    private final StatsFactory statsFactory;
    private final Time time;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static StyxApi createDefault() {
        return StyxApi.newBuilder().build();
    }

    private StyxApi(Builder builder) {
        this.serviceName = Objects.requireNonNull(builder.serviceName);
        this.storageFactory = Objects.requireNonNull(builder.storageFactory);
        this.workflowConsumerFactory = Objects.requireNonNull(builder.workflowConsumerFactory);
        this.statsFactory = Objects.requireNonNull(builder.statsFactory);
        this.time = Objects.requireNonNull(builder.time);
    }

    public void create(Environment environment) {
        Config config = environment.config();
        String schedulerServiceBaseUrl = config.hasPath(SCHEDULER_SERVICE_BASE_URL) ? config.getString(SCHEDULER_SERVICE_BASE_URL) : DEFAULT_SCHEDULER_SERVICE_BASE_URL;
        Stats stats = (Stats)this.statsFactory.apply((Object)environment);
        Storage storage = MeteredStorageProxy.instrument((Storage)((Storage)this.storageFactory.apply((Object)environment, (Object)stats)), (Stats)stats, (Time)this.time);
        BiConsumer workflowConsumer = (BiConsumer)this.workflowConsumerFactory.apply(environment, stats);
        WorkflowResource workflowResource = new WorkflowResource(storage, new WorkflowValidator(new DockerImageValidator()), new WorkflowInitializer(storage, this.time), workflowConsumer);
        BackfillResource backfillResource = new BackfillResource(schedulerServiceBaseUrl, storage, new WorkflowValidator(new DockerImageValidator()));
        ShardedCounter shardedCounter = new ShardedCounter(storage, (CounterSnapshotFactory)new ShardedCounterSnapshotFactory(storage));
        ResourceResource resourceResource = new ResourceResource(storage, shardedCounter);
        StatusResource statusResource = new StatusResource(storage);
        SchedulerProxyResource schedulerProxyResource = new SchedulerProxyResource(schedulerServiceBaseUrl, environment.client());
        CachedSupplier configSupplier = new CachedSupplier(() -> ((Storage)storage).config(), Instant::now);
        Supplier<List> clientBlacklistSupplier = () -> StyxApi.lambda$create$0((Supplier)configSupplier);
        Stream routes = StreamUtil.cat((Stream[])new Stream[]{workflowResource.routes(), backfillResource.routes(), resourceResource.routes(), statusResource.routes(), schedulerProxyResource.routes()});
        environment.routingEngine().registerAutoRoute(Route.sync((String)"GET", (String)"/ping", rc -> "pong")).registerRoutes(Api.withCommonMiddleware((Stream)routes, clientBlacklistSupplier, (String)this.serviceName));
    }

    private static AggregateStorage storage(Environment environment, Stats stats) {
        Config config = environment.config();
        Closer closer = environment.closer();
        Connection bigTable = (Connection)closer.register((Closeable)Connections.createBigTableConnection((Config)config));
        InstrumentedDatastore datastore = Connections.createDatastore((Config)config, (Stats)stats);
        return new AggregateStorage(bigTable, (Datastore)datastore, DEFAULT_RETRY_BASE_DELAY_BT);
    }

    private static Stats stats(Environment environment) {
        return new MetricsStats((SemanticMetricRegistry)environment.resolve(SemanticMetricRegistry.class), Instant::now);
    }

    private static /* synthetic */ List lambda$create$0(Supplier configSupplier) {
        return ((StyxConfig)configSupplier.get()).clientBlacklist();
    }

    public static class Builder {
        private String serviceName = "styx-api";
        private StorageFactory storageFactory = (x$0, x$1) -> StyxApi.access$200(x$0, x$1);
        private WorkflowConsumerFactory workflowConsumerFactory = (env, stats) -> (oldWorkflow, newWorkflow) -> {};
        private StatsFactory statsFactory = x$0 -> StyxApi.access$100(x$0);
        private Time time = Instant::now;

        public Builder setServiceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Builder setStorageFactory(StorageFactory storageFactory) {
            this.storageFactory = storageFactory;
            return this;
        }

        public Builder setWorkflowConsumerFactory(WorkflowConsumerFactory workflowConsumerFactory) {
            this.workflowConsumerFactory = workflowConsumerFactory;
            return this;
        }

        public Builder setStatsFactory(StatsFactory statsFactory) {
            this.statsFactory = statsFactory;
            return this;
        }

        public Builder setTime(Time time) {
            this.time = time;
            return this;
        }

        public StyxApi build() {
            return new StyxApi(this);
        }
    }

    public static interface WorkflowConsumerFactory
    extends BiFunction<Environment, Stats, BiConsumer<Optional<Workflow>, Optional<Workflow>>> {
    }
}

