/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.api.workflow;

import com.spotify.styx.api.workflow.WorkflowInitializationException;
import com.spotify.styx.model.Schedule;
import com.spotify.styx.model.Workflow;
import com.spotify.styx.storage.Storage;
import com.spotify.styx.storage.StorageTransaction;
import com.spotify.styx.util.Time;
import com.spotify.styx.util.TimeUtil;
import com.spotify.styx.util.TriggerInstantSpec;
import java.io.IOException;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowInitializer {
    private static final Logger LOG = LoggerFactory.getLogger(WorkflowInitializer.class);
    private final Storage storage;
    private final Time time;

    public WorkflowInitializer(Storage storage, Time time) {
        this.storage = Objects.requireNonNull(storage);
        this.time = Objects.requireNonNull(time);
    }

    public Optional<Workflow> store(Workflow workflow) throws WorkflowInitializationException {
        try {
            return (Optional)this.storage.runInTransaction(tx -> this.store(tx, workflow));
        }
        catch (IOException e) {
            LOG.warn("failed to write workflow {} to storage", (Object)workflow.id(), (Object)e);
            throw new RuntimeException(e);
        }
    }

    private Optional<Workflow> store(StorageTransaction tx, Workflow workflow) throws WorkflowInitializationException, IOException {
        Optional<Object> nextSpec;
        Optional previous;
        try {
            previous = tx.workflow(workflow.id());
        }
        catch (IOException e) {
            LOG.warn("failed to read workflow {} from storage", (Object)workflow.id(), (Object)e);
            throw new RuntimeException(e);
        }
        Schedule newSchedule = workflow.configuration().schedule();
        Optional newOffset = workflow.configuration().offset();
        if (!(previous.isPresent() && ((Workflow)previous.get()).configuration().schedule().equals(newSchedule) && ((Workflow)previous.get()).configuration().offset().equals(newOffset))) {
            try {
                nextSpec = Optional.of(this.initializeNaturalTrigger(workflow));
            }
            catch (Exception e) {
                LOG.info("could not compute next natural trigger for workflow {}", (Object)workflow, (Object)e);
                throw new WorkflowInitializationException(e);
            }
        } else {
            nextSpec = Optional.empty();
        }
        if (nextSpec.isPresent()) {
            tx.storeWorkflowWithNextNaturalTrigger(workflow, nextSpec.get());
        } else {
            tx.store(workflow);
        }
        return previous;
    }

    private TriggerInstantSpec initializeNaturalTrigger(Workflow workflow) {
        Instant now = (Instant)this.time.get();
        Schedule schedule = workflow.configuration().schedule();
        Instant nextTrigger = TimeUtil.lastInstant((Instant)now, (Schedule)schedule);
        Instant nextWithOffset = workflow.configuration().addOffset(nextTrigger);
        return TriggerInstantSpec.create((Instant)nextTrigger, (Instant)nextWithOffset);
    }
}

