/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.spotify.apollo.Response;
import com.spotify.apollo.Status;
import com.spotify.apollo.StatusType;
import com.spotify.apollo.entity.EntityCodec;
import com.spotify.apollo.entity.EntityMiddleware;
import com.spotify.apollo.entity.JacksonEntityCodec;
import com.spotify.apollo.route.AsyncHandler;
import com.spotify.apollo.route.Middleware;
import com.spotify.apollo.route.Route;
import com.spotify.styx.api.Api;
import com.spotify.styx.api.ResourcesPayload;
import com.spotify.styx.model.Resource;
import com.spotify.styx.serialization.Json;
import com.spotify.styx.storage.Storage;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import okio.ByteString;

public final class ResourceResource {
    static final String BASE = "/resources";
    private final Storage storage;

    public ResourceResource(Storage storage) {
        this.storage = Objects.requireNonNull(storage);
    }

    public Stream<Route<AsyncHandler<Response<ByteString>>>> routes() {
        EntityMiddleware em = EntityMiddleware.forCodec((EntityCodec)JacksonEntityCodec.forMapper((ObjectMapper)Json.OBJECT_MAPPER));
        List routes = Stream.of(Route.with((Middleware)em.serializerDirect(ResourcesPayload.class), (String)"GET", (String)BASE, rc -> this.getResources()), Route.with((Middleware)em.direct(Resource.class), (String)"POST", (String)BASE, rc -> this::postResource), Route.with((Middleware)em.serializerResponse(Resource.class), (String)"GET", (String)"/resources/<rid>", rc -> this.getResource((String)rc.pathArgs().get("rid"))), Route.with((Middleware)em.serializerResponse(Void.class), (String)"DELETE", (String)"/resources/<rid>", rc -> this.deleteResource((String)rc.pathArgs().get("rid"))), Route.with((Middleware)em.response(Resource.class), (String)"PUT", (String)"/resources/<rid>", rc -> payload -> this.updateResource((String)rc.pathArgs().get("rid"), (Resource)payload))).map(r -> r.withMiddleware(Middleware::syncToAsync)).collect(Collectors.toList());
        return Api.prefixRoutes(routes, (Api.Version[])new Api.Version[]{Api.Version.V3});
    }

    private ResourcesPayload getResources() {
        try {
            return ResourcesPayload.create((List)this.storage.resources());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Response<Resource> getResource(String id) {
        try {
            return this.storage.resource(id).map(Response::forPayload).orElse(Response.forStatus((StatusType)Status.NOT_FOUND));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Response<Void> deleteResource(String id) {
        try {
            this.storage.deleteResource(id);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return Response.forStatus((StatusType)Status.NO_CONTENT);
    }

    private Resource postResource(Resource resource) {
        try {
            this.storage.storeResource(resource);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return resource;
    }

    private Response<Resource> updateResource(String id, Resource resource) {
        if (!resource.id().equals(id)) {
            return Response.forStatus((StatusType)Status.BAD_REQUEST.withReasonPhrase("ID of payload does not match ID in uri."));
        }
        try {
            this.storage.storeResource(resource);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return Response.forStatus((StatusType)Status.OK).withPayload((Object)resource);
    }
}

