/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.api;

import com.github.rholder.retry.Attempt;
import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.StopStrategy;
import com.github.rholder.retry.WaitStrategies;
import com.github.rholder.retry.WaitStrategy;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.auth.oauth2.GoogleIdToken;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.googleapis.util.Utils;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.services.admin.directory.Directory;
import com.google.api.services.admin.directory.model.MembersHasMember;
import com.google.api.services.cloudresourcemanager.CloudResourceManager;
import com.google.api.services.cloudresourcemanager.model.GetIamPolicyRequest;
import com.google.api.services.iam.v1.Iam;
import com.google.api.services.iam.v1.model.Policy;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableSet;
import com.spotify.apollo.Response;
import com.spotify.apollo.Status;
import com.spotify.apollo.StatusType;
import com.spotify.styx.api.ResponseException;
import com.spotify.styx.model.WorkflowId;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javaslang.Tuple;
import javaslang.Tuple2;
import javaslang.control.Either;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunctionalInterface
public interface ServiceAccountUsageAuthorizer {
    public static final ServiceAccountUsageAuthorizer NOP = (x, y, z) -> {};

    public void authorizeServiceAccountUsage(WorkflowId var1, String var2, GoogleIdToken var3);

    public static ServiceAccountUsageAuthorizer create(String serviceAccountUserRole, AuthorizationPolicy authorizationPolicy, GoogleCredential credential, String serviceName) {
        NetHttpTransport httpTransport;
        try {
            httpTransport = GoogleNetHttpTransport.newTrustedTransport();
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
        JsonFactory jsonFactory = Utils.getDefaultJsonFactory();
        CloudResourceManager crm = new CloudResourceManager.Builder((HttpTransport)httpTransport, jsonFactory, (HttpRequestInitializer)credential).setApplicationName(serviceName).build();
        Iam iam = new Iam.Builder((HttpTransport)httpTransport, jsonFactory, (HttpRequestInitializer)credential).setApplicationName(serviceName).build();
        Directory directory = new Directory.Builder((HttpTransport)httpTransport, jsonFactory, (HttpRequestInitializer)credential).setApplicationName(serviceName).build();
        return new Impl(iam, crm, directory, serviceAccountUserRole, authorizationPolicy, Impl.DEFAULT_RETRY_STOP_STRATEGY);
    }

    public static class WhitelistAuthorizationPolicy
    implements AuthorizationPolicy {
        private final Set<WorkflowId> whitelist;

        public WhitelistAuthorizationPolicy(Iterable<WorkflowId> whitelist) {
            this.whitelist = ImmutableSet.copyOf(whitelist);
        }

        @Override
        public boolean shouldEnforceAuthorization(WorkflowId workflowId, String serviceAccount, GoogleIdToken idToken) {
            return this.whitelist.contains(workflowId);
        }
    }

    public static class AllAuthorizationPolicy
    implements AuthorizationPolicy {
        @Override
        public boolean shouldEnforceAuthorization(WorkflowId workflowId, String serviceAccount, GoogleIdToken idToken) {
            return true;
        }
    }

    public static class NoAuthorizationPolicy
    implements AuthorizationPolicy {
        @Override
        public boolean shouldEnforceAuthorization(WorkflowId workflowId, String serviceAccount, GoogleIdToken idToken) {
            return false;
        }
    }

    public static interface AuthorizationPolicy {
        public boolean shouldEnforceAuthorization(WorkflowId var1, String var2, GoogleIdToken var3);
    }

    public static class Impl
    implements ServiceAccountUsageAuthorizer {
        private static final Logger log = LoggerFactory.getLogger(ServiceAccountUsageAuthorizer.class);
        private static final Pattern SERVICE_ACCOUNT_PATTERN = Pattern.compile("^.+\\.gserviceaccount\\.com$");
        private static final Pattern USER_CREATED_SERVICE_ACCOUNT_PATTERN = Pattern.compile("^.+@(.+)\\.iam\\.gserviceaccount\\.com$");
        private static final StopStrategy DEFAULT_RETRY_STOP_STRATEGY = StopStrategies.stopAfterDelay((long)10L, (TimeUnit)TimeUnit.SECONDS);
        private static final String CACHE_HIT = "hit";
        private static final String CACHE_MISS = "miss";
        private final Iam iam;
        private final CloudResourceManager crm;
        private final Directory directory;
        private final String serviceAccountUserRole;
        private final AuthorizationPolicy authorizationPolicy;
        private final StopStrategy retryStopStrategy;
        private final Cache<Tuple2<String, String>, Either<Response<?>, Optional<String>>> cache = CacheBuilder.newBuilder().expireAfterWrite(60L, TimeUnit.SECONDS).maximumSize(10000L).build();

        Impl(Iam iam, CloudResourceManager crm, Directory directory, String serviceAccountUserRole, AuthorizationPolicy authorizationPolicy, StopStrategy retryStopStrategy) {
            this.iam = Objects.requireNonNull(iam, "iam");
            this.crm = Objects.requireNonNull(crm, "crm");
            this.directory = Objects.requireNonNull(directory, "directory");
            this.serviceAccountUserRole = Objects.requireNonNull(serviceAccountUserRole, "serviceAccountUserRole");
            this.authorizationPolicy = Objects.requireNonNull(authorizationPolicy, "authorizationPolicy");
            this.retryStopStrategy = Objects.requireNonNull(retryStopStrategy, "retryStopStrategy");
        }

        @Override
        public void authorizeServiceAccountUsage(WorkflowId workflowId, String serviceAccount, GoogleIdToken idToken) {
            String principalEmail = idToken.getPayload().getEmail();
            String projectId = this.serviceAccountProjectId(workflowId, serviceAccount);
            AtomicBoolean cached = new AtomicBoolean(true);
            Either result = Impl.get(this.cache, Tuple.of((Object)principalEmail, (Object)serviceAccount), () -> {
                cached.set(false);
                try {
                    return Either.right(Impl.firstPresent(() -> this.projectPolicyAccess(projectId, principalEmail).map(type -> String.format("Principal %s has role %s on service account %s %s", principalEmail, this.serviceAccountUserRole, serviceAccount, type)), () -> this.serviceAccountPolicyAccess(serviceAccount, principalEmail).map(type -> String.format("Principal %s has role %s on service account %s %s", principalEmail, this.serviceAccountUserRole, serviceAccount, type))));
                }
                catch (ResponseException e) {
                    return Either.left((Object)e.getResponse());
                }
            });
            if (result.isLeft()) {
                throw new ResponseException((Response)result.left().get());
            }
            boolean enforce = this.authorizationPolicy.shouldEnforceAuthorization(workflowId, serviceAccount, idToken);
            Optional accessMessage = (Optional)result.right().get();
            if (accessMessage.isPresent()) {
                this.logAuthorization(workflowId, serviceAccount, enforce, (String)accessMessage.get(), cached.get());
                return;
            }
            this.logDenial(workflowId, serviceAccount, enforce, principalEmail, cached.get());
            if (enforce) {
                throw this.denialResponseException(serviceAccount, principalEmail, projectId);
            }
        }

        private static <K, V> V get(Cache<K, V> cache, K key, Callable<V> loader) {
            try {
                return (V)cache.get(key, loader);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }

        private ResponseException denialResponseException(String serviceAccount, String principalEmail, String projectId) {
            return new ResponseException(Response.forStatus((StatusType)Status.FORBIDDEN.withReasonPhrase("The user " + principalEmail + " must have the role " + this.serviceAccountUserRole + " on the project " + projectId + " or the service account " + serviceAccount + ", either through a group membership (recommended) or directly")));
        }

        private void logDenial(WorkflowId workflowId, String serviceAccount, boolean enforce, String principalEmail, boolean cached) {
            log.info("[AUDIT] Principal {} denied use of service account {} in workflow {} (Enforcing: {}, Cache: {})", new Object[]{principalEmail, serviceAccount, workflowId.toKey(), enforce, cached ? CACHE_HIT : CACHE_MISS});
        }

        private void logAuthorization(WorkflowId workflowId, String serviceAccount, boolean enforce, String accessMessage, boolean cached) {
            log.info("[AUDIT] {}, authorizing use of service account {} in workflow {} (Enforcing: {}, Cache: {})", new Object[]{accessMessage, serviceAccount, workflowId.toKey(), enforce, cached ? CACHE_HIT : CACHE_MISS});
        }

        private String serviceAccountProjectId(WorkflowId workflowId, String serviceAccount) {
            Matcher matcher = USER_CREATED_SERVICE_ACCOUNT_PATTERN.matcher(serviceAccount);
            if (!matcher.matches()) {
                log.info("Attempted to use non user created service account {} in workflow {}", (Object)serviceAccount, (Object)workflowId.toKey());
                throw new ResponseException(Response.forStatus((StatusType)Status.BAD_REQUEST.withReasonPhrase("Not a user created service account: " + serviceAccount)));
            }
            return matcher.group(1);
        }

        private Optional<String> projectPolicyAccess(String projectId, String principalEmail) {
            com.google.api.services.cloudresourcemanager.model.Policy policy = this.getProjectPolicy(projectId).orElseThrow(() -> new ResponseException(Response.forStatus((StatusType)Status.BAD_REQUEST.withReasonPhrase("Project does not exist: " + projectId))));
            List<String> members = policy.getBindings().stream().filter(binding -> this.serviceAccountUserRole.equals(binding.getRole())).flatMap(binding -> binding.getMembers().stream()).collect(Collectors.toList());
            return this.memberStatus(principalEmail, members);
        }

        private Optional<String> serviceAccountPolicyAccess(String serviceAccount, String principalEmail) {
            Policy policy = this.getServiceAccountPolicy(serviceAccount).orElseThrow(() -> new ResponseException(Response.forStatus((StatusType)Status.BAD_REQUEST.withReasonPhrase("Service account does not exist: " + serviceAccount))));
            List<String> members = policy.getBindings().stream().filter(binding -> this.serviceAccountUserRole.equals(binding.getRole())).flatMap(binding -> binding.getMembers().stream()).collect(Collectors.toList());
            return this.memberStatus(principalEmail, members);
        }

        private Optional<String> memberStatus(String principalEmail, List<String> members) {
            if (members.contains(Impl.memberEntry(principalEmail))) {
                return Optional.of("directly");
            }
            String groupPrefix = "group:";
            return members.stream().filter(s -> s.startsWith("group:")).map(s -> s.substring("group:".length())).filter(group -> this.isMemberOfGroup(principalEmail, (String)group)).findFirst().map(group -> "via group " + group);
        }

        private boolean isMemberOfGroup(String principalEmail, String group) {
            try {
                Boolean isMember = this.retry(() -> ((MembersHasMember)this.directory.members().hasMember(group, principalEmail).execute()).getIsMember());
                return Boolean.TRUE.equals(isMember);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof GoogleJsonResponseException && ((GoogleJsonResponseException)cause).getStatusCode() == 404) {
                    return false;
                }
                throw new RuntimeException(e);
            }
            catch (RetryException e) {
                throw new RuntimeException(e);
            }
        }

        private Optional<com.google.api.services.cloudresourcemanager.model.Policy> getProjectPolicy(String projectId) {
            try {
                return this.retry(() -> Optional.of((com.google.api.services.cloudresourcemanager.model.Policy)this.crm.projects().getIamPolicy(projectId, new GetIamPolicyRequest()).execute()));
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof GoogleJsonResponseException && ((GoogleJsonResponseException)cause).getStatusCode() == 404) {
                    return Optional.empty();
                }
                throw new RuntimeException(e);
            }
            catch (RetryException e) {
                throw new RuntimeException(e);
            }
        }

        private Optional<Policy> getServiceAccountPolicy(String serviceAccount) {
            try {
                return this.retry(() -> Optional.of((Policy)this.iam.projects().serviceAccounts().getIamPolicy("projects/-/serviceAccounts/" + serviceAccount).execute()));
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof GoogleJsonResponseException && ((GoogleJsonResponseException)cause).getStatusCode() == 404) {
                    return Optional.empty();
                }
                throw new RuntimeException(e);
            }
            catch (RetryException e) {
                throw new RuntimeException(e);
            }
        }

        private <T> T retry(Callable<T> f) throws ExecutionException, RetryException {
            Retryer retryer = RetryerBuilder.newBuilder().retryIfException(Impl::isRetryableException).withWaitStrategy(WaitStrategies.join((WaitStrategy[])new WaitStrategy[]{WaitStrategies.exponentialWait(), WaitStrategies.randomWait((long)1L, (TimeUnit)TimeUnit.SECONDS)})).withStopStrategy(this.retryStopStrategy).withRetryListener(Impl::onRequestAttempt).build();
            return (T)retryer.call(f);
        }

        private static <T> void onRequestAttempt(Attempt<T> attempt) {
            if (attempt.hasException()) {
                log.warn("Failed request attempt {}", (Object)attempt.getAttemptNumber(), (Object)attempt.getExceptionCause());
            }
        }

        private static boolean isRetryableException(Throwable t) {
            if (t instanceof IOException) {
                if (t instanceof GoogleJsonResponseException) {
                    return ((GoogleJsonResponseException)t).getStatusCode() / 100 == 5;
                }
                return true;
            }
            return false;
        }

        private static String memberEntry(String email) {
            String type = SERVICE_ACCOUNT_PATTERN.matcher(email).matches() ? "serviceAccount" : "user";
            return type + ":" + email;
        }

        @SafeVarargs
        private static <T> Optional<T> firstPresent(Supplier<Optional<T>> ... optionals) {
            return Stream.of(optionals).map(Supplier::get).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
        }
    }
}

