/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.api.client.googleapis.auth.oauth2.GoogleIdToken;
import com.google.common.base.Throwables;
import com.spotify.apollo.Request;
import com.spotify.apollo.RequestContext;
import com.spotify.apollo.Response;
import com.spotify.apollo.Status;
import com.spotify.apollo.StatusType;
import com.spotify.apollo.route.AsyncHandler;
import com.spotify.apollo.route.Middleware;
import com.spotify.apollo.route.Route;
import com.spotify.styx.api.Api;
import com.spotify.styx.api.Middlewares;
import com.spotify.styx.api.RequestAuthenticator;
import com.spotify.styx.api.ServiceAccountUsageAuthorizer;
import com.spotify.styx.api.workflow.WorkflowInitializationException;
import com.spotify.styx.api.workflow.WorkflowInitializer;
import com.spotify.styx.model.Schedule;
import com.spotify.styx.model.Workflow;
import com.spotify.styx.model.WorkflowConfiguration;
import com.spotify.styx.model.WorkflowId;
import com.spotify.styx.model.WorkflowInstance;
import com.spotify.styx.model.WorkflowState;
import com.spotify.styx.model.data.WorkflowInstanceExecutionData;
import com.spotify.styx.serialization.Json;
import com.spotify.styx.storage.Storage;
import com.spotify.styx.util.ParameterUtil;
import com.spotify.styx.util.ResourceNotFoundException;
import com.spotify.styx.util.TimeUtil;
import com.spotify.styx.util.WorkflowValidator;
import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import okio.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WorkflowResource {
    private static final String BASE = "/workflows";
    private static final int DEFAULT_PAGE_LIMIT = 168;
    private static final Logger LOG = LoggerFactory.getLogger(WorkflowResource.class);
    private final WorkflowValidator workflowValidator;
    private final WorkflowInitializer workflowInitializer;
    private final Storage storage;
    private final BiConsumer<Optional<Workflow>, Optional<Workflow>> workflowConsumer;
    private final ServiceAccountUsageAuthorizer serviceAccountUsageAuthorizer;

    public WorkflowResource(Storage storage, WorkflowValidator workflowValidator, WorkflowInitializer workflowInitializer, BiConsumer<Optional<Workflow>, Optional<Workflow>> workflowConsumer, ServiceAccountUsageAuthorizer serviceAccountUsageAuthorizer) {
        this.storage = Objects.requireNonNull(storage, "storage");
        this.workflowValidator = Objects.requireNonNull(workflowValidator, "workflowValidator");
        this.workflowInitializer = Objects.requireNonNull(workflowInitializer, "workflowInitializer");
        this.workflowConsumer = Objects.requireNonNull(workflowConsumer, "workflowConsumer");
        this.serviceAccountUsageAuthorizer = Objects.requireNonNull(serviceAccountUsageAuthorizer, "serviceAccountUsageAuthorizer");
    }

    public Stream<Route<AsyncHandler<Response<ByteString>>>> routes(RequestAuthenticator requestAuthenticator) {
        List<Route> routes = Arrays.asList(Route.with((Middleware)Middlewares.json(), (String)"GET", (String)"/workflows/<cid>/<wfid>", rc -> this.workflow(WorkflowResource.arg("cid", rc), WorkflowResource.arg("wfid", rc))), Route.with((Middleware)Middlewares.json(), (String)"GET", (String)BASE, rc -> this.workflows()), Route.with((Middleware)Middlewares.json(), (String)"GET", (String)"/workflows/<cid>", rc -> this.workflows(WorkflowResource.arg("cid", rc))), Route.with((Middleware)Middlewares.authed((RequestAuthenticator)requestAuthenticator), (String)"POST", (String)"/workflows/<cid>", rc -> ac -> this.createOrUpdateWorkflow(WorkflowResource.arg("cid", rc), (RequestContext)rc, (Middlewares.AuthContext)ac)), Route.with((Middleware)Middlewares.json(), (String)"DELETE", (String)"/workflows/<cid>/<wfid>", rc -> this.deleteWorkflow(WorkflowResource.arg("cid", rc), WorkflowResource.arg("wfid", rc))), Route.with((Middleware)Middlewares.json(), (String)"GET", (String)"/workflows/<cid>/<wfid>/instances", rc -> this.instances(WorkflowResource.arg("cid", rc), WorkflowResource.arg("wfid", rc), rc.request())), Route.with((Middleware)Middlewares.json(), (String)"GET", (String)"/workflows/<cid>/<wfid>/instances/<iid>", rc -> this.instance(WorkflowResource.arg("cid", rc), WorkflowResource.arg("wfid", rc), WorkflowResource.arg("iid", rc))), Route.with((Middleware)Middlewares.json(), (String)"GET", (String)"/workflows/<cid>/<wfid>/state", rc -> this.state(WorkflowResource.arg("cid", rc), WorkflowResource.arg("wfid", rc))), Route.with((Middleware)Middlewares.json(), (String)"PATCH", (String)"/workflows/<cid>/<wfid>/state", rc -> this.patchState(WorkflowResource.arg("cid", rc), WorkflowResource.arg("wfid", rc), rc.request())));
        return Api.prefixRoutes(routes, (Api.Version[])new Api.Version[]{Api.Version.V3});
    }

    private Response<ByteString> deleteWorkflow(String cid, String wfid) {
        Optional workflow;
        WorkflowId workflowId = WorkflowId.create((String)cid, (String)wfid);
        try {
            workflow = this.storage.workflow(workflowId);
        }
        catch (IOException e) {
            String message = String.format("Couldn't read workflow %s. ", workflowId);
            LOG.warn(message, (Throwable)e);
            return Response.forStatus((StatusType)Status.INTERNAL_SERVER_ERROR.withReasonPhrase("Error in internal storage"));
        }
        if (!workflow.isPresent()) {
            return Response.forStatus((StatusType)Status.NOT_FOUND.withReasonPhrase("Workflow does not exist"));
        }
        try {
            this.storage.delete(workflowId);
        }
        catch (IOException e) {
            String message = String.format("Couldn't remove workflow %s. ", workflowId);
            LOG.warn(message, (Throwable)e);
            return Response.forStatus((StatusType)Status.INTERNAL_SERVER_ERROR.withReasonPhrase("Error in internal storage"));
        }
        this.workflowConsumer.accept(workflow, Optional.empty());
        LOG.info("Workflow removed: {}", (Object)workflowId);
        return Response.forStatus((StatusType)Status.NO_CONTENT);
    }

    private Response<Workflow> createOrUpdateWorkflow(String componentId, RequestContext rc, Middlewares.AuthContext ac) {
        Optional<Workflow> oldWorkflowOptional;
        List errors;
        WorkflowConfiguration workflowConfig;
        Optional payload = rc.request().payload();
        if (!payload.isPresent()) {
            return Response.forStatus((StatusType)Status.BAD_REQUEST.withReasonPhrase("Missing payload."));
        }
        try {
            workflowConfig = (WorkflowConfiguration)Json.OBJECT_MAPPER.readValue(((ByteString)payload.get()).toByteArray(), WorkflowConfiguration.class);
        }
        catch (IOException e) {
            return Response.forStatus((StatusType)Status.BAD_REQUEST.withReasonPhrase("Invalid payload. " + e.getMessage()));
        }
        if (workflowConfig.serviceAccount().isPresent()) {
            String serviceAccount = (String)workflowConfig.serviceAccount().get();
            GoogleIdToken idToken = (GoogleIdToken)ac.user().orElseThrow(AssertionError::new);
            WorkflowId workflowId = WorkflowId.create((String)componentId, (String)workflowConfig.id());
            this.serviceAccountUsageAuthorizer.authorizeServiceAccountUsage(workflowId, serviceAccount, idToken);
        }
        if (!(errors = this.workflowValidator.validateWorkflowConfiguration(workflowConfig)).isEmpty()) {
            return Response.forStatus((StatusType)Status.BAD_REQUEST.withReasonPhrase("Invalid workflow configuration: " + errors));
        }
        Workflow workflow = Workflow.create((String)componentId, (WorkflowConfiguration)workflowConfig);
        try {
            oldWorkflowOptional = this.workflowInitializer.store(workflow);
        }
        catch (WorkflowInitializationException e) {
            return Response.forStatus((StatusType)Status.BAD_REQUEST.withReasonPhrase(e.getMessage()));
        }
        this.workflowConsumer.accept(oldWorkflowOptional, Optional.of(workflow));
        if (oldWorkflowOptional.isPresent()) {
            LOG.info("Workflow modified, old config: {}, new config: {}", (Object)oldWorkflowOptional.get(), (Object)workflow);
        } else {
            LOG.info("Workflow added: {}", (Object)workflow);
        }
        return Response.forPayload((Object)workflow);
    }

    private Response<Collection<Workflow>> workflows() {
        try {
            return Response.forPayload(this.storage.workflows().values());
        }
        catch (IOException e) {
            return Response.forStatus((StatusType)Status.INTERNAL_SERVER_ERROR.withReasonPhrase("Failed to get workflows"));
        }
    }

    private Response<List<Workflow>> workflows(String componentId) {
        try {
            return Response.forPayload((Object)this.storage.workflows(componentId));
        }
        catch (IOException e) {
            return Response.forStatus((StatusType)Status.INTERNAL_SERVER_ERROR.withReasonPhrase("Failed to get workflows of component " + componentId));
        }
    }

    private Response<WorkflowState> patchState(String componentId, String id, Request request) {
        WorkflowState patchState;
        Optional payload = request.payload();
        if (!payload.isPresent()) {
            return Response.forStatus((StatusType)Status.BAD_REQUEST.withReasonPhrase("Missing payload."));
        }
        WorkflowId workflowId = WorkflowId.create((String)componentId, (String)id);
        try {
            JsonNode json = Json.OBJECT_MAPPER.readTree(((ByteString)payload.get()).toByteArray());
            if (json.has("commit_sha") || json.has("docker_image")) {
                return Response.forStatus((StatusType)Status.BAD_REQUEST.withReasonPhrase("Invalid payload: commit_sha and docker_image not allowed."));
            }
            patchState = (WorkflowState)Json.OBJECT_MAPPER.readValue(((ByteString)payload.get()).toByteArray(), WorkflowState.class);
        }
        catch (IOException e) {
            return Response.forStatus((StatusType)Status.BAD_REQUEST.withReasonPhrase("Invalid payload."));
        }
        try {
            this.storage.patchState(workflowId, patchState);
        }
        catch (ResourceNotFoundException e) {
            return Response.forStatus((StatusType)Status.NOT_FOUND.withReasonPhrase(e.getMessage()));
        }
        catch (IOException e) {
            return Response.forStatus((StatusType)Status.INTERNAL_SERVER_ERROR.withReasonPhrase("Failed to update the state."));
        }
        return this.state(componentId, id);
    }

    private Response<Workflow> workflow(String componentId, String id) {
        try {
            return this.storage.workflow(WorkflowId.create((String)componentId, (String)id)).map(Response::forPayload).orElse(Response.forStatus((StatusType)Status.NOT_FOUND));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private Response<WorkflowState> state(String componentId, String id) {
        try {
            return Response.forPayload((Object)this.storage.workflowState(WorkflowId.create((String)componentId, (String)id)));
        }
        catch (IOException e) {
            return Response.forStatus((StatusType)Status.INTERNAL_SERVER_ERROR.withReasonPhrase("Couldn't fetch state."));
        }
    }

    private Response<List<WorkflowInstanceExecutionData>> instances(String componentId, String id, Request request) {
        List data;
        WorkflowId workflowId = WorkflowId.create((String)componentId, (String)id);
        String offset = request.parameter("offset").orElse("");
        int limit = request.parameter("limit").map(Integer::parseInt).orElse(168);
        String start = request.parameter("start").orElse("");
        String stop = request.parameter("stop").orElse("");
        boolean tail = Boolean.parseBoolean(request.parameter("tail").orElse(""));
        try {
            if (tail) {
                Optional workflow = this.storage.workflow(workflowId);
                if (!workflow.isPresent()) {
                    return Response.forStatus((StatusType)Status.NOT_FOUND.withReasonPhrase("Could not find workflow."));
                }
                WorkflowState workflowState = this.storage.workflowState(workflowId);
                if (!workflowState.nextNaturalTrigger().isPresent()) {
                    return Response.forStatus((StatusType)Status.NOT_FOUND.withReasonPhrase("No next natural trigger for workflow."));
                }
                Schedule schedule = ((Workflow)workflow.get()).configuration().schedule();
                Instant nextNaturalTrigger = (Instant)workflowState.nextNaturalTrigger().get();
                Instant startInstant = TimeUtil.offsetInstant((Instant)nextNaturalTrigger, (Schedule)schedule, (int)(-limit));
                String tailStart = ParameterUtil.toParameter((Schedule)schedule, (Instant)startInstant);
                String tailStop = ParameterUtil.toParameter((Schedule)schedule, (Instant)nextNaturalTrigger);
                data = this.storage.executionData(workflowId, tailStart, tailStop);
            } else {
                data = start.isEmpty() ? this.storage.executionData(workflowId, offset, limit) : this.storage.executionData(workflowId, start, stop);
            }
        }
        catch (IOException e) {
            return Response.forStatus((StatusType)Status.INTERNAL_SERVER_ERROR.withReasonPhrase("Couldn't fetch execution info."));
        }
        return Response.forPayload((Object)data);
    }

    private Response<WorkflowInstanceExecutionData> instance(String componentId, String id, String instanceId) {
        WorkflowId workflowId = WorkflowId.create((String)componentId, (String)id);
        WorkflowInstance workflowInstance = WorkflowInstance.create((WorkflowId)workflowId, (String)instanceId);
        try {
            WorkflowInstanceExecutionData workflowInstanceExecutionData = this.storage.executionData(workflowInstance);
            return Response.forPayload((Object)workflowInstanceExecutionData);
        }
        catch (ResourceNotFoundException e) {
            return Response.forStatus((StatusType)Status.NOT_FOUND.withReasonPhrase(e.getMessage()));
        }
        catch (IOException e) {
            return Response.forStatus((StatusType)Status.INTERNAL_SERVER_ERROR.withReasonPhrase("Couldn't fetch execution info."));
        }
    }

    private static String arg(String name, RequestContext rc) {
        return (String)rc.pathArgs().get(name);
    }
}

