/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.client.util.Lists;
import com.google.common.io.Closer;
import com.spotify.apollo.RequestContext;
import com.spotify.apollo.Response;
import com.spotify.apollo.Status;
import com.spotify.apollo.StatusType;
import com.spotify.apollo.entity.EntityCodec;
import com.spotify.apollo.entity.EntityMiddleware;
import com.spotify.apollo.entity.JacksonEntityCodec;
import com.spotify.apollo.route.AsyncHandler;
import com.spotify.apollo.route.Middleware;
import com.spotify.apollo.route.Route;
import com.spotify.styx.api.Api;
import com.spotify.styx.api.EventsPayload;
import com.spotify.styx.api.ResponseException;
import com.spotify.styx.api.RunStateDataPayload;
import com.spotify.styx.api.ServiceAccountUsageAuthorizer;
import com.spotify.styx.api.TestServiceAccountUsageAuthorizationRequest;
import com.spotify.styx.api.TestServiceAccountUsageAuthorizationResponse;
import com.spotify.styx.api.TestServiceAccountUsageAuthorizationResponseBuilder;
import com.spotify.styx.api.util.InvalidParametersException;
import com.spotify.styx.model.Event;
import com.spotify.styx.model.WorkflowId;
import com.spotify.styx.model.WorkflowInstance;
import com.spotify.styx.serialization.Json;
import com.spotify.styx.state.RunState;
import com.spotify.styx.storage.Storage;
import com.spotify.styx.util.CloserUtil;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javaslang.collection.Seq;
import javaslang.control.Try;
import okio.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusResource
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(StatusResource.class);
    private static final int CONCURRENCY = 32;
    static final String BASE = "/status";
    private final Storage storage;
    private final ServiceAccountUsageAuthorizer accountUsageAuthorizer;
    private final ForkJoinPool forkJoinPool;
    private final Closer closer = Closer.create();

    public StatusResource(Storage storage, ServiceAccountUsageAuthorizer accountUsageAuthorizer) {
        this.storage = Objects.requireNonNull(storage);
        this.accountUsageAuthorizer = Objects.requireNonNull(accountUsageAuthorizer);
        this.forkJoinPool = (ForkJoinPool)CloserUtil.register((Closer)this.closer, (ExecutorService)new ForkJoinPool(32), (String)"status-resource");
    }

    public Stream<Route<AsyncHandler<Response<ByteString>>>> routes() {
        EntityMiddleware em = EntityMiddleware.forCodec((EntityCodec)JacksonEntityCodec.forMapper((ObjectMapper)Json.OBJECT_MAPPER));
        List routes = Stream.of(Route.with((Middleware)em.serializerResponse(RunStateDataPayload.class), (String)"GET", (String)"/status/activeStates", this::activeStates), Route.with((Middleware)em.serializerDirect(EventsPayload.class), (String)"GET", (String)"/status/events/<cid>/<wfid>/<iid>", rc -> this.eventsForWorkflowInstance(StatusResource.arg("cid", rc), StatusResource.arg("wfid", rc), StatusResource.arg("iid", rc))), Route.with((Middleware)em.response(TestServiceAccountUsageAuthorizationRequest.class, TestServiceAccountUsageAuthorizationResponse.class), (String)"POST", (String)"/status/testServiceAccountUsageAuthorization", rc -> this::testServiceAccountUsageAuthorization)).map(r -> r.withMiddleware(Middleware::syncToAsync)).collect(Collectors.toList());
        return Api.prefixRoutes(routes, (Api.Version[])new Api.Version[]{Api.Version.V3});
    }

    @Override
    public void close() throws IOException {
        this.closer.close();
    }

    private Response<TestServiceAccountUsageAuthorizationResponse> testServiceAccountUsageAuthorization(TestServiceAccountUsageAuthorizationRequest request) {
        ServiceAccountUsageAuthorizer.ServiceAccountUsageAuthorizationResult result = this.accountUsageAuthorizer.checkServiceAccountUsageAuthorization(request.serviceAccount(), request.principal());
        result.errorResponse().ifPresent(e -> {
            throw new ResponseException(e);
        });
        TestServiceAccountUsageAuthorizationResponse response = new TestServiceAccountUsageAuthorizationResponseBuilder().authorized(result.authorized()).blacklisted(result.blacklisted()).serviceAccount(request.serviceAccount()).principal(request.principal()).message(result.message()).build();
        return Response.forPayload((Object)response);
    }

    private static String arg(String name, RequestContext rc) {
        return (String)rc.pathArgs().get(name);
    }

    private Response<RunStateDataPayload> activeStates(RequestContext requestContext) {
        Map<WorkflowInstance, RunState> activeStates;
        Optional componentOpt = requestContext.request().parameter("component");
        Optional workflowOpt = requestContext.request().parameter("workflow");
        Optional componentsOpt = requestContext.request().parameter("components");
        ArrayList runStates = Lists.newArrayList();
        try {
            activeStates = componentsOpt.isPresent() ? this.getActiveStates((String)componentsOpt.get()) : this.getActiveStates(componentOpt, workflowOpt);
        }
        catch (InvalidParametersException e) {
            return Response.forStatus((StatusType)Status.BAD_REQUEST.withReasonPhrase(e.getMessage()));
        }
        catch (IOException e) {
            String errorMsg = "Could not read Active states: " + e;
            log.error(errorMsg);
            return Response.forStatus((StatusType)Status.INTERNAL_SERVER_ERROR.withReasonPhrase(errorMsg));
        }
        runStates.addAll(activeStates.values().stream().map(this::runStateToRunStateData).collect(Collectors.toList()));
        return Response.forPayload((Object)RunStateDataPayload.create((List)runStates));
    }

    private Map<WorkflowInstance, RunState> getActiveStates(String componentsStr) throws IOException {
        HashSet<String> components = new HashSet<String>(Arrays.asList(componentsStr.split(",")));
        List activeStatesOrExceptions = (List)((ForkJoinTask)this.forkJoinPool.submit(() -> components.parallelStream().map(componentId -> Try.of(() -> this.storage.readActiveStates(componentId))).collect(Collectors.toList()))).join();
        return ((Seq)Try.sequence((Iterable)activeStatesOrExceptions).getOrElseThrow(IOException::new)).toJavaStream().flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<WorkflowInstance, RunState> getActiveStates(Optional<String> componentOpt, Optional<String> workflowOpt) throws IOException {
        if (workflowOpt.isPresent()) {
            if (componentOpt.isPresent()) {
                return this.storage.readActiveStates(componentOpt.get(), workflowOpt.get());
            }
            throw new InvalidParametersException("No component id specified!");
        }
        if (componentOpt.isPresent()) {
            return this.storage.readActiveStates(componentOpt.get());
        }
        return this.storage.readActiveStates();
    }

    private RunStateDataPayload.RunStateData runStateToRunStateData(RunState state) {
        return RunStateDataPayload.RunStateData.newBuilder().workflowInstance(state.workflowInstance()).state(state.state().name()).stateData(state.data()).latestTimestamp(Long.valueOf(state.timestamp())).build();
    }

    private EventsPayload eventsForWorkflowInstance(String cid, String eid, String iid) {
        WorkflowId workflowId = WorkflowId.create((String)cid, (String)eid);
        WorkflowInstance workflowInstance = WorkflowInstance.create((WorkflowId)workflowId, (String)iid);
        try {
            SortedSet sequenceEvents = this.storage.readEvents(workflowInstance);
            List timestampedEvents = sequenceEvents.stream().map(sequenceEvent -> EventsPayload.TimestampedEvent.create((Event)sequenceEvent.event(), (long)sequenceEvent.timestamp())).collect(Collectors.toList());
            return EventsPayload.create(timestampedEvents);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

