/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.api;

import com.google.common.collect.ImmutableSortedMap;
import com.spotify.apollo.Client;
import com.spotify.apollo.Request;
import com.spotify.apollo.RequestContext;
import com.spotify.apollo.Response;
import com.spotify.apollo.route.AsyncHandler;
import com.spotify.apollo.route.Route;
import com.spotify.styx.api.Api;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.stream.Stream;
import okhttp3.HttpUrl;
import okio.ByteString;
import org.slf4j.MDC;

public class SchedulerProxyResource {
    static final String BASE = "/scheduler";
    private static final String SCHEDULER_BASE_PATH = "/api/v0";
    private final String schedulerServiceBaseUrl;
    private final Client client;

    public SchedulerProxyResource(String schedulerServiceBaseUrl, Client client) {
        this.schedulerServiceBaseUrl = Objects.requireNonNull(schedulerServiceBaseUrl);
        this.client = Objects.requireNonNull(client, "client");
    }

    public Stream<Route<AsyncHandler<Response<ByteString>>>> routes() {
        List<Route> schedulerProxies = Arrays.asList(Route.async((String)"GET", (String)"/scheduler/<endpoint:path>", rc -> this.proxyToScheduler("/" + (String)rc.pathArgs().get("endpoint"), rc)), Route.async((String)"POST", (String)"/scheduler/<endpoint:path>", rc -> this.proxyToScheduler("/" + (String)rc.pathArgs().get("endpoint"), rc)), Route.async((String)"DELETE", (String)"/scheduler/<endpoint:path>", rc -> this.proxyToScheduler("/" + (String)rc.pathArgs().get("endpoint"), rc)), Route.async((String)"PATCH", (String)"/scheduler/<endpoint:path>", rc -> this.proxyToScheduler("/" + (String)rc.pathArgs().get("endpoint"), rc)), Route.async((String)"PUT", (String)"/scheduler/<endpoint:path>", rc -> this.proxyToScheduler("/" + (String)rc.pathArgs().get("endpoint"), rc)));
        return Api.prefixRoutes(schedulerProxies, (Api.Version[])new Api.Version[]{Api.Version.V3});
    }

    private CompletionStage<Response<ByteString>> proxyToScheduler(String path, RequestContext rc) {
        HttpUrl.Builder builder = Objects.requireNonNull(HttpUrl.parse((String)(this.schedulerServiceBaseUrl + SCHEDULER_BASE_PATH + path))).newBuilder();
        ImmutableSortedMap.copyOf((Map)rc.request().parameters()).forEach((name, values) -> values.forEach(value -> builder.addQueryParameter(name, value)));
        return this.client.send(this.withRequestId(rc.request().withUri(builder.build().toString())));
    }

    private Request withRequestId(Request request) {
        if (request.headers().containsKey("X-Request-Id")) {
            return request;
        }
        String requestId = MDC.get((String)"request-id");
        if (requestId == null) {
            return request;
        }
        return request.withHeader("X-Request-Id", requestId);
    }
}

