/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.client.util.Lists;
import com.spotify.apollo.RequestContext;
import com.spotify.apollo.Response;
import com.spotify.apollo.entity.EntityCodec;
import com.spotify.apollo.entity.EntityMiddleware;
import com.spotify.apollo.entity.JacksonEntityCodec;
import com.spotify.apollo.route.AsyncHandler;
import com.spotify.apollo.route.Middleware;
import com.spotify.apollo.route.Route;
import com.spotify.styx.api.Api;
import com.spotify.styx.api.EventsPayload;
import com.spotify.styx.api.ResponseException;
import com.spotify.styx.api.RunStateDataPayload;
import com.spotify.styx.api.ServiceAccountUsageAuthorizer;
import com.spotify.styx.api.TestServiceAccountUsageAuthorizationRequest;
import com.spotify.styx.api.TestServiceAccountUsageAuthorizationResponse;
import com.spotify.styx.api.TestServiceAccountUsageAuthorizationResponseBuilder;
import com.spotify.styx.model.Event;
import com.spotify.styx.model.WorkflowId;
import com.spotify.styx.model.WorkflowInstance;
import com.spotify.styx.serialization.Json;
import com.spotify.styx.state.RunState;
import com.spotify.styx.storage.Storage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import okio.ByteString;

public class StatusResource {
    static final String BASE = "/status";
    private final Storage storage;
    private final ServiceAccountUsageAuthorizer accountUsageAuthorizer;

    public StatusResource(Storage storage, ServiceAccountUsageAuthorizer accountUsageAuthorizer) {
        this.storage = Objects.requireNonNull(storage);
        this.accountUsageAuthorizer = Objects.requireNonNull(accountUsageAuthorizer);
    }

    public Stream<Route<AsyncHandler<Response<ByteString>>>> routes() {
        EntityMiddleware em = EntityMiddleware.forCodec((EntityCodec)JacksonEntityCodec.forMapper((ObjectMapper)Json.OBJECT_MAPPER));
        List routes = Stream.of(Route.with((Middleware)em.serializerDirect(RunStateDataPayload.class), (String)"GET", (String)"/status/activeStates", this::activeStates), Route.with((Middleware)em.serializerDirect(EventsPayload.class), (String)"GET", (String)"/status/events/<cid>/<wfid>/<iid>", rc -> this.eventsForWorkflowInstance(StatusResource.arg("cid", rc), StatusResource.arg("wfid", rc), StatusResource.arg("iid", rc))), Route.with((Middleware)em.response(TestServiceAccountUsageAuthorizationRequest.class, TestServiceAccountUsageAuthorizationResponse.class), (String)"POST", (String)"/status/testServiceAccountUsageAuthorization", rc -> this::testServiceAccountUsageAuthorization)).map(r -> r.withMiddleware(Middleware::syncToAsync)).collect(Collectors.toList());
        return Api.prefixRoutes(routes, (Api.Version[])new Api.Version[]{Api.Version.V3});
    }

    private Response<TestServiceAccountUsageAuthorizationResponse> testServiceAccountUsageAuthorization(TestServiceAccountUsageAuthorizationRequest request) {
        ServiceAccountUsageAuthorizer.ServiceAccountUsageAuthorizationResult result = this.accountUsageAuthorizer.checkServiceAccountUsageAuthorization(request.serviceAccount(), request.principal());
        result.errorResponse().ifPresent(e -> {
            throw new ResponseException(e);
        });
        TestServiceAccountUsageAuthorizationResponse response = new TestServiceAccountUsageAuthorizationResponseBuilder().authorized(result.authorized()).blacklisted(result.blacklisted()).serviceAccount(request.serviceAccount()).principal(request.principal()).message(result.message()).build();
        return Response.forPayload((Object)response);
    }

    private static String arg(String name, RequestContext rc) {
        return (String)rc.pathArgs().get(name);
    }

    private RunStateDataPayload activeStates(RequestContext requestContext) {
        Optional componentOpt = requestContext.request().parameter("component");
        ArrayList runStates = Lists.newArrayList();
        try {
            Map activeStates = componentOpt.isPresent() ? this.storage.readActiveStates((String)componentOpt.get()) : this.storage.readActiveStates();
            runStates.addAll(activeStates.values().stream().map(this::runStateToRunStateData).collect(Collectors.toList()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return RunStateDataPayload.create((List)runStates);
    }

    private RunStateDataPayload.RunStateData runStateToRunStateData(RunState state) {
        return RunStateDataPayload.RunStateData.newBuilder().workflowInstance(state.workflowInstance()).state(state.state().name()).stateData(state.data()).latestTimestamp(Long.valueOf(state.timestamp())).build();
    }

    private EventsPayload eventsForWorkflowInstance(String cid, String eid, String iid) {
        WorkflowId workflowId = WorkflowId.create((String)cid, (String)eid);
        WorkflowInstance workflowInstance = WorkflowInstance.create((WorkflowId)workflowId, (String)iid);
        try {
            SortedSet sequenceEvents = this.storage.readEvents(workflowInstance);
            List timestampedEvents = sequenceEvents.stream().map(sequenceEvent -> EventsPayload.TimestampedEvent.create((Event)sequenceEvent.event(), (long)sequenceEvent.timestamp())).collect(Collectors.toList());
            return EventsPayload.create(timestampedEvents);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

