/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx;

import com.google.cloud.datastore.Datastore;
import com.google.common.collect.Streams;
import com.google.common.io.Closer;
import com.spotify.apollo.AppInit;
import com.spotify.apollo.Environment;
import com.spotify.apollo.route.Route;
import com.spotify.metrics.core.SemanticMetricRegistry;
import com.spotify.styx.api.Api;
import com.spotify.styx.api.Authenticator;
import com.spotify.styx.api.AuthenticatorConfiguration;
import com.spotify.styx.api.AuthenticatorFactory;
import com.spotify.styx.api.BackfillResource;
import com.spotify.styx.api.RequestAuthenticator;
import com.spotify.styx.api.ResourceResource;
import com.spotify.styx.api.SchedulerProxyResource;
import com.spotify.styx.api.ServiceAccountUsageAuthorizer;
import com.spotify.styx.api.StatusResource;
import com.spotify.styx.api.WorkflowActionAuthorizer;
import com.spotify.styx.api.WorkflowResource;
import com.spotify.styx.api.workflow.WorkflowInitializer;
import com.spotify.styx.model.StyxConfig;
import com.spotify.styx.model.Workflow;
import com.spotify.styx.monitoring.MeteredStorageProxy;
import com.spotify.styx.monitoring.MetricsStats;
import com.spotify.styx.monitoring.Stats;
import com.spotify.styx.monitoring.StatsFactory;
import com.spotify.styx.storage.AggregateStorage;
import com.spotify.styx.storage.InstrumentedDatastore;
import com.spotify.styx.storage.Storage;
import com.spotify.styx.util.BasicWorkflowValidator;
import com.spotify.styx.util.CachedSupplier;
import com.spotify.styx.util.ConfigUtil;
import com.spotify.styx.util.Connections;
import com.spotify.styx.util.DockerImageValidator;
import com.spotify.styx.util.ExtendedWorkflowValidator;
import com.spotify.styx.util.StorageFactory;
import com.spotify.styx.util.Time;
import com.spotify.styx.util.WorkflowValidator;
import com.typesafe.config.Config;
import java.io.Closeable;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.hadoop.hbase.client.Connection;

public class StyxApi
implements AppInit {
    public static final String SERVICE_NAME = "styx-api";
    private static final String SCHEDULER_SERVICE_BASE_URL = "styx.scheduler.base-url";
    private static final String DEFAULT_SCHEDULER_SERVICE_BASE_URL = "http://localhost:8080";
    private static final String STYX_RUNNING_STATE_TTL_CONFIG = "styx.stale-state-ttls.running";
    private static final String STYX_SECRET_WHITELIST = "styx.secret-whitelist";
    private static final Duration DEFAULT_STYX_RUNNING_STATE_TTL = Duration.ofHours(24L);
    private final String serviceName;
    private final StorageFactory storageFactory;
    private final WorkflowConsumerFactory workflowConsumerFactory;
    private final StatsFactory statsFactory;
    private final AuthenticatorFactory authenticatorFactory;
    private final ServiceAccountUsageAuthorizer.Factory serviceAccountUsageAuthorizerFactory;
    private final Time time;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static StyxApi createDefault() {
        return StyxApi.newBuilder().build();
    }

    private StyxApi(Builder builder) {
        this.serviceName = Objects.requireNonNull(builder.serviceName);
        this.storageFactory = Objects.requireNonNull(builder.storageFactory);
        this.workflowConsumerFactory = Objects.requireNonNull(builder.workflowConsumerFactory);
        this.statsFactory = Objects.requireNonNull(builder.statsFactory);
        this.authenticatorFactory = Objects.requireNonNull(builder.authenticatorFactory);
        this.serviceAccountUsageAuthorizerFactory = Objects.requireNonNull(builder.serviceAccountUsageAuthorizerFactory);
        this.time = Objects.requireNonNull(builder.time);
    }

    public void create(Environment environment) {
        Config config = environment.config();
        String schedulerServiceBaseUrl = ConfigUtil.get((Config)config, arg_0 -> ((Config)config).getString(arg_0), (String)SCHEDULER_SERVICE_BASE_URL).orElse(DEFAULT_SCHEDULER_SERVICE_BASE_URL);
        Duration runningStateTtl = ConfigUtil.get((Config)config, arg_0 -> ((Config)config).getString(arg_0), (String)STYX_RUNNING_STATE_TTL_CONFIG).map(Duration::parse).orElse(DEFAULT_STYX_RUNNING_STATE_TTL);
        Set secretWhitelist = ConfigUtil.get((Config)config, arg_0 -> ((Config)config).getStringList(arg_0), (String)STYX_SECRET_WHITELIST).map(Set::copyOf).orElse(Set.of());
        Stats stats = (Stats)this.statsFactory.apply((Object)environment);
        Storage storage = MeteredStorageProxy.instrument((Storage)((Storage)this.storageFactory.apply((Object)environment, (Object)stats)), (Stats)stats, (Time)this.time);
        BiConsumer workflowConsumer = (BiConsumer)this.workflowConsumerFactory.apply(environment, stats);
        ServiceAccountUsageAuthorizer serviceAccountUsageAuthorizer = (ServiceAccountUsageAuthorizer)this.serviceAccountUsageAuthorizerFactory.apply((Object)config, (Object)this.serviceName);
        WorkflowActionAuthorizer workflowActionAuthorizer = new WorkflowActionAuthorizer(storage, serviceAccountUsageAuthorizer);
        ExtendedWorkflowValidator workflowValidator = new ExtendedWorkflowValidator((WorkflowValidator)new BasicWorkflowValidator(new DockerImageValidator()), runningStateTtl, secretWhitelist);
        WorkflowResource workflowResource = new WorkflowResource(storage, (WorkflowValidator)workflowValidator, new WorkflowInitializer(storage, this.time), workflowConsumer, workflowActionAuthorizer);
        BackfillResource backfillResource = new BackfillResource(schedulerServiceBaseUrl, storage, (WorkflowValidator)workflowValidator, this.time, workflowActionAuthorizer);
        StatusResource statusResource = new StatusResource(storage, serviceAccountUsageAuthorizer);
        environment.closer().register((Closeable)backfillResource);
        environment.closer().register((Closeable)statusResource);
        ResourceResource resourceResource = new ResourceResource(storage);
        SchedulerProxyResource schedulerProxyResource = new SchedulerProxyResource(schedulerServiceBaseUrl, environment.client());
        CachedSupplier configSupplier = new CachedSupplier(() -> ((Storage)storage).config(), Instant::now);
        Supplier<List> clientBlacklistSupplier = () -> StyxApi.lambda$create$0((Supplier)configSupplier);
        RequestAuthenticator requestAuthenticator = new RequestAuthenticator((Authenticator)this.authenticatorFactory.apply((Object)AuthenticatorConfiguration.fromConfig((Config)config, (String)this.serviceName)));
        Stream routes = Streams.concat((Stream[])new Stream[]{workflowResource.routes(requestAuthenticator), backfillResource.routes(requestAuthenticator), resourceResource.routes(), statusResource.routes(), schedulerProxyResource.routes()});
        environment.routingEngine().registerAutoRoute(Route.sync((String)"GET", (String)"/ping", rc -> "pong")).registerRoutes(Api.withCommonMiddleware((Stream)routes, clientBlacklistSupplier, (RequestAuthenticator)requestAuthenticator, (String)this.serviceName));
    }

    private static AggregateStorage storage(Environment environment, Stats stats) {
        Config config = environment.config();
        Closer closer = environment.closer();
        Connection bigTable = (Connection)closer.register((Closeable)Connections.createBigTableConnection((Config)config));
        InstrumentedDatastore datastore = Connections.createDatastore((Config)config, (Stats)stats);
        return (AggregateStorage)closer.register((Closeable)new AggregateStorage(bigTable, (Datastore)datastore));
    }

    private static Stats stats(Environment environment) {
        return new MetricsStats((SemanticMetricRegistry)environment.resolve(SemanticMetricRegistry.class), Instant::now);
    }

    private static /* synthetic */ List lambda$create$0(Supplier configSupplier) {
        return ((StyxConfig)configSupplier.get()).clientBlacklist();
    }

    public static class Builder {
        private String serviceName = "styx-api";
        private StorageFactory storageFactory = (x$0, x$1) -> StyxApi.storage(x$0, x$1);
        private WorkflowConsumerFactory workflowConsumerFactory = (env, stats) -> (oldWorkflow, newWorkflow) -> {};
        private StatsFactory statsFactory = x$0 -> StyxApi.stats(x$0);
        private AuthenticatorFactory authenticatorFactory = AuthenticatorFactory.DEFAULT;
        private ServiceAccountUsageAuthorizer.Factory serviceAccountUsageAuthorizerFactory = ServiceAccountUsageAuthorizer.Factory.DEFAULT;
        private Time time = Instant::now;

        public Builder setServiceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Builder setStorageFactory(StorageFactory storageFactory) {
            this.storageFactory = storageFactory;
            return this;
        }

        public Builder setWorkflowConsumerFactory(WorkflowConsumerFactory workflowConsumerFactory) {
            this.workflowConsumerFactory = workflowConsumerFactory;
            return this;
        }

        public Builder setStatsFactory(StatsFactory statsFactory) {
            this.statsFactory = statsFactory;
            return this;
        }

        public Builder setAuthenticatorFactory(AuthenticatorFactory authenticatorFactory) {
            this.authenticatorFactory = authenticatorFactory;
            return this;
        }

        public Builder setServiceAccountUsageAuthorizerFactory(ServiceAccountUsageAuthorizer.Factory serviceAccountUsageAuthorizerFactory) {
            this.serviceAccountUsageAuthorizerFactory = serviceAccountUsageAuthorizerFactory;
            return this;
        }

        public Builder setTime(Time time) {
            this.time = time;
            return this;
        }

        public StyxApi build() {
            return new StyxApi(this);
        }
    }

    public static interface WorkflowConsumerFactory
    extends BiFunction<Environment, Stats, BiConsumer<Optional<Workflow>, Optional<Workflow>>> {
    }
}

