/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.flyte.client;

import com.spotify.styx.util.ParameterUtil;
import flyteidl.core.Interface;
import flyteidl.core.Literals;
import flyteidl.core.Types;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlyteInputsUtils {
    static final String PARAMETER_NAME = "styx_parameter";
    private static final Logger LOG = LoggerFactory.getLogger(FlyteInputsUtils.class);

    private FlyteInputsUtils() {
        throw new UnsupportedOperationException();
    }

    static Literals.Literal buildLiteralForPartition(String value) {
        Literals.Primitive primitive = Literals.Primitive.newBuilder().setDatetime(ParameterUtil.parseBest((String)value)).build();
        return Literals.Literal.newBuilder().setScalar(Literals.Scalar.newBuilder().setPrimitive(primitive).build()).build();
    }

    static Literals.LiteralMap fillParameterInInputs(Interface.ParameterMap parameterMap, String parameter) {
        Literals.LiteralMap.Builder literalMapBuilder = Literals.LiteralMap.newBuilder();
        parameterMap.getParametersMap().forEach((key, value) -> {
            if (!key.toLowerCase().equals(PARAMETER_NAME)) {
                if (value.hasDefault()) {
                    literalMapBuilder.putLiterals((String)key, value.getDefault());
                    return;
                }
                String message = "LP inputs must have default values. Missing default value for key:" + key;
                LOG.error(message);
                throw new UnsupportedOperationException(message);
            }
            if (value.getVar().getType().getSimple() != Types.SimpleType.DATETIME) {
                String message = "styx_parameter should be of type DATETIME";
                LOG.error(message);
                throw new IllegalArgumentException(message);
            }
            Literals.Literal literal = FlyteInputsUtils.buildLiteralForPartition(parameter);
            literalMapBuilder.putLiterals((String)key, literal);
        });
        return literalMapBuilder.build();
    }
}

