/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.flyte.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import flyteidl.admin.Common;
import flyteidl.admin.ExecutionOuterClass;
import flyteidl.core.IdentifierOuterClass;
import flyteidl.service.AdminServiceGrpc;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlyteAdminClient {
    private static final Logger log = LoggerFactory.getLogger(FlyteAdminClient.class);
    private static final String TRIGGERING_PRINCIPAL = "styx";
    private static final int USER_TRIGGERED_EXECUTION_NESTING = 0;
    private final AdminServiceGrpc.AdminServiceBlockingStub stub;

    @VisibleForTesting
    FlyteAdminClient(AdminServiceGrpc.AdminServiceBlockingStub stub) {
        this.stub = Objects.requireNonNull(stub, "stub");
    }

    public static FlyteAdminClient create(String target, boolean insecure) {
        ManagedChannelBuilder builder = ManagedChannelBuilder.forTarget((String)target);
        if (insecure) {
            builder.usePlaintext();
        }
        ManagedChannel channel = builder.build();
        return new FlyteAdminClient(AdminServiceGrpc.newBlockingStub((Channel)channel));
    }

    public ExecutionOuterClass.ExecutionCreateResponse createExecution(String project, String domain, IdentifierOuterClass.Identifier launchPlanId, ExecutionOuterClass.ExecutionMetadata.ExecutionMode executionMode) {
        log.debug("createExecution {} {} {}", new Object[]{project, domain, launchPlanId});
        ExecutionOuterClass.ExecutionMetadata metadata = ExecutionOuterClass.ExecutionMetadata.newBuilder().setMode(executionMode).setPrincipal(TRIGGERING_PRINCIPAL).setNesting(0).build();
        ExecutionOuterClass.ExecutionSpec spec = ExecutionOuterClass.ExecutionSpec.newBuilder().setLaunchPlan(launchPlanId).setMetadata(metadata).build();
        ExecutionOuterClass.ExecutionCreateResponse response = this.stub.createExecution(ExecutionOuterClass.ExecutionCreateRequest.newBuilder().setDomain(domain).setProject(project).setSpec(spec).build());
        Verify.verifyNotNull((Object)response, (String)"Unexpected null response when creating execution %s on project %s domain %s", (Object[])new Object[]{launchPlanId, project, domain});
        return response;
    }

    public ExecutionOuterClass.Execution getExecution(String project, String domain, String name) {
        log.debug("getExecution {} {} {}", new Object[]{project, domain, name});
        ExecutionOuterClass.WorkflowExecutionGetRequest request = ExecutionOuterClass.WorkflowExecutionGetRequest.newBuilder().setId(IdentifierOuterClass.WorkflowExecutionIdentifier.newBuilder().setProject(project).setDomain(domain).setName(name).build()).build();
        ExecutionOuterClass.Execution execution = this.stub.getExecution(request);
        return execution;
    }

    public ExecutionOuterClass.ExecutionTerminateResponse terminateExecution(String project, String domain, String name, String cause) {
        log.debug("terminateExecution {} {} {}", new Object[]{project, domain, name});
        ExecutionOuterClass.ExecutionTerminateRequest request = ExecutionOuterClass.ExecutionTerminateRequest.newBuilder().setId(IdentifierOuterClass.WorkflowExecutionIdentifier.newBuilder().setProject(project).setDomain(domain).setName(name).build()).setCause(cause).build();
        ExecutionOuterClass.ExecutionTerminateResponse executionTerminateResponse = this.stub.terminateExecution(request);
        return executionTerminateResponse;
    }

    public ExecutionOuterClass.ExecutionList listExecutions(String project, String domain, int limit, String token, String filters) {
        log.debug("listExecutions {} {} {} {}", new Object[]{project, domain, limit, token});
        Common.ResourceListRequest request = Common.ResourceListRequest.newBuilder().setId(Common.NamedEntityIdentifier.newBuilder().setProject(project).setDomain(domain).build()).setLimit(limit).setToken(token).setFilters(filters).build();
        ExecutionOuterClass.ExecutionList executions = this.stub.listExecutions(request);
        return executions;
    }
}

