/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.zoltar;

import com.spotify.zoltar.Model;
import com.spotify.zoltar.mlengine.MlEngineLoader;
import com.spotify.zoltar.tf.TensorFlowGraphLoader;
import com.spotify.zoltar.tf.TensorFlowLoader;
import com.spotify.zoltar.tf.TensorFlowModel;
import com.spotify.zoltar.xgboost.XGBoostLoader;
import javax.annotation.Nullable;
import org.tensorflow.proto.framework.ConfigProto;

public final class Models {
    private Models() {
    }

    public static XGBoostLoader xgboost(String modelUri) {
        return XGBoostLoader.create((String)modelUri);
    }

    public static XGBoostLoader xgboost(Model.Id id, String modelUri) {
        return XGBoostLoader.create((Model.Id)id, (String)modelUri);
    }

    public static TensorFlowLoader tensorFlow(String modelUri) {
        return TensorFlowLoader.create((String)modelUri);
    }

    public static TensorFlowLoader tensorFlow(Model.Id id, String modelUri) {
        return TensorFlowLoader.create((Model.Id)id, (String)modelUri);
    }

    public static TensorFlowLoader tensorFlow(String modelUri, TensorFlowModel.Options options) {
        return TensorFlowLoader.create((String)modelUri, (TensorFlowModel.Options)options);
    }

    public static TensorFlowLoader tensorFlow(Model.Id id, String modelUri, TensorFlowModel.Options options) {
        return TensorFlowLoader.create((Model.Id)id, (String)modelUri, (TensorFlowModel.Options)options);
    }

    public static TensorFlowGraphLoader tensorFlowGraph(String modelUri, @Nullable ConfigProto config, @Nullable String prefix) {
        return TensorFlowGraphLoader.create((String)modelUri, (ConfigProto)config, (String)prefix);
    }

    public static TensorFlowGraphLoader tensorFlowGraph(Model.Id id, String modelUri, @Nullable ConfigProto config, @Nullable String prefix) {
        return TensorFlowGraphLoader.create((Model.Id)id, (String)modelUri, (ConfigProto)config, (String)prefix);
    }

    public static TensorFlowGraphLoader tensorFlowGraph(byte[] graphDef, @Nullable ConfigProto config, @Nullable String prefix) {
        return TensorFlowGraphLoader.create((byte[])graphDef, (ConfigProto)config, (String)prefix);
    }

    public static TensorFlowGraphLoader tensorFlowGraph(Model.Id id, byte[] graphDef, @Nullable ConfigProto config, @Nullable String prefix) {
        return TensorFlowGraphLoader.create((Model.Id)id, (byte[])graphDef, (ConfigProto)config, (String)prefix);
    }

    public static MlEngineLoader mlEngine(Model.Id id) {
        return MlEngineLoader.create((Model.Id)id);
    }

    public static MlEngineLoader mlEngine(String projectId, String modelId, String versionId) {
        return MlEngineLoader.create((String)projectId, (String)modelId, (String)versionId);
    }
}

