/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.zoltar;

import com.spotify.zoltar.DefaultPredictorBuilder;
import com.spotify.zoltar.FeatureExtractFns;
import com.spotify.zoltar.FeatureExtractor;
import com.spotify.zoltar.Model;
import com.spotify.zoltar.ModelLoader;
import com.spotify.zoltar.PredictFns;
import com.spotify.zoltar.Predictor;
import com.spotify.zoltar.PredictorBuilder;
import com.spotify.zoltar.metrics.Instrumentations;
import com.spotify.zoltar.metrics.PredictorMetrics;
import com.spotify.zoltar.tf.TensorFlowLoader;
import com.spotify.zoltar.tf.TensorFlowModel;
import com.spotify.zoltar.tf.TensorFlowPredictFn;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.tensorflow.Tensor;
import org.tensorflow.proto.example.Example;

public final class Predictors {
    private Predictors() {
    }

    public static <ModelT extends Model<?>, InputT, VectorT, ValueT> PredictorBuilder<ModelT, InputT, VectorT, ValueT> newBuilder(ModelLoader<ModelT> modelLoader, FeatureExtractFns.ExtractFn<InputT, VectorT> extractFn, PredictFns.PredictFn<ModelT, InputT, VectorT, ValueT> predictFn) {
        return DefaultPredictorBuilder.create(modelLoader, extractFn, predictFn);
    }

    public static <ModelT extends Model<?>, InputT, VectorT, ValueT> PredictorBuilder<ModelT, InputT, VectorT, ValueT> newBuilder(ModelLoader<ModelT> modelLoader, FeatureExtractFns.ExtractFn<InputT, VectorT> extractFn, PredictFns.AsyncPredictFn<ModelT, InputT, VectorT, ValueT> predictFn) {
        return DefaultPredictorBuilder.create(modelLoader, extractFn, predictFn);
    }

    public static <ModelT extends Model<?>, InputT, VectorT, ValueT> PredictorBuilder<ModelT, InputT, VectorT, ValueT> newBuilder(ModelLoader<ModelT> modelLoader, FeatureExtractor<ModelT, InputT, VectorT> featureExtractor, PredictFns.PredictFn<ModelT, InputT, VectorT, ValueT> predictFn) {
        return DefaultPredictorBuilder.create(modelLoader, featureExtractor, predictFn);
    }

    public static <ModelT extends Model<?>, InputT, VectorT, ValueT> PredictorBuilder<ModelT, InputT, VectorT, ValueT> newBuilder(ModelLoader<ModelT> modelLoader, FeatureExtractor<ModelT, InputT, VectorT> featureExtractor, PredictFns.AsyncPredictFn<ModelT, InputT, VectorT, ValueT> predictFn) {
        return DefaultPredictorBuilder.create(modelLoader, featureExtractor, predictFn);
    }

    public static <ModelT extends Model<?>, InputT, VectorT, ValueT> PredictorBuilder<ModelT, InputT, VectorT, ValueT> newBuilder(ModelLoader<ModelT> modelLoader, FeatureExtractFns.ExtractFn<InputT, VectorT> extractFn, PredictFns.PredictFn<ModelT, InputT, VectorT, ValueT> predictFn, PredictorMetrics<InputT, VectorT, ValueT> metrics) {
        return DefaultPredictorBuilder.create(modelLoader, extractFn, predictFn).with(Instrumentations.predictor(metrics));
    }

    public static <ModelT extends Model<?>, InputT, VectorT, ValueT> PredictorBuilder<ModelT, InputT, VectorT, ValueT> newBuilder(ModelLoader<ModelT> modelLoader, FeatureExtractFns.ExtractFn<InputT, VectorT> extractFn, PredictFns.AsyncPredictFn<ModelT, InputT, VectorT, ValueT> predictFn, PredictorMetrics<InputT, VectorT, ValueT> metrics) {
        return DefaultPredictorBuilder.create(modelLoader, extractFn, predictFn).with(Instrumentations.predictor(metrics));
    }

    public static <ModelT extends Model<?>, InputT, VectorT, ValueT> PredictorBuilder<ModelT, InputT, VectorT, ValueT> newBuilder(ModelLoader<ModelT> modelLoader, FeatureExtractor<ModelT, InputT, VectorT> featureExtractor, PredictFns.PredictFn<ModelT, InputT, VectorT, ValueT> predictFn, PredictorMetrics<InputT, VectorT, ValueT> metrics) {
        return DefaultPredictorBuilder.create(modelLoader, featureExtractor, predictFn).with(Instrumentations.predictor(metrics));
    }

    public static <ModelT extends Model<?>, InputT, VectorT, ValueT> PredictorBuilder<ModelT, InputT, VectorT, ValueT> newBuilder(ModelLoader<ModelT> modelLoader, FeatureExtractor<ModelT, InputT, VectorT> featureExtractor, PredictFns.AsyncPredictFn<ModelT, InputT, VectorT, ValueT> predictFn, PredictorMetrics<InputT, VectorT, ValueT> metrics) {
        return DefaultPredictorBuilder.create(modelLoader, featureExtractor, predictFn).with(Instrumentations.predictor(metrics));
    }

    public static <InputT, ValueT> Predictor<InputT, ValueT> tensorFlow(String modelUri, FeatureExtractFns.ExtractFn<InputT, Example> extractFn, Function<Map<String, Tensor<?>>, List<ValueT>> outTensorExtractor, String ... fetchOps) {
        return Predictors.tensorFlow(modelUri, FeatureExtractor.create(extractFn), outTensorExtractor, fetchOps);
    }

    public static <InputT, ValueT> Predictor<InputT, ValueT> tensorFlow(String modelUri, FeatureExtractFns.ExtractFn<InputT, Example> extractFn, Function<Map<String, Tensor<?>>, List<ValueT>> outTensorExtractor, String[] fetchOps, PredictorMetrics<InputT, Example, ValueT> metrics) {
        return Predictors.tensorFlow(modelUri, FeatureExtractor.create(extractFn), outTensorExtractor, fetchOps, metrics);
    }

    public static <InputT, ValueT> Predictor<InputT, ValueT> tensorFlow(String modelUri, FeatureExtractor<TensorFlowModel, InputT, Example> featureExtractor, Function<Map<String, Tensor<?>>, List<ValueT>> outTensorExtractor, String ... fetchOps) {
        TensorFlowLoader modelLoader = TensorFlowLoader.create((String)modelUri);
        TensorFlowPredictFn predictFn = TensorFlowPredictFn.example(outTensorExtractor, (String[])fetchOps);
        return Predictors.newBuilder(modelLoader, featureExtractor, predictFn).predictor();
    }

    public static <InputT, ValueT> Predictor<InputT, ValueT> tensorFlow(String modelUri, FeatureExtractor<TensorFlowModel, InputT, Example> featureExtractor, Function<Map<String, Tensor<?>>, List<ValueT>> outTensorExtractor, String[] fetchOps, PredictorMetrics<InputT, Example, ValueT> metrics) {
        TensorFlowLoader modelLoader = TensorFlowLoader.create((String)modelUri);
        TensorFlowPredictFn predictFn = TensorFlowPredictFn.example(outTensorExtractor, (String[])fetchOps);
        return Predictors.newBuilder(modelLoader, featureExtractor, predictFn, metrics).predictor();
    }

    public static <ValueT> Predictor<Example, ValueT> tensorFlow(String modelUri, Function<Map<String, Tensor<?>>, List<ValueT>> outTensorExtractor, String[] fetchOps, PredictorMetrics<Example, Example, ValueT> metrics) {
        return Predictors.tensorFlow(modelUri, FeatureExtractFns.ExtractFn.identity(), outTensorExtractor, fetchOps, metrics);
    }
}

