/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.zoltar.metrics;

import com.google.auto.value.AutoValue;
import com.spotify.zoltar.FeatureExtractor;
import com.spotify.zoltar.Model;
import com.spotify.zoltar.ModelLoader;
import com.spotify.zoltar.PredictFns;
import com.spotify.zoltar.Predictor;
import com.spotify.zoltar.PredictorBuilder;
import com.spotify.zoltar.metrics.AutoValue_InstrumentedPredictorBuilder;
import com.spotify.zoltar.metrics.FeatureExtractorMetrics;
import com.spotify.zoltar.metrics.InstrumentedFeatureExtractor;
import com.spotify.zoltar.metrics.InstrumentedPredictFn;
import com.spotify.zoltar.metrics.PredictFnMetrics;
import com.spotify.zoltar.metrics.PredictorMetrics;
import java.util.function.Function;

@AutoValue
public abstract class InstrumentedPredictorBuilder<ModelT extends Model<?>, InputT, VectorT, ValueT>
implements PredictorBuilder<ModelT, InputT, VectorT, ValueT> {
    public abstract PredictorBuilder<ModelT, InputT, VectorT, ValueT> predictorBuilder();

    public abstract PredictorMetrics<InputT, VectorT, ValueT> metrics();

    static <ModelT extends Model<?>, InputT, VectorT, ValueT> Function<PredictorBuilder<ModelT, InputT, VectorT, ValueT>, InstrumentedPredictorBuilder<ModelT, InputT, VectorT, ValueT>> create(PredictorMetrics<InputT, VectorT, ValueT> metrics) {
        return predictorBuilder -> {
            FeatureExtractorMetrics featureExtractorMetrics = metrics.featureExtractorMetrics();
            InstrumentedFeatureExtractor featureExtractor = (InstrumentedFeatureExtractor)predictorBuilder.featureExtractor().with(InstrumentedFeatureExtractor.create(featureExtractorMetrics));
            PredictFnMetrics predictFnMetrics = metrics.predictFnMetrics();
            InstrumentedPredictFn predictFn = (InstrumentedPredictFn)predictorBuilder.predictFn().with(InstrumentedPredictFn.create(predictFnMetrics));
            ModelLoader modelLoader = predictorBuilder.modelLoader();
            PredictorBuilder pb = predictorBuilder.with(modelLoader, (FeatureExtractor)featureExtractor, (PredictFns.AsyncPredictFn)predictFn);
            return new AutoValue_InstrumentedPredictorBuilder(pb, metrics);
        };
    }

    public ModelLoader<ModelT> modelLoader() {
        return this.predictorBuilder().modelLoader();
    }

    public FeatureExtractor<ModelT, InputT, VectorT> featureExtractor() {
        return this.predictorBuilder().featureExtractor();
    }

    public PredictFns.AsyncPredictFn<ModelT, InputT, VectorT, ValueT> predictFn() {
        return this.predictorBuilder().predictFn();
    }

    public Predictor<InputT, ValueT> predictor() {
        return this.predictorBuilder().predictor();
    }

    public InstrumentedPredictorBuilder<ModelT, InputT, VectorT, ValueT> with(ModelLoader<ModelT> modelLoader, FeatureExtractor<ModelT, InputT, VectorT> featureExtractor, PredictFns.AsyncPredictFn<ModelT, InputT, VectorT, ValueT> predictFn) {
        PredictorBuilder pb = this.predictorBuilder().with(modelLoader, featureExtractor, predictFn);
        return InstrumentedPredictorBuilder.create(this.metrics()).apply(pb);
    }
}

