/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.zoltar.metrics.semantic;

import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import com.google.auto.value.AutoValue;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.spotify.metrics.core.MetricId;
import com.spotify.metrics.core.SemanticMetricRegistry;
import com.spotify.zoltar.Model;
import com.spotify.zoltar.metrics.FeatureExtractorMetrics;
import com.spotify.zoltar.metrics.PredictFnMetrics;
import com.spotify.zoltar.metrics.PredictorMetrics;
import com.spotify.zoltar.metrics.semantic.AutoValue_SemanticPredictorMetrics;
import com.spotify.zoltar.metrics.semantic.AutoValue_SemanticPredictorMetrics_Metrics;
import com.spotify.zoltar.metrics.semantic.SemanticPredictMetrics;
import com.spotify.zoltar.metrics.semantic.SemanticVectorMetrics;
import com.spotify.zoltar.metrics.semantic.What;

@AutoValue
public abstract class SemanticPredictorMetrics<InputT, VectorT, ValueT>
implements PredictorMetrics<InputT, VectorT, ValueT> {
    abstract LoadingCache<Model.Id, Metrics> metricsCache();

    public static <InputT, VectorT, ValueT> SemanticPredictorMetrics<InputT, VectorT, ValueT> create(final SemanticMetricRegistry registry, final MetricId metricId) {
        LoadingCache metersCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Model.Id, Metrics>(){

            public Metrics load(Model.Id id) {
                return Metrics.create(registry, metricId.tagged("model", id.value()));
            }
        });
        return new AutoValue_SemanticPredictorMetrics((LoadingCache<Model.Id, Metrics>)metersCache);
    }

    @Override
    public PredictFnMetrics<InputT, ValueT> predictFnMetrics() {
        return id -> {
            Metrics metrics = (Metrics)this.metricsCache().getUnchecked(id);
            Timer.Context time = metrics.predictDurationTimer().time();
            Meter meter = metrics.predictRateCounter();
            return SemanticPredictMetrics.create(time, meter);
        };
    }

    @Override
    public FeatureExtractorMetrics<InputT, VectorT> featureExtractorMetrics() {
        return id -> {
            Metrics metrics = (Metrics)this.metricsCache().getUnchecked(id);
            Timer.Context time = metrics.extractDurationTimer().time();
            Meter meter = metrics.extractRateCounter();
            return SemanticVectorMetrics.create(time, meter);
        };
    }

    @AutoValue
    static abstract class Metrics {
        Metrics() {
        }

        abstract Timer predictDurationTimer();

        abstract Meter predictRateCounter();

        abstract Timer extractDurationTimer();

        abstract Meter extractRateCounter();

        static Metrics create(SemanticMetricRegistry registry, MetricId metricId) {
            MetricId predictDurationId = metricId.tagged("what", What.PREDICT_DURATION.tag());
            MetricId predictRateId = metricId.tagged("what", What.PREDICT_RATE.tag());
            MetricId extractDuration = metricId.tagged("what", What.FEATURE_EXTRACT_DURATION.tag());
            MetricId extractRate = metricId.tagged("what", What.FEATURE_EXTRACT_RATE.tag());
            Timer predictTimer = registry.timer(predictDurationId);
            Meter predictMeter = registry.meter(predictRateId);
            Timer extractTimer = registry.timer(extractDuration);
            Meter extractMeter = registry.meter(extractRate);
            return new AutoValue_SemanticPredictorMetrics_Metrics(predictTimer, predictMeter, extractTimer, extractMeter);
        }
    }
}

