/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.zoltar.tf;

import com.google.auto.value.AutoValue;
import com.google.protobuf.InvalidProtocolBufferException;
import com.spotify.zoltar.Model;
import com.spotify.zoltar.fs.FileSystemExtras;
import com.spotify.zoltar.tf.AutoValue_TensorFlowGraphModel;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensorflow.Graph;
import org.tensorflow.Session;
import org.tensorflow.proto.framework.ConfigProto;
import org.tensorflow.proto.framework.GraphDef;

@AutoValue
public abstract class TensorFlowGraphModel
implements Model<Session>,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(TensorFlowGraphModel.class);
    private static final Model.Id DEFAULT_ID = Model.Id.create((String)"tensorflow-graph");

    public static TensorFlowGraphModel create(URI graphUri, @Nullable ConfigProto config, @Nullable String prefix) throws IOException {
        return TensorFlowGraphModel.create(DEFAULT_ID, graphUri, config, prefix);
    }

    public static TensorFlowGraphModel create(Model.Id id, URI graphUri, @Nullable ConfigProto config, @Nullable String prefix) throws IOException {
        byte[] graphBytes = Files.readAllBytes(FileSystemExtras.path((URI)graphUri));
        return TensorFlowGraphModel.create(id, graphBytes, config, prefix);
    }

    public static TensorFlowGraphModel create(byte[] graphDef, @Nullable ConfigProto config, @Nullable String prefix) throws IOException {
        return TensorFlowGraphModel.create(DEFAULT_ID, graphDef, config, prefix);
    }

    public static TensorFlowGraphModel create(Model.Id id, byte[] graphDef, @Nullable ConfigProto config, @Nullable String prefix) {
        Graph graph = new Graph();
        Session session = new Session(graph, config);
        long loadStart = System.currentTimeMillis();
        try {
            if (prefix == null) {
                LOG.debug("Loading graph definition without prefix");
                graph.importGraphDef(GraphDef.parseFrom((byte[])graphDef));
            } else {
                LOG.debug("Loading graph definition with prefix: {}", (Object)prefix);
                graph.importGraphDef(GraphDef.parseFrom((byte[])graphDef), prefix);
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        LOG.info("TensorFlow graph loaded in {} ms", (Object)(System.currentTimeMillis() - loadStart));
        return new AutoValue_TensorFlowGraphModel(id, graph, session);
    }

    @Override
    public void close() {
        if (this.instance() != null) {
            LOG.debug("Closing TensorFlow session");
            this.instance().close();
        }
        if (this.graph() != null) {
            LOG.debug("Closing TensorFlow graph");
            this.graph().close();
        }
    }

    public abstract Graph graph();

    public abstract Session instance();
}

