/*
 * Decompiled with CFR 0.152.
 */
package com.spring4all.swagger;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.spring4all.swagger.Swagger2Configuration;
import com.spring4all.swagger.SwaggerProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMethod;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.builders.ResponseMessageBuilder;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.ApiKey;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.Contact;
import springfox.documentation.service.Parameter;
import springfox.documentation.service.ResponseMessage;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger.web.ApiKeyVehicle;
import springfox.documentation.swagger.web.UiConfiguration;
import springfox.documentation.swagger.web.UiConfigurationBuilder;

@Configuration
@Import(value={Swagger2Configuration.class})
public class SwaggerAutoConfiguration
implements BeanFactoryAware {
    private BeanFactory beanFactory;

    @Bean
    @ConditionalOnMissingBean
    public SwaggerProperties swaggerProperties() {
        return new SwaggerProperties();
    }

    @Bean
    public UiConfiguration uiConfiguration(SwaggerProperties swaggerProperties) {
        return UiConfigurationBuilder.builder().deepLinking(swaggerProperties.getUiConfig().getDeepLinking()).defaultModelExpandDepth(swaggerProperties.getUiConfig().getDefaultModelExpandDepth()).defaultModelRendering(swaggerProperties.getUiConfig().getDefaultModelRendering()).defaultModelsExpandDepth(swaggerProperties.getUiConfig().getDefaultModelsExpandDepth()).displayOperationId(swaggerProperties.getUiConfig().getDisplayOperationId()).displayRequestDuration(swaggerProperties.getUiConfig().getDisplayRequestDuration()).docExpansion(swaggerProperties.getUiConfig().getDocExpansion()).maxDisplayedTags(swaggerProperties.getUiConfig().getMaxDisplayedTags()).operationsSorter(swaggerProperties.getUiConfig().getOperationsSorter()).showExtensions(swaggerProperties.getUiConfig().getShowExtensions()).tagsSorter(swaggerProperties.getUiConfig().getTagsSorter()).validatorUrl(swaggerProperties.getUiConfig().getValidatorUrl()).build();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={UiConfiguration.class})
    @ConditionalOnProperty(name={"swagger.enabled"}, matchIfMissing=true)
    public List<Docket> createRestApi(SwaggerProperties swaggerProperties) {
        ConfigurableBeanFactory configurableBeanFactory = (ConfigurableBeanFactory)this.beanFactory;
        LinkedList<Docket> docketList = new LinkedList<Docket>();
        if (swaggerProperties.getDocket().size() == 0) {
            ApiInfo apiInfo = new ApiInfoBuilder().title(swaggerProperties.getTitle()).description(swaggerProperties.getDescription()).version(swaggerProperties.getVersion()).license(swaggerProperties.getLicense()).licenseUrl(swaggerProperties.getLicenseUrl()).contact(new Contact(swaggerProperties.getContact().getName(), swaggerProperties.getContact().getUrl(), swaggerProperties.getContact().getEmail())).termsOfServiceUrl(swaggerProperties.getTermsOfServiceUrl()).build();
            if (swaggerProperties.getBasePath().isEmpty()) {
                swaggerProperties.getBasePath().add("/**");
            }
            ArrayList<Predicate> basePath = new ArrayList<Predicate>();
            for (String string : swaggerProperties.getBasePath()) {
                basePath.add(PathSelectors.ant((String)string));
            }
            ArrayList<Predicate> excludePath = new ArrayList<Predicate>();
            for (String path : swaggerProperties.getExcludePath()) {
                excludePath.add(PathSelectors.ant((String)path));
            }
            Docket docket = new Docket(DocumentationType.SWAGGER_2).host(swaggerProperties.getHost()).apiInfo(apiInfo).securitySchemes(Collections.singletonList(this.apiKey())).securityContexts(Collections.singletonList(this.securityContext())).globalOperationParameters(this.buildGlobalOperationParametersFromSwaggerProperties(swaggerProperties.getGlobalOperationParameters()));
            if (!swaggerProperties.getApplyDefaultResponseMessages().booleanValue()) {
                this.buildGlobalResponseMessage(swaggerProperties, docket);
            }
            Docket docket2 = docket.select().apis(RequestHandlerSelectors.basePackage((String)swaggerProperties.getBasePackage())).paths(Predicates.and((Predicate)Predicates.not((Predicate)Predicates.or(excludePath)), (Predicate)Predicates.or(basePath))).build();
            Class[] array = new Class[swaggerProperties.getIgnoredParameterTypes().size()];
            Class[] classArray = swaggerProperties.getIgnoredParameterTypes().toArray(array);
            docket2.ignoredParameterTypes(classArray);
            configurableBeanFactory.registerSingleton("defaultDocket", (Object)docket2);
            docketList.add(docket2);
            return docketList;
        }
        for (String groupName : swaggerProperties.getDocket().keySet()) {
            SwaggerProperties.DocketInfo docketInfo = swaggerProperties.getDocket().get(groupName);
            ApiInfo apiInfo = new ApiInfoBuilder().title(docketInfo.getTitle().isEmpty() ? swaggerProperties.getTitle() : docketInfo.getTitle()).description(docketInfo.getDescription().isEmpty() ? swaggerProperties.getDescription() : docketInfo.getDescription()).version(docketInfo.getVersion().isEmpty() ? swaggerProperties.getVersion() : docketInfo.getVersion()).license(docketInfo.getLicense().isEmpty() ? swaggerProperties.getLicense() : docketInfo.getLicense()).licenseUrl(docketInfo.getLicenseUrl().isEmpty() ? swaggerProperties.getLicenseUrl() : docketInfo.getLicenseUrl()).contact(new Contact(docketInfo.getContact().getName().isEmpty() ? swaggerProperties.getContact().getName() : docketInfo.getContact().getName(), docketInfo.getContact().getUrl().isEmpty() ? swaggerProperties.getContact().getUrl() : docketInfo.getContact().getUrl(), docketInfo.getContact().getEmail().isEmpty() ? swaggerProperties.getContact().getEmail() : docketInfo.getContact().getEmail())).termsOfServiceUrl(docketInfo.getTermsOfServiceUrl().isEmpty() ? swaggerProperties.getTermsOfServiceUrl() : docketInfo.getTermsOfServiceUrl()).build();
            if (docketInfo.getBasePath().isEmpty()) {
                docketInfo.getBasePath().add("/**");
            }
            ArrayList<Predicate> basePath = new ArrayList<Predicate>();
            for (String string : docketInfo.getBasePath()) {
                basePath.add(PathSelectors.ant((String)string));
            }
            ArrayList<Predicate> excludePath = new ArrayList<Predicate>();
            for (String path3 : docketInfo.getExcludePath()) {
                excludePath.add(PathSelectors.ant((String)path3));
            }
            Docket docket = new Docket(DocumentationType.SWAGGER_2).host(swaggerProperties.getHost()).apiInfo(apiInfo).securitySchemes(Collections.singletonList(this.apiKey())).securityContexts(Collections.singletonList(this.securityContext())).globalOperationParameters(this.assemblyGlobalOperationParameters(swaggerProperties.getGlobalOperationParameters(), docketInfo.getGlobalOperationParameters()));
            if (!swaggerProperties.getApplyDefaultResponseMessages().booleanValue()) {
                this.buildGlobalResponseMessage(swaggerProperties, docket);
            }
            Docket docket3 = docket.groupName(groupName).select().apis(RequestHandlerSelectors.basePackage((String)docketInfo.getBasePackage())).paths(Predicates.and((Predicate)Predicates.not((Predicate)Predicates.or(excludePath)), (Predicate)Predicates.or(basePath))).build();
            Class[] array = new Class[docketInfo.getIgnoredParameterTypes().size()];
            Class[] ignoredParameterTypes = docketInfo.getIgnoredParameterTypes().toArray(array);
            docket3.ignoredParameterTypes(ignoredParameterTypes);
            configurableBeanFactory.registerSingleton(groupName, (Object)docket3);
            docketList.add(docket3);
        }
        return docketList;
    }

    private ApiKey apiKey() {
        return new ApiKey(this.swaggerProperties().getAuthorization().getName(), this.swaggerProperties().getAuthorization().getKeyName(), ApiKeyVehicle.HEADER.getValue());
    }

    private SecurityContext securityContext() {
        return SecurityContext.builder().securityReferences(this.defaultAuth()).forPaths(PathSelectors.regex((String)this.swaggerProperties().getAuthorization().getAuthRegex())).build();
    }

    private List<SecurityReference> defaultAuth() {
        AuthorizationScope authorizationScope = new AuthorizationScope("global", "accessEverything");
        AuthorizationScope[] authorizationScopes = new AuthorizationScope[]{authorizationScope};
        return Collections.singletonList(SecurityReference.builder().reference(this.swaggerProperties().getAuthorization().getName()).scopes(authorizationScopes).build());
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    private List<Parameter> buildGlobalOperationParametersFromSwaggerProperties(List<SwaggerProperties.GlobalOperationParameter> globalOperationParameters) {
        ArrayList parameters = Lists.newArrayList();
        if (Objects.isNull(globalOperationParameters)) {
            return parameters;
        }
        for (SwaggerProperties.GlobalOperationParameter globalOperationParameter : globalOperationParameters) {
            parameters.add(new ParameterBuilder().name(globalOperationParameter.getName()).description(globalOperationParameter.getDescription()).modelRef((ModelReference)new ModelRef(globalOperationParameter.getModelRef())).parameterType(globalOperationParameter.getParameterType()).required(Boolean.parseBoolean(globalOperationParameter.getRequired())).build());
        }
        return parameters;
    }

    private List<Parameter> assemblyGlobalOperationParameters(List<SwaggerProperties.GlobalOperationParameter> globalOperationParameters, List<SwaggerProperties.GlobalOperationParameter> docketOperationParameters) {
        if (Objects.isNull(docketOperationParameters) || docketOperationParameters.isEmpty()) {
            return this.buildGlobalOperationParametersFromSwaggerProperties(globalOperationParameters);
        }
        Set docketNames = docketOperationParameters.stream().map(SwaggerProperties.GlobalOperationParameter::getName).collect(Collectors.toSet());
        ArrayList resultOperationParameters = Lists.newArrayList();
        if (Objects.nonNull(globalOperationParameters)) {
            for (SwaggerProperties.GlobalOperationParameter parameter : globalOperationParameters) {
                if (docketNames.contains(parameter.getName())) continue;
                resultOperationParameters.add(parameter);
            }
        }
        resultOperationParameters.addAll(docketOperationParameters);
        return this.buildGlobalOperationParametersFromSwaggerProperties(resultOperationParameters);
    }

    private void buildGlobalResponseMessage(SwaggerProperties swaggerProperties, Docket docketForBuilder) {
        SwaggerProperties.GlobalResponseMessage globalResponseMessages = swaggerProperties.getGlobalResponseMessage();
        List<ResponseMessage> postResponseMessages = this.getResponseMessageList(globalResponseMessages.getPost());
        List<ResponseMessage> getResponseMessages = this.getResponseMessageList(globalResponseMessages.getGet());
        List<ResponseMessage> putResponseMessages = this.getResponseMessageList(globalResponseMessages.getPut());
        List<ResponseMessage> patchResponseMessages = this.getResponseMessageList(globalResponseMessages.getPatch());
        List<ResponseMessage> deleteResponseMessages = this.getResponseMessageList(globalResponseMessages.getDelete());
        List<ResponseMessage> headResponseMessages = this.getResponseMessageList(globalResponseMessages.getHead());
        List<ResponseMessage> optionsResponseMessages = this.getResponseMessageList(globalResponseMessages.getOptions());
        List<ResponseMessage> trackResponseMessages = this.getResponseMessageList(globalResponseMessages.getTrace());
        docketForBuilder.useDefaultResponseMessages(swaggerProperties.getApplyDefaultResponseMessages().booleanValue()).globalResponseMessage(RequestMethod.POST, postResponseMessages).globalResponseMessage(RequestMethod.GET, getResponseMessages).globalResponseMessage(RequestMethod.PUT, putResponseMessages).globalResponseMessage(RequestMethod.PATCH, patchResponseMessages).globalResponseMessage(RequestMethod.DELETE, deleteResponseMessages).globalResponseMessage(RequestMethod.HEAD, headResponseMessages).globalResponseMessage(RequestMethod.OPTIONS, optionsResponseMessages).globalResponseMessage(RequestMethod.TRACE, trackResponseMessages);
    }

    private List<ResponseMessage> getResponseMessageList(List<SwaggerProperties.GlobalResponseMessageBody> globalResponseMessageBodyList) {
        ArrayList<ResponseMessage> responseMessages = new ArrayList<ResponseMessage>();
        for (SwaggerProperties.GlobalResponseMessageBody globalResponseMessageBody : globalResponseMessageBodyList) {
            ResponseMessageBuilder responseMessageBuilder = new ResponseMessageBuilder();
            responseMessageBuilder.code(globalResponseMessageBody.getCode()).message(globalResponseMessageBody.getMessage());
            if (!StringUtils.isEmpty((Object)globalResponseMessageBody.getModelRef())) {
                responseMessageBuilder.responseModel((ModelReference)new ModelRef(globalResponseMessageBody.getModelRef()));
            }
            responseMessages.add(responseMessageBuilder.build());
        }
        return responseMessages;
    }
}

