/*
 * Decompiled with CFR 0.152.
 */
package com.springml.salesforce.wave.impl;

import com.sforce.soap.partner.PartnerConnection;
import com.springml.salesforce.wave.api.BulkAPI;
import com.springml.salesforce.wave.impl.AbstractAPIImpl;
import com.springml.salesforce.wave.model.BatchInfo;
import com.springml.salesforce.wave.model.BatchInfoList;
import com.springml.salesforce.wave.model.BatchResultList;
import com.springml.salesforce.wave.model.JobInfo;
import com.springml.salesforce.wave.util.LRUCache;
import com.springml.salesforce.wave.util.SFConfig;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BulkAPIImpl
extends AbstractAPIImpl
implements BulkAPI {
    private static final Logger LOG = Logger.getLogger(BulkAPIImpl.class);
    private Map<String, String> jobContentTypeMap = new LRUCache<String, String>(100);

    public BulkAPIImpl(SFConfig sfConfig) throws Exception {
        super(sfConfig);
    }

    @Override
    public JobInfo createJob(String object) throws Exception {
        JobInfo jobInfo = new JobInfo("CSV", object, "update");
        return this.createJob(jobInfo);
    }

    @Override
    public JobInfo createJob(String object, String operation, String contentType) throws Exception {
        JobInfo jobInfo = new JobInfo(contentType, object, operation);
        return this.createJob(jobInfo);
    }

    @Override
    public JobInfo createJob(JobInfo jobInfo) throws Exception {
        return this.createJob(jobInfo, new ArrayList<Header>());
    }

    @Override
    public JobInfo createJob(JobInfo jobInfo, List<Header> customHeaders) throws Exception {
        PartnerConnection connection = this.getSfConfig().getPartnerConnection();
        URI requestURI = this.getSfConfig().getRequestURI(connection, this.getJobPath());
        String response = this.getHttpHelper().post(requestURI, this.getSfConfig().getSessionId(), this.getObjectMapper().writeValueAsString((Object)jobInfo), true, customHeaders);
        LOG.debug((Object)("Response from Salesforce Server " + response));
        JobInfo respJobInfo = (JobInfo)this.getObjectMapper().readValue(response.getBytes(), JobInfo.class);
        this.jobContentTypeMap.put(respJobInfo.getId(), this.getRespectiveCntType(jobInfo));
        return respJobInfo;
    }

    @Override
    public BatchInfo addBatch(String jobId, String csvContent) throws Exception {
        PartnerConnection connection = this.getSfConfig().getPartnerConnection();
        URI requestURI = this.getSfConfig().getRequestURI(connection, this.getBatchPath(jobId));
        String contentType = this.getContentType(jobId);
        String response = this.getHttpHelper().post(requestURI, this.getSfConfig().getSessionId(), csvContent, contentType, true);
        LOG.debug((Object)("Response from Salesforce Server " + response));
        if ("application/json".equals(contentType)) {
            return (BatchInfo)this.getObjectMapper().readValue(response.getBytes(), BatchInfo.class);
        }
        return (BatchInfo)this.getXmlMapper().readValue(response.getBytes(), BatchInfo.class);
    }

    @Override
    public JobInfo closeJob(String jobId) throws Exception {
        PartnerConnection connection = this.getSfConfig().getPartnerConnection();
        URI requestURI = this.getSfConfig().getRequestURI(connection, this.getJobPath(jobId));
        JobInfo jobInfo = new JobInfo("Closed");
        String response = this.getHttpHelper().post(requestURI, this.getSfConfig().getSessionId(), this.getObjectMapper().writeValueAsString((Object)jobInfo), true);
        LOG.debug((Object)("Response from Salesforce Server " + response));
        return (JobInfo)this.getObjectMapper().readValue(response.getBytes(), JobInfo.class);
    }

    @Override
    public boolean isCompleted(String jobId) throws Exception {
        BatchInfoList batchInfoList = this.getBatchInfoList(jobId);
        List<BatchInfo> batchInfos = batchInfoList.getBatchInfo();
        LOG.debug((Object)("BatchInfos : " + batchInfos));
        if (batchInfos != null) {
            for (BatchInfo batchInfo : batchInfos) {
                LOG.debug((Object)("Batch state : " + batchInfo.getState()));
                if ("Failed".equals(batchInfo.getState())) {
                    throw new Exception("Batch '" + batchInfo.getId() + "' failed with error '" + batchInfo.getStateMessage() + "'");
                }
                if ("InProgress".equals(batchInfo.getState()) || "Queued".equals(batchInfo.getState())) {
                    return false;
                }
                LOG.info((Object)("Number of records failed : " + batchInfo.getNumberRecordsFailed()));
                if (batchInfo.getNumberRecordsFailed() <= 0L) continue;
                String result = this.getResult(jobId, batchInfo.getId());
                LOG.error((Object)("Failed record details \n " + result));
                throw new Exception("Batch '" + batchInfo.getId() + "' failed. Number of failed records is " + batchInfo.getNumberRecordsFailed());
            }
        }
        return true;
    }

    private String getResult(String jobId, String batchId) throws Exception {
        PartnerConnection connection = this.getSfConfig().getPartnerConnection();
        URI requestURI = this.getSfConfig().getRequestURI(connection, this.getBatchResultPath(jobId, batchId));
        return this.getHttpHelper().get(requestURI, this.getSfConfig().getSessionId(), true);
    }

    @Override
    public BatchInfoList getBatchInfoList(String jobId) throws Exception {
        PartnerConnection connection = this.getSfConfig().getPartnerConnection();
        URI requestURI = this.getSfConfig().getRequestURI(connection, this.getBatchPath(jobId));
        String response = this.getHttpHelper().get(requestURI, this.getSfConfig().getSessionId(), true);
        LOG.debug((Object)("Response from Salesforce Server " + response));
        if ("application/json".equals(this.getContentType(jobId))) {
            return (BatchInfoList)this.getObjectMapper().readValue(response.getBytes(), BatchInfoList.class);
        }
        return (BatchInfoList)this.getXmlMapper().readValue(response.getBytes(), BatchInfoList.class);
    }

    @Override
    public BatchInfo getBatchInfo(String jobId, String batchId) throws Exception {
        PartnerConnection connection = this.getSfConfig().getPartnerConnection();
        URI requestURI = this.getSfConfig().getRequestURI(connection, this.getBatchPath(jobId, batchId));
        String response = this.getHttpHelper().get(requestURI, this.getSfConfig().getSessionId(), true);
        LOG.debug((Object)("Response from Salesforce Server " + response));
        return (BatchInfo)this.getXmlMapper().readValue(response.getBytes(), BatchInfo.class);
    }

    @Override
    public List<String> getBatchResultIds(String jobId, String batchId) throws Exception {
        String response = this.getResult(jobId, batchId);
        if ("application/json".equals(this.getContentType(jobId))) {
            if (response != null && response.startsWith("[") && response.endsWith("]")) {
                return Arrays.asList(response.substring(1, response.length() - 1).split(","));
            }
            throw new Exception("Unable to parse response: " + response);
        }
        return ((BatchResultList)this.getXmlMapper().readValue(response.getBytes(), BatchResultList.class)).getBatchResultIds();
    }

    @Override
    public String getBatchResult(String jobId, String batchId, String resultId) throws Exception {
        PartnerConnection connection = this.getSfConfig().getPartnerConnection();
        URI requestURI = this.getSfConfig().getRequestURI(connection, this.getBatchResultPath(jobId, batchId, resultId));
        String response = this.getHttpHelper().get(requestURI, this.getSfConfig().getSessionId(), true);
        LOG.debug((Object)("Response from Salesforce Server " + response));
        return response;
    }

    @Override
    public boolean isSuccess(String jobId) throws Exception {
        return false;
    }

    private String getContentType(String jobId) {
        String contentType = this.jobContentTypeMap.get(jobId);
        if (StringUtils.isEmpty((CharSequence)contentType)) {
            contentType = "text/csv";
        }
        return contentType;
    }

    private String getRespectiveCntType(JobInfo jobInfo) {
        String contentType = null;
        contentType = "JSON".equals(jobInfo.getContentType()) ? "application/json" : ("XML".equals(jobInfo.getContentType()) ? "application/xml" : "text/csv");
        return contentType;
    }

    private String getBatchPath(String jobId, String batchId) {
        StringBuilder batchPath = new StringBuilder();
        batchPath.append(this.getBatchPath(jobId));
        batchPath.append('/');
        batchPath.append(batchId);
        return batchPath.toString();
    }

    private String getBatchResultPath(String jobId, String batchId) {
        StringBuilder batchResultPath = new StringBuilder();
        batchResultPath.append(this.getBatchPath(jobId, batchId));
        batchResultPath.append("/result");
        return batchResultPath.toString();
    }

    private String getBatchResultPath(String jobId, String batchId, String resultId) {
        StringBuilder batchResultPath = new StringBuilder();
        batchResultPath.append(this.getBatchResultPath(jobId, batchId));
        batchResultPath.append('/');
        batchResultPath.append(resultId);
        return batchResultPath.toString();
    }

    private String getBatchPath(String jobId) {
        StringBuilder batchPath = new StringBuilder();
        batchPath.append(this.getJobPath(jobId));
        batchPath.append("/batch");
        return batchPath.toString();
    }

    private String getJobPath(String jobId) {
        StringBuilder jobPath = new StringBuilder();
        jobPath.append(this.getJobPath());
        jobPath.append('/');
        jobPath.append(jobId);
        return jobPath.toString();
    }

    private String getJobPath() {
        StringBuilder jobPath = new StringBuilder();
        jobPath.append("/services/async/");
        jobPath.append(this.getSfConfig().getApiVersion());
        jobPath.append("/job");
        return jobPath.toString();
    }
}

