/*
 * Decompiled with CFR 0.152.
 */
package com.springml.salesforce.wave.impl;

import com.springml.salesforce.wave.api.ChatterAPI;
import com.springml.salesforce.wave.impl.AbstractAPIImpl;
import com.springml.salesforce.wave.model.PostMessageRequest;
import com.springml.salesforce.wave.model.chatter.MessageBody;
import com.springml.salesforce.wave.model.chatter.MessageElement;
import com.springml.salesforce.wave.model.chatter.PostMessageResponse;
import com.springml.salesforce.wave.util.SFConfig;
import java.net.URI;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class ChatterAPIImpl
extends AbstractAPIImpl
implements ChatterAPI {
    private static final Logger LOG = Logger.getLogger(ChatterAPIImpl.class);

    public ChatterAPIImpl(SFConfig sfConfig) throws Exception {
        super(sfConfig);
    }

    public PostMessageResponse postMessage(PostMessageRequest request) throws Exception {
        SFConfig sfConfig = this.getSfConfig();
        String feddElementsPath = this.getFeedElementsPath(sfConfig);
        URI taskURI = sfConfig.getRequestURI(sfConfig.getPartnerConnection(), feddElementsPath);
        String requestStr = this.getObjectMapper().writeValueAsString((Object)request);
        System.out.println("requestStr : " + requestStr);
        LOG.debug((Object)("Post Message Request " + requestStr));
        String responseStr = this.getHttpHelper().post(taskURI, this.getSfConfig().getSessionId(), requestStr);
        return (PostMessageResponse)this.getObjectMapper().readValue(responseStr.getBytes(), PostMessageResponse.class);
    }

    public PostMessageResponse postMessage(String subjectId, String text, String feedElementType) throws Exception {
        PostMessageRequest req = new PostMessageRequest();
        req.setSubjectId(subjectId);
        req.setFeedElementType(feedElementType);
        MessageBody postMsgBody = new MessageBody();
        MessageElement messageElement = new MessageElement();
        messageElement.setText(text);
        messageElement.setType("Text");
        postMsgBody.setMessageSegments(Arrays.asList(messageElement));
        req.setBody(postMsgBody);
        return this.postMessage(req);
    }

    private String getFeedElementsPath(SFConfig sfConfig) {
        StringBuilder feedElementsPath = new StringBuilder();
        feedElementsPath.append(this.getChatterPath(sfConfig));
        feedElementsPath.append("/feed-elements");
        return feedElementsPath.toString();
    }

    private String getChatterPath(SFConfig sfConfig) {
        StringBuilder chatterPath = new StringBuilder();
        chatterPath.append("/services/data/");
        chatterPath.append("v");
        chatterPath.append(sfConfig.getApiVersion());
        chatterPath.append("/chatter");
        return chatterPath.toString();
    }
}

