/*
 * Decompiled with CFR 0.152.
 */
package com.springml.salesforce.wave.impl;

import com.springml.salesforce.wave.api.ForceAPI;
import com.springml.salesforce.wave.impl.AbstractAPIImpl;
import com.springml.salesforce.wave.model.AddTaskRequest;
import com.springml.salesforce.wave.model.AddTaskResponse;
import com.springml.salesforce.wave.model.DescribeSObjectResult;
import com.springml.salesforce.wave.model.ForceResponse;
import com.springml.salesforce.wave.model.SOQLResult;
import com.springml.salesforce.wave.util.SFConfig;
import java.io.IOException;
import java.net.URI;
import org.apache.log4j.Logger;

public class ForceAPIImpl
extends AbstractAPIImpl
implements ForceAPI {
    private static final Logger LOG = Logger.getLogger(ForceAPIImpl.class);

    public ForceAPIImpl(SFConfig sfConfig) throws Exception {
        super(sfConfig);
    }

    public SOQLResult query(String soql) throws Exception {
        return this.query(soql, false);
    }

    public SOQLResult query(String soql, boolean all) throws Exception {
        StringBuilder queryParam = new StringBuilder();
        queryParam.append("q=");
        queryParam.append(soql);
        SFConfig sfConfig = this.getSfConfig();
        String queryPath = this.getQueryPath(sfConfig, all);
        URI queryURI = this.getSfConfig().getRequestURI(this.getSfConfig().getPartnerConnection(), queryPath, queryParam.toString());
        return this.query(queryURI, 1);
    }

    public SOQLResult queryMore(SOQLResult soqlResult) throws Exception {
        if (soqlResult.isDone()) {
            throw new Exception("Already all records are read");
        }
        URI requestURI = this.getSfConfig().getRequestURI(this.getSfConfig().getPartnerConnection(), soqlResult.getNextRecordsUrl());
        return this.query(requestURI, 1);
    }

    public AddTaskResponse addTask(AddTaskRequest addTask) throws Exception {
        SFConfig sfConfig = this.getSfConfig();
        String taskPath = this.getTaskPath(sfConfig);
        URI taskURI = sfConfig.getRequestURI(sfConfig.getPartnerConnection(), taskPath);
        String request = this.getObjectMapper().writeValueAsString((Object)addTask);
        String responseStr = this.getHttpHelper().post(taskURI, this.getSfConfig().getSessionId(), request);
        AddTaskResponse response = null;
        try {
            response = (AddTaskResponse)this.getObjectMapper().readValue(responseStr.getBytes(), AddTaskResponse.class);
        }
        catch (IOException e) {
            response = new AddTaskResponse();
            response.setError(responseStr);
            response.setSuccess(false);
        }
        return response;
    }

    public ForceResponse insertObject(String object, String jsonContent) throws Exception {
        SFConfig sfConfig = this.getSfConfig();
        String insertPath = this.getInsertPath(sfConfig, object);
        URI taskURI = sfConfig.getRequestURI(sfConfig.getPartnerConnection(), insertPath);
        String responseStr = this.getHttpHelper().post(taskURI, this.getSfConfig().getSessionId(), jsonContent);
        ForceResponse response = null;
        try {
            response = (ForceResponse)this.getObjectMapper().readValue(responseStr.getBytes(), ForceResponse.class);
        }
        catch (IOException e) {
            response = new ForceResponse();
            response.setError(responseStr);
            response.setSuccess(false);
        }
        return response;
    }

    public String getSFEndpoint() throws Exception {
        URI seURI = new URI(this.getSfConfig().getPartnerConnection().getConfig().getServiceEndpoint());
        return new URI(seURI.getScheme(), seURI.getUserInfo(), seURI.getHost(), seURI.getPort(), null, null, null).toString();
    }

    public DescribeSObjectResult describeSalesforceObject(String object) throws Exception {
        SFConfig sfConfig = this.getSfConfig();
        String objDescribePath = this.getSalesforceObjectDescribePath(sfConfig, object);
        URI objDescribeURI = sfConfig.getRequestURI(sfConfig.getPartnerConnection(), objDescribePath);
        String responseStr = this.getHttpHelper().get(objDescribeURI, sfConfig.getSessionId());
        DescribeSObjectResult response = null;
        try {
            response = (DescribeSObjectResult)this.getObjectMapper().readValue(responseStr.getBytes(), DescribeSObjectResult.class);
        }
        catch (IOException e) {
            response = new DescribeSObjectResult();
            response.setError(responseStr);
        }
        return response;
    }

    private String getInsertPath(SFConfig sfConfig, String object) {
        StringBuilder objPath = new StringBuilder();
        objPath.append("/services/data/");
        objPath.append("v");
        objPath.append(sfConfig.getApiVersion());
        objPath.append("/sobjects/");
        objPath.append(object);
        return objPath.toString();
    }

    private String getTaskPath(SFConfig sfConfig) {
        StringBuilder taskPath = new StringBuilder();
        taskPath.append("/services/data/");
        taskPath.append("v");
        taskPath.append(sfConfig.getApiVersion());
        taskPath.append("/sobjects/task");
        return taskPath.toString();
    }

    private SOQLResult query(URI queryURI, int attempt) throws Exception {
        SOQLResult soqlResult = null;
        try {
            String response = this.getHttpHelper().get(queryURI, this.getSfConfig().getSessionId(this.getSfConfig().getPartnerConnection()), this.getSfConfig().getBatchSize());
            LOG.debug((Object)("Query Response from server " + response));
            soqlResult = (SOQLResult)this.getObjectMapper().readValue(response.getBytes(), SOQLResult.class);
        }
        catch (Exception e) {
            LOG.warn((Object)"Error while executing salesforce query ", (Throwable)e);
            if (e.getMessage().contains("QUERY_TIMEOUT") && attempt < 5) {
                LOG.info((Object)"Retrying salesforce query");
                LOG.info((Object)("Retry attempt " + attempt));
                soqlResult = this.query(queryURI, ++attempt);
            }
            if (e.getMessage().contains("INVALID_SESSION_ID") && attempt < 5) {
                this.getSfConfig().closeConnection();
                LOG.info((Object)"Retrying with new connection...");
                soqlResult = this.query(queryURI, ++attempt);
            }
            throw e;
        }
        return soqlResult;
    }

    private String getQueryPath(SFConfig sfConfig, boolean all) {
        StringBuilder queryPath = new StringBuilder();
        queryPath.append("/services/data/");
        queryPath.append("v");
        queryPath.append(sfConfig.getApiVersion());
        if (all) {
            queryPath.append("/queryAll");
        } else {
            queryPath.append("/query");
        }
        return queryPath.toString();
    }

    private String getSalesforceObjectDescribePath(SFConfig sfConfig, String object) {
        StringBuilder objDescribePath = new StringBuilder();
        objDescribePath.append(this.getInsertPath(sfConfig, object));
        objDescribePath.append("/describe");
        return objDescribePath.toString();
    }
}

