/*
 * Decompiled with CFR 0.152.
 */
package com.springml.salesforce.wave.impl;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.sforce.soap.partner.PartnerConnection;
import com.springml.salesforce.wave.api.WaveAPI;
import com.springml.salesforce.wave.impl.AbstractAPIImpl;
import com.springml.salesforce.wave.model.QueryResult;
import com.springml.salesforce.wave.model.dataset.Dataset;
import com.springml.salesforce.wave.model.dataset.DatasetsResponse;
import com.springml.salesforce.wave.util.SFConfig;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

@JsonIgnoreProperties
public class WaveAPIImpl
extends AbstractAPIImpl
implements WaveAPI {
    private static final Logger LOG = Logger.getLogger(WaveAPIImpl.class);

    public WaveAPIImpl(SFConfig sfConfig) throws Exception {
        super(sfConfig);
    }

    public QueryResult queryWithPagination(String saql, String resultVar, int pageSize) throws Exception {
        return this.queryWithPagination(saql, resultVar, pageSize, 0);
    }

    public QueryResult queryMore(QueryResult queryResult) throws Exception {
        if (queryResult.isDone()) {
            throw new Exception("Already all records are read");
        }
        return this.queryWithPagination(queryResult.getQuery(), queryResult.getResultVariable(), queryResult.getLimit(), queryResult.getOffset());
    }

    public QueryResult query(String saql) throws Exception {
        return this.query(saql, true);
    }

    public String getDatasetId(String datasetName) throws Exception {
        String datasetId = null;
        SFConfig sfConfig = this.getSfConfig();
        PartnerConnection connection = sfConfig.getPartnerConnection();
        StringBuilder queryParam = new StringBuilder();
        queryParam.append("q=");
        queryParam.append(datasetName);
        String datasetsQueryPath = this.getDatasetsQueryPath(sfConfig);
        URI queryURI = sfConfig.getRequestURI(connection, datasetsQueryPath, queryParam.toString());
        String response = this.getHttpHelper().get(queryURI, this.getSfConfig().getSessionId());
        DatasetsResponse datasetResponse = (DatasetsResponse)this.getObjectMapper().readValue(response.getBytes(), DatasetsResponse.class);
        List<Dataset> datasets = datasetResponse.getDatasets();
        for (Dataset dataset : datasets) {
            if (!datasetName.equals(dataset.getName())) continue;
            datasetId = dataset.getId() + "/" + dataset.getCurrentVersionId();
            break;
        }
        return datasetId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueryResult query(String saql, boolean closeConnection) throws Exception {
        QueryResult result;
        block13: {
            result = null;
            SFConfig sfConfig = this.getSfConfig();
            PartnerConnection connection = sfConfig.getPartnerConnection();
            try {
                HashMap<String, String> saqlMap = new HashMap<String, String>(4);
                LOG.info((Object)("Query to be executed : " + saql));
                saqlMap.put("query", saql);
                String request = this.getObjectMapper().writeValueAsString(saqlMap);
                String waveQueryPath = this.getWaveQueryPath(sfConfig);
                URI queryURI = sfConfig.getRequestURI(connection, waveQueryPath);
                String response = this.getHttpHelper().post(queryURI, this.getSfConfig().getSessionId(connection), request);
                LOG.debug((Object)("Query Response from server " + response));
                result = (QueryResult)this.getObjectMapper().readValue(response.getBytes(), QueryResult.class);
            }
            catch (Exception e) {
                LOG.warn((Object)"Error while executing salesforce query ", (Throwable)e);
                if (e.getMessage().contains("INVALID_SESSION_ID")) {
                    this.getSfConfig().closeConnection();
                    LOG.info((Object)"Retrying with new connection...");
                    result = this.query(saql, closeConnection);
                    break block13;
                }
                throw e;
            }
            finally {
                if (closeConnection) {
                    try {
                        this.closePartnerConnection();
                    }
                    catch (Exception e) {
                        LOG.warn((Object)"Error while closing PartnerConnection", (Throwable)e);
                    }
                }
            }
        }
        return result;
    }

    private QueryResult queryWithPagination(String saql, String resultVar, int limit, int offset) throws Exception {
        String paginatedSAQL = this.getPaginatedSAQLQuery(saql, resultVar, limit, offset);
        QueryResult queryResult = this.query(paginatedSAQL, false);
        if (queryResult.getResults().getRecords().size() < limit) {
            queryResult.setDone(true);
            this.closePartnerConnection();
        } else {
            queryResult.setQuery(saql);
            queryResult.setLimit(limit);
            queryResult.setOffset(limit + offset);
            queryResult.setResultVariable(resultVar);
            queryResult.setDone(false);
        }
        return queryResult;
    }

    private void closePartnerConnection() {
        try {
            this.getSfConfig().closeConnection();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error while closing PartnerConnection", (Throwable)e);
        }
    }

    private String getPaginatedSAQLQuery(String saql, String resultVar, int limit, int offset) throws Exception {
        if (saql.contains("limit") || saql.contains("offset")) {
            throw new Exception("Pagination can't be done for SAQL Query which contains limit|offset");
        }
        StringBuilder paginatedQuery = new StringBuilder();
        paginatedQuery.append(saql);
        paginatedQuery.append(this.getOffsetClause(resultVar, offset));
        paginatedQuery.append(this.getLimitClause(resultVar, limit));
        return paginatedQuery.toString();
    }

    private String getOffsetClause(String resultVar, int offset) {
        return this.getClause(" offset ", resultVar, offset);
    }

    private String getLimitClause(String resultVar, int limit) {
        return this.getClause(" limit ", resultVar, limit);
    }

    private String getClause(String clause, String resultVar, int limit) {
        StringBuilder limitClause = new StringBuilder();
        limitClause.append(resultVar);
        limitClause.append(" ");
        limitClause.append("=");
        limitClause.append(" ");
        limitClause.append(clause);
        limitClause.append(resultVar);
        limitClause.append(" ");
        limitClause.append(limit);
        limitClause.append(";");
        limitClause.append(" ");
        return limitClause.toString();
    }

    private String getWaveQueryPath(SFConfig sfConfig) {
        StringBuilder waveQueryPath = new StringBuilder();
        waveQueryPath.append("/services/data/");
        waveQueryPath.append("v");
        waveQueryPath.append(sfConfig.getApiVersion());
        waveQueryPath.append("/wave/query");
        return waveQueryPath.toString();
    }

    private String getDatasetsQueryPath(SFConfig sfConfig) {
        StringBuilder waveQueryPath = new StringBuilder();
        waveQueryPath.append("/services/data/");
        waveQueryPath.append("v");
        waveQueryPath.append(sfConfig.getApiVersion());
        waveQueryPath.append("/wave/datasets");
        return waveQueryPath.toString();
    }
}

