/*
 * Decompiled with CFR 0.152.
 */
package com.springml.salesforce.wave.util;

import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPHelper {
    private static final Logger LOG = Logger.getLogger(HTTPHelper.class);

    public String post(URI uri, String sessionId, String request) throws Exception {
        return this.post(uri, sessionId, request, "application/json", false);
    }

    public String post(URI uri, String sessionId, String request, boolean isBulk) throws Exception {
        return this.post(uri, sessionId, request, "application/json", isBulk);
    }

    public String post(URI uri, String sessionId, String request, boolean isBulk, List<Header> customHeaders) throws Exception {
        return this.post(uri, sessionId, request, "application/json", isBulk, customHeaders);
    }

    public String post(URI uri, String sessionId, String request, String contentType, boolean isBulk) throws Exception {
        return this.post(uri, sessionId, request, contentType, isBulk, new ArrayList<Header>());
    }

    public String post(URI uri, String sessionId, String request, String contentType, boolean isBulk, List<Header> customHeaders) throws Exception {
        LOG.info((Object)("Executing POST request on " + uri));
        LOG.debug((Object)("Sending request " + request));
        LOG.debug((Object)("Content-Type " + contentType));
        StringEntity entity = new StringEntity(request, "UTF-8");
        if (contentType != null) {
            entity.setContentType(contentType);
        } else {
            LOG.debug((Object)"As Content-Type is null application/json Content-Type is used");
            entity.setContentType("application/json");
        }
        HttpPost httpPost = new HttpPost(uri);
        httpPost.setEntity((HttpEntity)entity);
        httpPost.setConfig(HTTPHelper.getRequestConfig());
        for (Header customHeader : customHeaders) {
            httpPost.addHeader(customHeader);
        }
        if (isBulk) {
            httpPost.addHeader("X-SFDC-Session", sessionId);
        } else {
            httpPost.addHeader("Authorization", "OAuth " + sessionId);
        }
        return this.execute(uri, (HttpUriRequest)httpPost);
    }

    public String get(URI uri, String sessionId, Integer batchSize, boolean isBulk) throws Exception {
        LOG.info((Object)("Executing GET request on " + uri));
        HttpGet httpGet = new HttpGet(uri);
        httpGet.setConfig(HTTPHelper.getRequestConfig());
        if (isBulk) {
            httpGet.addHeader("X-SFDC-Session", sessionId);
        } else {
            httpGet.addHeader("Authorization", "OAuth " + sessionId);
            httpGet.addHeader("Accept", "application/json");
        }
        if (batchSize != null && batchSize != 0) {
            httpGet.addHeader("Sforce-Query-Options", "batchSize=" + batchSize);
        }
        return this.execute(uri, (HttpUriRequest)httpGet);
    }

    public String get(URI uri, String sessionId, Integer batchSize) throws Exception {
        return this.get(uri, sessionId, batchSize, false);
    }

    public String get(URI uri, String sessionId, boolean isBulk) throws Exception {
        return this.get(uri, sessionId, null, isBulk);
    }

    public String get(URI uri, String sessionId) throws Exception {
        return this.get(uri, sessionId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String execute(URI uri, HttpUriRequest httpReq) throws Exception {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        InputStream eis = null;
        try {
            CloseableHttpResponse response = httpClient.execute(httpReq);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200 && statusCode != 201) {
                String reasonPhrase = response.getStatusLine().getReasonPhrase();
                String errResponse = IOUtils.toString((InputStream)response.getEntity().getContent(), (String)"UTF-8");
                throw new Exception(String.format("Accessing %s failed. Status %d. Reason %s \n Error from server %s", uri, statusCode, reasonPhrase, errResponse));
            }
            HttpEntity responseEntity = response.getEntity();
            eis = responseEntity.getContent();
            String string = IOUtils.toString((InputStream)eis, (String)"UTF-8");
            return string;
        }
        finally {
            try {
                if (httpClient != null) {
                    httpClient.close();
                }
            }
            catch (Exception e) {
                LOG.debug((Object)"Error while closing HTTP Client", (Throwable)e);
            }
            try {
                if (eis != null) {
                    eis.close();
                }
            }
            catch (Exception e) {
                LOG.debug((Object)"Error while closing InputStream", (Throwable)e);
            }
        }
    }

    public static RequestConfig getRequestConfig() {
        int timeout = Integer.parseInt(System.getProperty("com.springml.socket.timeout", "600000"));
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(timeout).setConnectTimeout(timeout).setConnectionRequestTimeout(timeout).build();
        return requestConfig;
    }
}

