/*
 * Decompiled with CFR 0.152.
 */
package com.springml.salesforce.wave.impl;

import com.springml.salesforce.wave.api.ForceAPI;
import com.springml.salesforce.wave.impl.AbstractAPIImpl;
import com.springml.salesforce.wave.model.SOQLResult;
import com.springml.salesforce.wave.util.SFConfig;
import java.net.URI;
import org.apache.log4j.Logger;

public class ForceAPIImpl
extends AbstractAPIImpl
implements ForceAPI {
    private static final Logger LOG = Logger.getLogger(ForceAPIImpl.class);

    public ForceAPIImpl(SFConfig sfConfig) throws Exception {
        super(sfConfig);
    }

    public SOQLResult query(String soql) throws Exception {
        StringBuilder queryParam = new StringBuilder();
        queryParam.append("q=");
        queryParam.append(soql);
        SFConfig sfConfig = this.getSfConfig();
        String queryPath = this.getQueryPath(sfConfig);
        URI queryURI = this.getSfConfig().getRequestURI(this.getSfConfig().getPartnerConnection(), queryPath, queryParam.toString());
        return this.query(queryURI);
    }

    public SOQLResult queryMore(SOQLResult soqlResult) throws Exception {
        if (soqlResult.isDone()) {
            throw new Exception("Already all records are read");
        }
        URI requestURI = this.getSfConfig().getRequestURI(this.getSfConfig().getPartnerConnection(), soqlResult.getNextRecordsUrl());
        return this.query(requestURI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SOQLResult query(URI queryURI) throws Exception {
        SOQLResult soqlResult = null;
        try {
            String response = this.getHttpHelper().get(queryURI, this.getSfConfig().getSessionId(this.getSfConfig().getPartnerConnection()));
            LOG.debug((Object)("Query Response from server " + response));
            SOQLResult sOQLResult = soqlResult = (SOQLResult)this.getObjectMapper().readValue(response.getBytes(), SOQLResult.class);
            return sOQLResult;
        }
        finally {
            if (this.getSfConfig().getPartnerConnection() != null && soqlResult != null && soqlResult.isDone()) {
                try {
                    this.getSfConfig().getPartnerConnection().logout();
                }
                catch (Exception e) {
                    LOG.warn((Object)"Error while closing PartnerConnection", (Throwable)e);
                }
            }
        }
    }

    private String getQueryPath(SFConfig sfConfig) {
        StringBuilder queryPath = new StringBuilder();
        queryPath.append("/services/data/");
        queryPath.append("v");
        queryPath.append(sfConfig.getApiVersion());
        queryPath.append("/query");
        return queryPath.toString();
    }
}

