/*
 * Decompiled with CFR 0.152.
 */
package com.springml.salesforce.wave.impl;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.sforce.soap.partner.PartnerConnection;
import com.springml.salesforce.wave.api.WaveAPI;
import com.springml.salesforce.wave.impl.AbstractAPIImpl;
import com.springml.salesforce.wave.model.QueryResult;
import com.springml.salesforce.wave.util.SFConfig;
import java.net.URI;
import java.util.HashMap;
import org.apache.log4j.Logger;

@JsonIgnoreProperties
public class WaveAPIImpl
extends AbstractAPIImpl
implements WaveAPI {
    private static final Logger LOG = Logger.getLogger(WaveAPIImpl.class);

    public WaveAPIImpl(SFConfig sfConfig) throws Exception {
        super(sfConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryResult query(String saql) throws Exception {
        SFConfig sfConfig = this.getSfConfig();
        PartnerConnection connection = sfConfig.getPartnerConnection();
        try {
            HashMap<String, String> saqlMap = new HashMap<String, String>(4);
            saqlMap.put("query", saql);
            String request = this.getObjectMapper().writeValueAsString(saqlMap);
            String waveQueryPath = this.getWaveQueryPath(sfConfig);
            URI queryURI = sfConfig.getRequestURI(connection, waveQueryPath);
            String response = this.getHttpHelper().post(queryURI, this.getSfConfig().getSessionId(connection), request);
            LOG.debug((Object)("Query Response from server " + response));
            QueryResult queryResult = (QueryResult)this.getObjectMapper().readValue(response.getBytes(), QueryResult.class);
            return queryResult;
        }
        finally {
            if (connection != null) {
                try {
                    connection.logout();
                }
                catch (Exception e) {
                    LOG.warn((Object)"Error while closing PartnerConnection", (Throwable)e);
                }
            }
        }
    }

    private String getWaveQueryPath(SFConfig sfConfig) {
        StringBuilder waveQueryPath = new StringBuilder();
        waveQueryPath.append("/services/data/");
        waveQueryPath.append("v");
        waveQueryPath.append(sfConfig.getApiVersion());
        waveQueryPath.append("/wave/query");
        return waveQueryPath.toString();
    }
}

