/*
 * Decompiled with CFR 0.152.
 */
package com.springml.salesforce.wave.util;

import java.io.InputStream;
import java.net.URI;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.log4j.Logger;

public class HTTPHelper {
    private static final Logger LOG = Logger.getLogger(HTTPHelper.class);

    public String post(URI uri, String sessionId, String request) throws Exception {
        LOG.info((Object)("Executing POST request on " + uri));
        LOG.debug((Object)("Sending request " + request));
        StringEntity entity = new StringEntity(request, "UTF-8");
        entity.setContentType("application/json");
        HttpPost httpPost = new HttpPost(uri);
        httpPost.setEntity((HttpEntity)entity);
        httpPost.setConfig(HTTPHelper.getRequestConfig());
        httpPost.addHeader("Authorization", "OAuth " + sessionId);
        return this.execute(uri, (HttpUriRequest)httpPost);
    }

    public String get(URI uri, String sessionId) throws Exception {
        LOG.info((Object)("Executing GET request on " + uri));
        HttpGet httpGet = new HttpGet(uri);
        httpGet.setConfig(HTTPHelper.getRequestConfig());
        httpGet.addHeader("Authorization", "OAuth " + sessionId);
        httpGet.addHeader("Accept", "application/json");
        return this.execute(uri, (HttpUriRequest)httpGet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String execute(URI uri, HttpUriRequest httpReq) throws Exception {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        InputStream eis = null;
        try {
            CloseableHttpResponse response = httpClient.execute(httpReq);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200 && statusCode != 201) {
                String reasonPhrase = response.getStatusLine().getReasonPhrase();
                String errResponse = IOUtils.toString((InputStream)response.getEntity().getContent(), (String)"UTF-8");
                throw new Exception(String.format("Accessing %s failed. Status %d. Reason %s \n Error from server %s", uri, statusCode, reasonPhrase, errResponse));
            }
            HttpEntity responseEntity = response.getEntity();
            eis = responseEntity.getContent();
            String string = IOUtils.toString((InputStream)eis, (String)"UTF-8");
            return string;
        }
        finally {
            try {
                if (httpClient != null) {
                    httpClient.close();
                }
            }
            catch (Exception e) {
                LOG.debug((Object)"Error while closing HTTP Client", (Throwable)e);
            }
            try {
                if (eis != null) {
                    eis.close();
                }
            }
            catch (Exception e) {
                LOG.debug((Object)"Error while closing InputStream", (Throwable)e);
            }
        }
    }

    public static RequestConfig getRequestConfig() {
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(60000).setConnectTimeout(60000).setConnectionRequestTimeout(60000).build();
        return requestConfig;
    }
}

