/*
 * Decompiled with CFR 0.152.
 */
package com.springml.salesforce.wave.util;

import com.sforce.soap.partner.Connector;
import com.sforce.soap.partner.PartnerConnection;
import com.sforce.ws.ConnectionException;
import com.sforce.ws.ConnectorConfig;
import com.springml.salesforce.wave.util.HTTPHelper;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.log4j.Logger;

public class SFConfig {
    private static final Logger LOG = Logger.getLogger(HTTPHelper.class);
    private String username;
    private String password;
    private String loginURL;
    private String apiVersion;
    private PartnerConnection partnerConnection;

    public SFConfig(String username, String password, String loginURL, String apiVersion) {
        this.username = username;
        this.password = password;
        this.loginURL = loginURL;
        this.apiVersion = apiVersion;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getLoginURL() {
        return this.loginURL;
    }

    public void setLoginURL(String loginURL) {
        this.loginURL = loginURL;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public PartnerConnection getPartnerConnection() throws Exception {
        if (this.partnerConnection == null) {
            this.partnerConnection = this.createPartnerConnection();
        }
        return this.partnerConnection;
    }

    private PartnerConnection createPartnerConnection() throws Exception {
        ConnectorConfig config = new ConnectorConfig();
        LOG.debug((Object)("Connecting SF Partner Connection using " + this.username));
        config.setUsername(this.username);
        config.setPassword(this.password);
        String authEndpoint = this.getAuthEndpoint(this.loginURL);
        LOG.info((Object)("loginURL : " + authEndpoint));
        config.setAuthEndpoint(authEndpoint);
        config.setServiceEndpoint(authEndpoint);
        try {
            return Connector.newConnection((ConnectorConfig)config);
        }
        catch (ConnectionException ce) {
            LOG.error((Object)"Exception while creating connection", (Throwable)ce);
            throw new Exception(ce);
        }
    }

    public String getSessionId(PartnerConnection connection) {
        return connection.getConfig().getSessionId();
    }

    public URI getRequestURI(PartnerConnection connection, String path) throws URISyntaxException {
        return this.getRequestURI(connection, path, null);
    }

    public URI getRequestURI(PartnerConnection connection, String path, String query) throws URISyntaxException {
        URI seURI = new URI(connection.getConfig().getServiceEndpoint());
        return new URI(seURI.getScheme(), seURI.getUserInfo(), seURI.getHost(), seURI.getPort(), path, query, null);
    }

    private String getAuthEndpoint(String loginURL) throws Exception {
        URI loginURI = new URI(loginURL);
        return new URI(loginURI.getScheme(), loginURI.getUserInfo(), loginURI.getHost(), loginURI.getPort(), "/services/Soap/u/35.0", null, null).toString();
    }
}

