/*
 * Decompiled with CFR 0.152.
 */
package com.springml.spark.sftp;

import com.springml.sftp.client.SFTPClient;
import com.springml.spark.sftp.DatasetRelation;
import com.springml.spark.sftp.DeleteTempFileShutdownHook;
import com.springml.spark.sftp.constants$;
import com.springml.spark.sftp.util.Utils$;
import java.io.File;
import java.util.UUID;
import org.apache.commons.io.FilenameUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.CreatableRelationProvider;
import org.apache.spark.sql.sources.RelationProvider;
import org.apache.spark.sql.sources.SchemaRelationProvider;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.runtime.Null$;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005h\u0001B\u0001\u0003\u0001-\u0011Q\u0002R3gCVdGoU8ve\u000e,'BA\u0002\u0005\u0003\u0011\u0019h\r\u001e9\u000b\u0005\u00151\u0011!B:qCJ\\'BA\u0004\t\u0003!\u0019\bO]5oO6d'\"A\u0005\u0002\u0007\r|Wn\u0001\u0001\u0014\u000b\u0001a!c\b\u0012\u0011\u00055\u0001R\"\u0001\b\u000b\u0003=\tQa]2bY\u0006L!!\u0005\b\u0003\r\u0005s\u0017PU3g!\t\u0019R$D\u0001\u0015\u0015\t)b#A\u0004t_V\u00148-Z:\u000b\u0005]A\u0012aA:rY*\u0011Q!\u0007\u0006\u00035m\ta!\u00199bG\",'\"\u0001\u000f\u0002\u0007=\u0014x-\u0003\u0002\u001f)\t\u0001\"+\u001a7bi&|g\u000e\u0015:pm&$WM\u001d\t\u0003'\u0001J!!\t\u000b\u0003-M\u001b\u0007.Z7b%\u0016d\u0017\r^5p]B\u0013xN^5eKJ\u0004\"aE\u0012\n\u0005\u0011\"\"!G\"sK\u0006$\u0018M\u00197f%\u0016d\u0017\r^5p]B\u0013xN^5eKJDQA\n\u0001\u0005\u0002\u001d\na\u0001P5oSRtD#\u0001\u0015\u0011\u0005%\u0002Q\"\u0001\u0002\t\u000f-\u0002!\u0019!C\u0001Y\u00051An\\4hKJ,\u0012!\f\t\u0003]Ej\u0011a\f\u0006\u0003ae\tQ\u0001\\8hi)L!AM\u0018\u0003\r1{wmZ3s\u0011\u0019!\u0004\u0001)A\u0005[\u00059An\\4hKJ\u0004\u0003FA\u001a7!\tiq'\u0003\u00029\u001d\tIAO]1og&,g\u000e\u001e\u0005\u0006u\u0001!\teO\u0001\u000fGJ,\u0017\r^3SK2\fG/[8o)\rat(\u0012\t\u0003'uJ!A\u0010\u000b\u0003\u0019\t\u000b7/\u001a*fY\u0006$\u0018n\u001c8\t\u000b\u0001K\u0004\u0019A!\u0002\u0015M\fHnQ8oi\u0016DH\u000f\u0005\u0002C\u00076\ta#\u0003\u0002E-\tQ1+\u0015'D_:$X\r\u001f;\t\u000b\u0019K\u0004\u0019A$\u0002\u0015A\f'/Y7fi\u0016\u00148\u000f\u0005\u0003I\u0017:seBA\u0007J\u0013\tQe\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u00196\u00131!T1q\u0015\tQe\u0002\u0005\u0002I\u001f&\u0011\u0001+\u0014\u0002\u0007'R\u0014\u0018N\\4\t\u000bi\u0002A\u0011\t*\u0015\tq\u001aF+\u0016\u0005\u0006\u0001F\u0003\r!\u0011\u0005\u0006\rF\u0003\ra\u0012\u0005\u0006-F\u0003\raV\u0001\u0007g\u000eDW-\\1\u0011\u0005a[V\"A-\u000b\u0005i3\u0012!\u0002;za\u0016\u001c\u0018B\u0001/Z\u0005)\u0019FO];diRK\b/\u001a\u0005\u0006u\u0001!\tE\u0018\u000b\u0006y}\u0003WM\u001a\u0005\u0006\u0001v\u0003\r!\u0011\u0005\u0006Cv\u0003\rAY\u0001\u0005[>$W\r\u0005\u0002CG&\u0011AM\u0006\u0002\t'\u00064X-T8eK\")a)\u0018a\u0001\u000f\")q-\u0018a\u0001Q\u0006!A-\u0019;b!\tIwO\u0004\u0002kk:\u00111\u000e\u001e\b\u0003YNt!!\u001c:\u000f\u00059\fX\"A8\u000b\u0005AT\u0011A\u0002\u001fs_>$h(C\u0001\u001d\u0013\tQ2$\u0003\u0002\u00063%\u0011q\u0003G\u0005\u0003mZ\tq\u0001]1dW\u0006<W-\u0003\u0002ys\nIA)\u0019;b\rJ\fW.\u001a\u0006\u0003mZAQa\u001f\u0001\u0005\nq\f!bY8qsR{\u0007\n\u001a4t)\u0015qUP`A\u0001\u0011\u0015\u0001%\u00101\u0001B\u0011\u0015y(\u00101\u0001O\u000311\u0017\u000e\\3M_\u000e\fG/[8o\u0011\u0019\t\u0019A\u001fa\u0001\u001d\u0006A\u0001\u000e\u001a4t)\u0016l\u0007\u000fC\u0004\u0002\b\u0001!I!!\u0003\u0002\u0019\r|\u0007/\u001f$s_6DEMZ:\u0015\u000f9\u000bY!!\u0004\u0002\u0010!1\u0001)!\u0002A\u0002\u0005Cq!a\u0001\u0002\u0006\u0001\u0007a\n\u0003\u0004\u0000\u0003\u000b\u0001\rA\u0014\u0005\b\u0003'\u0001A\u0011BA\u000b\u0003\u0019)\b\u000f\\8bIRA\u0011qCA\u000f\u0003C\t)\u0003E\u0002\u000e\u00033I1!a\u0007\u000f\u0005\u0011)f.\u001b;\t\u000f\u0005}\u0011\u0011\u0003a\u0001\u001d\u000611o\\;sG\u0016Dq!a\t\u0002\u0012\u0001\u0007a*\u0001\u0004uCJ<W\r\u001e\u0005\t\u0003O\t\t\u00021\u0001\u0002*\u0005Q1O\u001a;q\u00072LWM\u001c;\u0011\t\u0005-\u00121G\u0007\u0003\u0003[QA!a\f\u00022\u000511\r\\5f]RT!a\u0001\u0004\n\t\u0005U\u0012Q\u0006\u0002\u000b'\u001a#\u0006k\u00117jK:$\bbBA\u001d\u0001\u0011%\u00111H\u0001\u000eO\u0016$8K\u0012+Q\u00072LWM\u001c;\u0015%\u0005%\u0012QHA$\u0003\u0017\ny%a\u0015\u0002X\u0005m\u0013q\f\u0005\t\u0003\u007f\t9\u00041\u0001\u0002B\u0005AQo]3s]\u0006lW\r\u0005\u0003\u000e\u0003\u0007r\u0015bAA#\u001d\t1q\n\u001d;j_:D\u0001\"!\u0013\u00028\u0001\u0007\u0011\u0011I\u0001\ta\u0006\u001c8o^8sI\"A\u0011QJA\u001c\u0001\u0004\t\t%A\bqK64\u0015\u000e\\3M_\u000e\fG/[8o\u0011!\t\t&a\u000eA\u0002\u0005\u0005\u0013!\u00049f[B\u000b7o\u001d9ie\u0006\u001cX\rC\u0004\u0002V\u0005]\u0002\u0019\u0001(\u0002\t!|7\u000f\u001e\u0005\t\u00033\n9\u00041\u0001\u0002B\u0005!\u0001o\u001c:u\u0011\u001d\ti&a\u000eA\u00029\u000b\u0011b\u0019:zaR|7*Z=\t\u000f\u0005\u0005\u0014q\u0007a\u0001\u001d\u0006y1M]=qi>\fEnZ8sSRDW\u000eC\u0004\u0002f\u0001!I!a\u001a\u0002)\r\u0014X-\u0019;f%\u0016$XO\u001d8SK2\fG/[8o)\ra\u0014\u0011\u000e\u0005\u0007O\u0006\r\u0004\u0019\u00015\t\u000f\u0005\u0015\u0004\u0001\"\u0003\u0002nQ)A(a\u001c\u0002t!9\u0011\u0011OA6\u0001\u0004\t\u0015!D:rY\u000e{g\u000e^3yiZ\u000b'\u000fC\u0004\u0002v\u0005-\u0004\u0019A,\u0002\u0013M\u001c\u0007.Z7b-\u0006\u0014\bbBA=\u0001\u0011%\u00111P\u0001\u0005G>\u0004\u0018\u0010F\u0005O\u0003{\ny(!!\u0002\u0006\"A\u0011qEA<\u0001\u0004\tI\u0003C\u0004\u0002 \u0005]\u0004\u0019\u0001(\t\u000f\u0005\r\u0015q\u000fa\u0001\u001d\u0006QA/Z7q\r>dG-\u001a:\t\u0011\u0005\u001d\u0015q\u000fa\u0001\u0003\u0013\u000ba\u0001\\1uKN$\bcA\u0007\u0002\f&\u0019\u0011Q\u0012\b\u0003\u000f\t{w\u000e\\3b]\"9\u0011\u0011\u0013\u0001\u0005\n\u0005M\u0015\u0001C4fiZ\u000bG.^3\u0015\u00079\u000b)\n\u0003\u0005\u0002\u0018\u0006=\u0005\u0019AA!\u0003\u0015\u0001\u0018M]1n\u0011\u001d\tY\n\u0001C\u0005\u0003;\u000b1b\u001e:ji\u0016$v\u000eV3naRYb*a(\u0002\"\u0006\u0015\u0016qUAU\u0003[\u000b\t,!.\u0002:\u0006u\u0016\u0011YAc\u0003\u0013Da\u0001QAM\u0001\u0004\t\u0005bBAR\u00033\u0003\r\u0001[\u0001\u0003I\u001aDq!a\u0001\u0002\u001a\u0002\u0007a\nC\u0004\u0002\u0004\u0006e\u0005\u0019\u0001(\t\u000f\u0005-\u0016\u0011\u0014a\u0001\u001d\u0006Aa-\u001b7f)f\u0004X\rC\u0004\u00020\u0006e\u0005\u0019\u0001(\u0002\r!,\u0017\rZ3s\u0011\u001d\t\u0019,!'A\u00029\u000b\u0011\u0002Z3mS6LG/\u001a:\t\u000f\u0005]\u0016\u0011\u0014a\u0001\u001d\u0006)\u0011/^8uK\"9\u00111XAM\u0001\u0004q\u0015AB3tG\u0006\u0004X\rC\u0004\u0002@\u0006e\u0005\u0019\u0001(\u0002\u00135,H\u000e^5MS:,\u0007bBAb\u00033\u0003\rAT\u0001\u0006G>$Wm\u0019\u0005\b\u0003\u000f\fI\n1\u0001O\u0003\u0019\u0011xn\u001e+bO\"9\u00111ZAM\u0001\u0004q\u0015a\u0002:p_R$\u0016m\u001a\u0005\b\u0003\u001f\u0004A\u0011BAi\u0003=\tG\rZ*ikR$wn\u001e8I_>\\G\u0003BA\f\u0003'Dq!!6\u0002N\u0002\u0007a*\u0001\u0007uK6\u0004Hj\\2bi&|g\u000eC\u0004\u0002Z\u0002!I!a7\u0002\u0015\r|\u0007/[3e\r&dW\rF\u0002O\u0003;Dq!a8\u0002X\u0002\u0007a*\u0001\tuK6\u0004h)\u001b7f\u0019>\u001c\u0017\r^5p]\u0002")
public class DefaultSource
implements RelationProvider,
SchemaRelationProvider,
CreatableRelationProvider {
    private final transient Logger logger = Logger.getLogger(DefaultSource.class);

    public Logger logger() {
        return this.logger;
    }

    public BaseRelation createRelation(SQLContext sqlContext, Map<String, String> parameters) {
        return this.createRelation(sqlContext, parameters, null);
    }

    public BaseRelation createRelation(SQLContext sqlContext, Map<String, String> parameters, StructType schema) {
        Option username = parameters.get((Object)"username");
        Option password = parameters.get((Object)"password");
        Option pemFileLocation = parameters.get((Object)"pem");
        Option pemPassphrase = parameters.get((Object)"pemPassphrase");
        String host = (String)parameters.getOrElse((Object)"host", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                return package$.MODULE$.error("SFTP Host has to be provided using 'host' option");
            }
        });
        Option port = parameters.get((Object)"port");
        String path = (String)parameters.getOrElse((Object)"path", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                return package$.MODULE$.error("'path' must be specified");
            }
        });
        String fileType = (String)parameters.getOrElse((Object)"fileType", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                return package$.MODULE$.error("File type has to be provided using 'fileType' option");
            }
        });
        Option inferSchema = parameters.get((Object)"inferSchema");
        String header = (String)parameters.getOrElse((Object)"header", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "true";
            }
        });
        String delimiter = (String)parameters.getOrElse((Object)"delimiter", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return ",";
            }
        });
        String quote = (String)parameters.getOrElse((Object)"quote", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "\"";
            }
        });
        String escape = (String)parameters.getOrElse((Object)"escape", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "\\";
            }
        });
        String multiLine = (String)parameters.getOrElse((Object)"multiLine", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "false";
            }
        });
        String createDF = (String)parameters.getOrElse((Object)"createDF", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "true";
            }
        });
        String copyLatest = (String)parameters.getOrElse((Object)"copyLatest", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "false";
            }
        });
        String tempFolder = (String)parameters.getOrElse((Object)"tempLocation", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return System.getProperty("java.io.tmpdir");
            }
        });
        String hdfsTemp = (String)parameters.getOrElse((Object)"hdfsTempLocation", (Function0)new Serializable(this, tempFolder){
            public static final long serialVersionUID = 0L;
            private final String tempFolder$1;

            public final String apply() {
                return this.tempFolder$1;
            }
            {
                this.tempFolder$1 = tempFolder$1;
            }
        });
        String cryptoKey = (String)parameters.getOrElse((Object)"cryptoKey", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Null$ apply() {
                return null;
            }
        });
        String cryptoAlgorithm = (String)parameters.getOrElse((Object)"cryptoAlgorithm", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "AES";
            }
        });
        String rowTag = (String)parameters.getOrElse((Object)constants$.MODULE$.xmlRowTag(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Null$ apply() {
                return null;
            }
        });
        List supportedFileTypes = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"csv", "json", "avro", "parquet", "txt", "xml", "orc"}));
        if (supportedFileTypes.contains((Object)fileType)) {
            DatasetRelation datasetRelation;
            String inferSchemaFlag = inferSchema != null && inferSchema.isDefined() ? (String)inferSchema.get() : "false";
            SFTPClient sftpClient = this.getSFTPClient((Option<String>)username, (Option<String>)password, (Option<String>)pemFileLocation, (Option<String>)pemPassphrase, host, (Option<String>)port, cryptoKey, cryptoAlgorithm);
            String copiedFileLocation = this.copy(sftpClient, path, tempFolder, new StringOps(Predef$.MODULE$.augmentString(copyLatest)).toBoolean());
            String fileLocation = this.copyToHdfs(sqlContext, copiedFileLocation, hdfsTemp);
            if (new StringOps(Predef$.MODULE$.augmentString(createDF)).toBoolean()) {
                datasetRelation = new DatasetRelation(fileLocation, fileType, inferSchemaFlag, header, delimiter, quote, escape, multiLine, rowTag, schema, sqlContext);
            } else {
                this.logger().info((Object)"Returning an empty dataframe after copying files...");
                datasetRelation = this.createReturnRelation(sqlContext, schema);
            }
            return datasetRelation;
        }
        throw package$.MODULE$.error(new StringBuilder().append((Object)"fileType ").append((Object)fileType).append((Object)" not supported. Supported file types are ").append((Object)supportedFileTypes).toString());
    }

    public BaseRelation createRelation(SQLContext sqlContext, SaveMode mode, Map<String, String> parameters, Dataset<Row> data) {
        Option username = parameters.get((Object)"username");
        Option password = parameters.get((Object)"password");
        Option pemFileLocation = parameters.get((Object)"pem");
        Option pemPassphrase = parameters.get((Object)"pemPassphrase");
        String host = (String)parameters.getOrElse((Object)"host", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                return package$.MODULE$.error("SFTP Host has to be provided using 'host' option");
            }
        });
        Option port = parameters.get((Object)"port");
        String path = (String)parameters.getOrElse((Object)"path", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                return package$.MODULE$.error("'path' must be specified");
            }
        });
        String fileType = (String)parameters.getOrElse((Object)"fileType", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                return package$.MODULE$.error("File type has to be provided using 'fileType' option");
            }
        });
        String header = (String)parameters.getOrElse((Object)"header", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "true";
            }
        });
        String copyLatest = (String)parameters.getOrElse((Object)"copyLatest", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "false";
            }
        });
        String tmpFolder = (String)parameters.getOrElse((Object)"tempLocation", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return System.getProperty("java.io.tmpdir");
            }
        });
        String hdfsTemp = (String)parameters.getOrElse((Object)"hdfsTempLocation", (Function0)new Serializable(this, tmpFolder){
            public static final long serialVersionUID = 0L;
            private final String tmpFolder$1;

            public final String apply() {
                return this.tmpFolder$1;
            }
            {
                this.tmpFolder$1 = tmpFolder$1;
            }
        });
        String cryptoKey = (String)parameters.getOrElse((Object)"cryptoKey", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Null$ apply() {
                return null;
            }
        });
        String cryptoAlgorithm = (String)parameters.getOrElse((Object)"cryptoAlgorithm", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "AES";
            }
        });
        String delimiter = (String)parameters.getOrElse((Object)"delimiter", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return ",";
            }
        });
        String quote = (String)parameters.getOrElse((Object)"quote", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "\"";
            }
        });
        String escape = (String)parameters.getOrElse((Object)"escape", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "\\";
            }
        });
        String multiLine = (String)parameters.getOrElse((Object)"multiLine", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "false";
            }
        });
        String codec = (String)parameters.getOrElse((Object)"codec", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Null$ apply() {
                return null;
            }
        });
        String rowTag = (String)parameters.getOrElse((Object)constants$.MODULE$.xmlRowTag(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Null$ apply() {
                return null;
            }
        });
        String rootTag = (String)parameters.getOrElse((Object)constants$.MODULE$.xmlRootTag(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Null$ apply() {
                return null;
            }
        });
        List supportedFileTypes = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"csv", "json", "avro", "parquet", "txt", "xml", "orc"}));
        if (supportedFileTypes.contains((Object)fileType)) {
            SFTPClient sftpClient = this.getSFTPClient((Option<String>)username, (Option<String>)password, (Option<String>)pemFileLocation, (Option<String>)pemPassphrase, host, (Option<String>)port, cryptoKey, cryptoAlgorithm);
            String tempFile = this.writeToTemp(sqlContext, data, hdfsTemp, tmpFolder, fileType, header, delimiter, quote, escape, multiLine, codec, rowTag, rootTag);
            this.upload(tempFile, path, sftpClient);
            return this.createReturnRelation(data);
        }
        throw package$.MODULE$.error(new StringBuilder().append((Object)"fileType ").append((Object)fileType).append((Object)" not supported. Supported file types are ").append((Object)supportedFileTypes).toString());
    }

    private String copyToHdfs(SQLContext sqlContext, String fileLocation, String hdfsTemp) {
        Path hdfsPath = new Path(fileLocation);
        Configuration hadoopConf = sqlContext.sparkContext().hadoopConfiguration();
        FileSystem fs = hdfsPath.getFileSystem(hadoopConf);
        if ("hdfs".equalsIgnoreCase(fs.getScheme())) {
            fs.copyFromLocalFile(new Path(fileLocation), new Path(hdfsTemp));
            String filePath = new StringBuilder().append((Object)hdfsTemp).append((Object)"/").append((Object)hdfsPath.getName()).toString();
            fs.deleteOnExit(new Path(filePath));
            return filePath;
        }
        return fileLocation;
    }

    private String copyFromHdfs(SQLContext sqlContext, String hdfsTemp, String fileLocation) {
        Path hdfsPath = new Path(hdfsTemp);
        Configuration hadoopConf = sqlContext.sparkContext().hadoopConfiguration();
        FileSystem fs = hdfsPath.getFileSystem(hadoopConf);
        if ("hdfs".equalsIgnoreCase(fs.getScheme())) {
            fs.copyToLocalFile(new Path(hdfsTemp), new Path(fileLocation));
            fs.deleteOnExit(new Path(hdfsTemp));
            return fileLocation;
        }
        return hdfsTemp;
    }

    private void upload(String source, String target, SFTPClient sftpClient) {
        this.logger().info((Object)new StringBuilder().append((Object)"Copying ").append((Object)source).append((Object)" to ").append((Object)target).toString());
        sftpClient.copyToFTP(source, target);
    }

    private SFTPClient getSFTPClient(Option<String> username, Option<String> password, Option<String> pemFileLocation, Option<String> pemPassphrase, String host, Option<String> port, String cryptoKey, String cryptoAlgorithm) {
        int sftpPort = port != null && port.isDefined() ? new StringOps(Predef$.MODULE$.augmentString((String)port.get())).toInt() : 22;
        boolean cryptoEnabled = cryptoKey != null;
        return cryptoEnabled ? new SFTPClient(this.getValue(pemFileLocation), this.getValue(pemPassphrase), this.getValue(username), this.getValue(password), host, sftpPort, cryptoEnabled, cryptoKey, cryptoAlgorithm) : new SFTPClient(this.getValue(pemFileLocation), this.getValue(pemPassphrase), this.getValue(username), this.getValue(password), host, sftpPort);
    }

    private BaseRelation createReturnRelation(Dataset<Row> data) {
        return this.createReturnRelation(data.sqlContext(), data.schema());
    }

    private BaseRelation createReturnRelation(SQLContext sqlContextVar, StructType schemaVar) {
        return new BaseRelation(this, sqlContextVar, schemaVar){
            private final SQLContext sqlContextVar$1;
            private final StructType schemaVar$1;

            public SQLContext sqlContext() {
                return this.sqlContextVar$1;
            }

            public StructType schema() {
                return this.schemaVar$1;
            }
            {
                this.sqlContextVar$1 = sqlContextVar$1;
                this.schemaVar$1 = schemaVar$1;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private String copy(SFTPClient sftpClient, String source, String tempFolder, boolean latest) {
        String copiedFilePath = null;
        try {
            String target;
            copiedFilePath = target = new StringBuilder().append((Object)tempFolder).append((Object)File.separator).append((Object)FilenameUtils.getName((String)source)).toString();
            if (latest) {
                copiedFilePath = sftpClient.copyLatest(source, tempFolder);
            } else {
                this.logger().info((Object)new StringBuilder().append((Object)"Copying ").append((Object)source).append((Object)" to ").append((Object)target).toString());
                copiedFilePath = sftpClient.copy(source, target);
            }
            this.addShutdownHook(copiedFilePath);
            return copiedFilePath;
        }
        catch (Throwable throwable) {
            void var5_5;
            this.addShutdownHook((String)var5_5);
            throw throwable;
        }
    }

    private String getValue(Option<String> param) {
        return param != null && param.isDefined() ? (String)param.get() : null;
    }

    private String writeToTemp(SQLContext sqlContext, Dataset<Row> df, String hdfsTemp, String tempFolder, String fileType, String header, String delimiter, String quote, String escape, String multiLine, String codec, String rowTag, String rootTag) {
        String randomSuffix = new StringBuilder().append((Object)"spark_sftp_connection_temp_").append((Object)UUID.randomUUID()).toString();
        String hdfsTempLocation = new StringBuilder().append((Object)hdfsTemp).append((Object)File.separator).append((Object)randomSuffix).toString();
        String localTempLocation = new StringBuilder().append((Object)tempFolder).append((Object)File.separator).append((Object)randomSuffix).toString();
        this.addShutdownHook(localTempLocation);
        String string = fileType;
        if ("xml".equals(string)) {
            df.coalesce(1).write().format(constants$.MODULE$.xmlClass()).option(constants$.MODULE$.xmlRowTag(), rowTag).option(constants$.MODULE$.xmlRootTag(), rootTag).save(hdfsTempLocation);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("csv".equals(string)) {
            Utils$.MODULE$.ImplicitDataFrameWriter(df.coalesce(1).write().option("header", header).option("delimiter", delimiter).option("quote", quote).option("escape", escape).option("multiLine", multiLine)).optionNoNull("codec", (Option<String>)Option$.MODULE$.apply((Object)codec)).csv(hdfsTempLocation);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("txt".equals(string)) {
            df.coalesce(1).write().text(hdfsTempLocation);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("avro".equals(string)) {
            df.coalesce(1).write().format("com.databricks.spark.avro").save(hdfsTempLocation);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            df.coalesce(1).write().format(fileType).save(hdfsTempLocation);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        this.copyFromHdfs(sqlContext, hdfsTempLocation, localTempLocation);
        return this.copiedFile(localTempLocation);
    }

    private void addShutdownHook(String tempLocation) {
        this.logger().debug((Object)new StringBuilder().append((Object)"Adding hook for file ").append((Object)tempLocation).toString());
        DeleteTempFileShutdownHook hook = new DeleteTempFileShutdownHook(tempLocation);
        Runtime.getRuntime().addShutdownHook(hook);
    }

    private String copiedFile(String tempFileLocation) {
        File baseTemp = new File(tempFileLocation);
        File[] files = (File[])Predef$.MODULE$.refArrayOps((Object[])baseTemp.listFiles()).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File x) {
                return !x.isDirectory() && !x.getName().contains("SUCCESS") && !x.isHidden() && !x.getName().contains(".crc") && !x.getName().contains("_committed_") && !x.getName().contains("_started_");
            }
        });
        return files[0].getAbsolutePath();
    }
}

