/*
 * Decompiled with CFR 0.152.
 */
package com.spt.development.audit.spring;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonPrimitive;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import lombok.Generated;

public final class AuditEvent {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(OffsetDateTime.class, (src, typeOfSrc, context) -> new JsonPrimitive(DateTimeFormatter.ISO_OFFSET_DATE_TIME.format((TemporalAccessor)src))).registerTypeAdapter(OffsetDateTime.class, (json, typeOfT, context) -> DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((CharSequence)json.getAsString(), OffsetDateTime::from)).create();
    private final String type;
    private final String subType;
    private final String correlationId;
    private final String id;
    private final String details;
    private final String userId;
    private final String username;
    private final String originatingIP;
    private final String serviceId;
    private final String serviceVersion;
    private final String serverHostName;
    private final OffsetDateTime created;

    public String toJson() {
        return GSON.toJson((Object)this);
    }

    public static AuditEvent fromJson(String json) {
        return (AuditEvent)GSON.fromJson(json, AuditEvent.class);
    }

    @Generated
    public static AuditEventBuilder builder() {
        return new AuditEventBuilder();
    }

    @Generated
    public AuditEventBuilder toBuilder() {
        return new AuditEventBuilder().type(this.type).subType(this.subType).correlationId(this.correlationId).id(this.id).details(this.details).userId(this.userId).username(this.username).originatingIP(this.originatingIP).serviceId(this.serviceId).serviceVersion(this.serviceVersion).serverHostName(this.serverHostName).created(this.created);
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getSubType() {
        return this.subType;
    }

    @Generated
    public String getCorrelationId() {
        return this.correlationId;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getDetails() {
        return this.details;
    }

    @Generated
    public String getUserId() {
        return this.userId;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getOriginatingIP() {
        return this.originatingIP;
    }

    @Generated
    public String getServiceId() {
        return this.serviceId;
    }

    @Generated
    public String getServiceVersion() {
        return this.serviceVersion;
    }

    @Generated
    public String getServerHostName() {
        return this.serverHostName;
    }

    @Generated
    public OffsetDateTime getCreated() {
        return this.created;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuditEvent)) {
            return false;
        }
        AuditEvent other = (AuditEvent)o;
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$subType = this.getSubType();
        String other$subType = other.getSubType();
        if (this$subType == null ? other$subType != null : !this$subType.equals(other$subType)) {
            return false;
        }
        String this$correlationId = this.getCorrelationId();
        String other$correlationId = other.getCorrelationId();
        if (this$correlationId == null ? other$correlationId != null : !this$correlationId.equals(other$correlationId)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$details = this.getDetails();
        String other$details = other.getDetails();
        if (this$details == null ? other$details != null : !this$details.equals(other$details)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$originatingIP = this.getOriginatingIP();
        String other$originatingIP = other.getOriginatingIP();
        if (this$originatingIP == null ? other$originatingIP != null : !this$originatingIP.equals(other$originatingIP)) {
            return false;
        }
        String this$serviceId = this.getServiceId();
        String other$serviceId = other.getServiceId();
        if (this$serviceId == null ? other$serviceId != null : !this$serviceId.equals(other$serviceId)) {
            return false;
        }
        String this$serviceVersion = this.getServiceVersion();
        String other$serviceVersion = other.getServiceVersion();
        if (this$serviceVersion == null ? other$serviceVersion != null : !this$serviceVersion.equals(other$serviceVersion)) {
            return false;
        }
        String this$serverHostName = this.getServerHostName();
        String other$serverHostName = other.getServerHostName();
        if (this$serverHostName == null ? other$serverHostName != null : !this$serverHostName.equals(other$serverHostName)) {
            return false;
        }
        OffsetDateTime this$created = this.getCreated();
        OffsetDateTime other$created = other.getCreated();
        return !(this$created == null ? other$created != null : !((Object)this$created).equals(other$created));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $subType = this.getSubType();
        result = result * 59 + ($subType == null ? 43 : $subType.hashCode());
        String $correlationId = this.getCorrelationId();
        result = result * 59 + ($correlationId == null ? 43 : $correlationId.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $details = this.getDetails();
        result = result * 59 + ($details == null ? 43 : $details.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $originatingIP = this.getOriginatingIP();
        result = result * 59 + ($originatingIP == null ? 43 : $originatingIP.hashCode());
        String $serviceId = this.getServiceId();
        result = result * 59 + ($serviceId == null ? 43 : $serviceId.hashCode());
        String $serviceVersion = this.getServiceVersion();
        result = result * 59 + ($serviceVersion == null ? 43 : $serviceVersion.hashCode());
        String $serverHostName = this.getServerHostName();
        result = result * 59 + ($serverHostName == null ? 43 : $serverHostName.hashCode());
        OffsetDateTime $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AuditEvent(type=" + this.getType() + ", subType=" + this.getSubType() + ", correlationId=" + this.getCorrelationId() + ", id=" + this.getId() + ", details=" + this.getDetails() + ", userId=" + this.getUserId() + ", username=" + this.getUsername() + ", originatingIP=" + this.getOriginatingIP() + ", serviceId=" + this.getServiceId() + ", serviceVersion=" + this.getServiceVersion() + ", serverHostName=" + this.getServerHostName() + ", created=" + String.valueOf(this.getCreated()) + ")";
    }

    @Generated
    private AuditEvent(String type, String subType, String correlationId, String id, String details, String userId, String username, String originatingIP, String serviceId, String serviceVersion, String serverHostName, OffsetDateTime created) {
        this.type = type;
        this.subType = subType;
        this.correlationId = correlationId;
        this.id = id;
        this.details = details;
        this.userId = userId;
        this.username = username;
        this.originatingIP = originatingIP;
        this.serviceId = serviceId;
        this.serviceVersion = serviceVersion;
        this.serverHostName = serverHostName;
        this.created = created;
    }

    @Generated
    public static class AuditEventBuilder {
        @Generated
        private String type;
        @Generated
        private String subType;
        @Generated
        private String correlationId;
        @Generated
        private String id;
        @Generated
        private String details;
        @Generated
        private String userId;
        @Generated
        private String username;
        @Generated
        private String originatingIP;
        @Generated
        private String serviceId;
        @Generated
        private String serviceVersion;
        @Generated
        private String serverHostName;
        @Generated
        private OffsetDateTime created;

        @Generated
        AuditEventBuilder() {
        }

        @Generated
        public AuditEventBuilder type(String type) {
            this.type = type;
            return this;
        }

        @Generated
        public AuditEventBuilder subType(String subType) {
            this.subType = subType;
            return this;
        }

        @Generated
        public AuditEventBuilder correlationId(String correlationId) {
            this.correlationId = correlationId;
            return this;
        }

        @Generated
        public AuditEventBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public AuditEventBuilder details(String details) {
            this.details = details;
            return this;
        }

        @Generated
        public AuditEventBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        @Generated
        public AuditEventBuilder username(String username) {
            this.username = username;
            return this;
        }

        @Generated
        public AuditEventBuilder originatingIP(String originatingIP) {
            this.originatingIP = originatingIP;
            return this;
        }

        @Generated
        public AuditEventBuilder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        @Generated
        public AuditEventBuilder serviceVersion(String serviceVersion) {
            this.serviceVersion = serviceVersion;
            return this;
        }

        @Generated
        public AuditEventBuilder serverHostName(String serverHostName) {
            this.serverHostName = serverHostName;
            return this;
        }

        @Generated
        public AuditEventBuilder created(OffsetDateTime created) {
            this.created = created;
            return this;
        }

        @Generated
        public AuditEvent build() {
            return new AuditEvent(this.type, this.subType, this.correlationId, this.id, this.details, this.userId, this.username, this.originatingIP, this.serviceId, this.serviceVersion, this.serverHostName, this.created);
        }

        @Generated
        public String toString() {
            return "AuditEvent.AuditEventBuilder(type=" + this.type + ", subType=" + this.subType + ", correlationId=" + this.correlationId + ", id=" + this.id + ", details=" + this.details + ", userId=" + this.userId + ", username=" + this.username + ", originatingIP=" + this.originatingIP + ", serviceId=" + this.serviceId + ", serviceVersion=" + this.serviceVersion + ", serverHostName=" + this.serverHostName + ", created=" + String.valueOf(this.created) + ")";
        }
    }
}

