/*
 * Decompiled with CFR 0.152.
 */
package com.spt.development.audit.spring;

import com.spt.development.audit.spring.AuditEvent;
import com.spt.development.audit.spring.CorrelationIdProvider;
import com.spt.development.audit.spring.DefaultCorrelationIdProvider;
import com.spt.development.audit.spring.TransactionAwareAuditEventWriter;
import com.spt.development.audit.spring.util.CorrelationIdUtils;
import jakarta.jms.TextMessage;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.core.JmsTemplate;

public class JmsAuditEventWriter
extends TransactionAwareAuditEventWriter {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(JmsAuditEventWriter.class);
    private final String destinationName;
    private final JmsTemplate jmsTemplate;

    public JmsAuditEventWriter(String destinationName, JmsTemplate jmsTemplate) {
        this(true, destinationName, jmsTemplate);
    }

    public JmsAuditEventWriter(boolean includeCorrelationIdInLogs, String destinationName, JmsTemplate jmsTemplate) {
        this(includeCorrelationIdInLogs, destinationName, jmsTemplate, new DefaultCorrelationIdProvider());
    }

    public JmsAuditEventWriter(boolean includeCorrelationIdInLogs, String destinationName, JmsTemplate jmsTemplate, CorrelationIdProvider correlationIdProvider) {
        super(includeCorrelationIdInLogs, correlationIdProvider);
        this.destinationName = destinationName;
        this.jmsTemplate = jmsTemplate;
    }

    @Override
    protected void doWrite(AuditEvent auditEvent) {
        this.debug("Adding audit event message to JMS queue: {}", auditEvent);
        this.jmsTemplate.send(this.destinationName, s -> {
            TextMessage message = s.createTextMessage(auditEvent.toJson());
            message.setJMSCorrelationID(this.getCorrelationId());
            return message;
        });
    }

    private void debug(String format, Object ... arguments) {
        if (this.isIncludeCorrelationIdInLogs()) {
            LOG.debug("[{}] " + format, CorrelationIdUtils.addCorrelationIdToArguments(this.getCorrelationId(), arguments));
            return;
        }
        LOG.debug(format, arguments);
    }
}

