/*
 * Decompiled with CFR 0.152.
 */
package com.spt.development.audit.spring;

import com.spt.development.audit.spring.AuditEvent;
import com.spt.development.audit.spring.AuditEventWriter;
import com.spt.development.audit.spring.CorrelationIdProvider;
import com.spt.development.audit.spring.DefaultCorrelationIdProvider;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jAuditEventWriter
implements AuditEventWriter {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(Slf4jAuditEventWriter.class);
    private final boolean includeCorrelationIdInLogs;
    private final CorrelationIdProvider correlationIdProvider;

    public Slf4jAuditEventWriter() {
        this(true);
    }

    public Slf4jAuditEventWriter(boolean includeCorrelationIdInLogs) {
        this(includeCorrelationIdInLogs, new DefaultCorrelationIdProvider());
    }

    public Slf4jAuditEventWriter(boolean includeCorrelationIdInLogs, CorrelationIdProvider correlationIdProvider) {
        this.includeCorrelationIdInLogs = includeCorrelationIdInLogs;
        this.correlationIdProvider = correlationIdProvider;
    }

    @Override
    public void write(AuditEvent auditEvent) {
        if (this.includeCorrelationIdInLogs) {
            LOG.info("[{}] Audit event: {}", (Object)this.correlationIdProvider.getCorrelationId(), (Object)auditEvent);
            return;
        }
        LOG.info("Audit event: {}", (Object)auditEvent);
    }
}

