/*
 * Decompiled with CFR 0.152.
 */
package com.spt.development.audit.spring;

import com.spt.development.audit.spring.AuditEvent;
import com.spt.development.audit.spring.AuditEventWriter;
import com.spt.development.audit.spring.CorrelationIdProvider;
import com.spt.development.audit.spring.TransactionSyncManFacade;
import com.spt.development.audit.spring.util.CorrelationIdUtils;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.support.TransactionSynchronization;

public abstract class TransactionAwareAuditEventWriter
implements AuditEventWriter {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(TransactionAwareAuditEventWriter.class);
    private final boolean includeCorrelationIdInLogs;
    private final CorrelationIdProvider correlationIdProvider;
    private final TransactionSyncManFacade transactionSyncManFacade;

    protected TransactionAwareAuditEventWriter(boolean includeCorrelationIdInLogs, CorrelationIdProvider correlationIdProvider) {
        this(includeCorrelationIdInLogs, correlationIdProvider, new TransactionSyncManFacade());
    }

    protected boolean isIncludeCorrelationIdInLogs() {
        return this.includeCorrelationIdInLogs;
    }

    protected String getCorrelationId() {
        return this.correlationIdProvider.getCorrelationId();
    }

    @Override
    public void write(AuditEvent auditEvent) {
        if (this.transactionSyncManFacade.isTransactionActive()) {
            this.debug("Transaction active, audit event will be written when transaction commits: {}", auditEvent);
            this.transactionSyncManFacade.register(new AuditEventTransactionSync(this.includeCorrelationIdInLogs, auditEvent, this::doWrite));
            return;
        }
        this.doWrite(auditEvent);
    }

    private void debug(String format, Object ... arguments) {
        if (this.includeCorrelationIdInLogs) {
            LOG.debug("[{}] " + format, CorrelationIdUtils.addCorrelationIdToArguments(this.getCorrelationId(), arguments));
            return;
        }
        LOG.debug(format, arguments);
    }

    protected abstract void doWrite(AuditEvent var1);

    @Generated
    protected TransactionAwareAuditEventWriter(boolean includeCorrelationIdInLogs, CorrelationIdProvider correlationIdProvider, TransactionSyncManFacade transactionSyncManFacade) {
        this.includeCorrelationIdInLogs = includeCorrelationIdInLogs;
        this.correlationIdProvider = correlationIdProvider;
        this.transactionSyncManFacade = transactionSyncManFacade;
    }

    static class AuditEventTransactionSync
    implements TransactionSynchronization {
        @Generated
        private static final Logger LOG = LoggerFactory.getLogger(AuditEventTransactionSync.class);
        private final boolean includeCorrelationIdInLogs;
        private final AuditEvent auditEvent;
        private final Consumer<AuditEvent> onAuditEvent;

        public void afterCommit() {
            try {
                this.onAuditEvent.accept(this.auditEvent);
            }
            catch (Exception ex) {
                this.error("Failed to write audit event: {}", this.auditEvent, ex);
            }
        }

        public void afterCompletion(int status) {
            if (status == 1) {
                this.info("Transaction was rolled back, discarding audit event: {}", this.auditEvent);
            }
        }

        void info(String format, Object ... arguments) {
            this.log((arg_0, arg_1) -> ((Logger)LOG).info(arg_0, arg_1), format, arguments);
        }

        void error(String format, Object ... arguments) {
            this.log((arg_0, arg_1) -> ((Logger)LOG).error(arg_0, arg_1), format, arguments);
        }

        private void log(BiConsumer<String, Object[]> log, String format, Object[] arguments) {
            if (this.includeCorrelationIdInLogs) {
                log.accept("[{}] " + format, CorrelationIdUtils.addCorrelationIdToArguments(this.auditEvent.getCorrelationId(), arguments));
                return;
            }
            log.accept(format, arguments);
        }

        @Generated
        public AuditEventTransactionSync(boolean includeCorrelationIdInLogs, AuditEvent auditEvent, Consumer<AuditEvent> onAuditEvent) {
            this.includeCorrelationIdInLogs = includeCorrelationIdInLogs;
            this.auditEvent = auditEvent;
            this.onAuditEvent = onAuditEvent;
        }
    }
}

