/*
 * Decompiled with CFR 0.152.
 */
package com.spt.development.audit.spring.aop;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.spt.development.audit.spring.AuditEvent;
import com.spt.development.audit.spring.AuditEventWriter;
import com.spt.development.audit.spring.Audited;
import com.spt.development.audit.spring.CorrelationIdProvider;
import com.spt.development.audit.spring.DefaultCorrelationIdProvider;
import com.spt.development.audit.spring.aop.LocalhostFacade;
import com.spt.development.audit.spring.security.AuthenticationAdapter;
import com.spt.development.audit.spring.security.AuthenticationAdapterFactory;
import com.spt.development.audit.spring.util.CorrelationIdUtils;
import com.spt.development.audit.spring.util.HttpRequestUtils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.net.UnknownHostException;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.ReflectionUtils;

@Aspect
public class Auditor {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(Auditor.class);
    private static final Gson GSON = new GsonBuilder().create();
    private static final String DEFAULT_DETAILS_KEY = "DETAILS";
    private final String appName;
    private final String appVersion;
    private final LocalhostFacade localhostFacade;
    private final AuditEventWriter auditEventWriter;
    private final boolean includeCorrelationIdInLogs;
    private final CorrelationIdProvider correlationIdProvider;
    private final AuthenticationAdapterFactory authenticationAdapterFactory;

    public Auditor(String appName, String appVersion, AuditEventWriter auditEventWriter, AuthenticationAdapterFactory authenticationAdapterFactory) {
        this(appName, appVersion, auditEventWriter, true, authenticationAdapterFactory);
    }

    public Auditor(String appName, String appVersion, AuditEventWriter auditEventWriter, boolean includeCorrelationIdInLogs, AuthenticationAdapterFactory authenticationAdapterFactory) {
        this(appName, appVersion, auditEventWriter, includeCorrelationIdInLogs, new DefaultCorrelationIdProvider(), authenticationAdapterFactory);
    }

    public Auditor(String appName, String appVersion, AuditEventWriter auditEventWriter, boolean includeCorrelationIdInLogs, CorrelationIdProvider correlationIdProvider, AuthenticationAdapterFactory authenticationAdapterFactory) {
        this(appName, appVersion, new LocalhostFacade(), auditEventWriter, includeCorrelationIdInLogs, correlationIdProvider, authenticationAdapterFactory);
    }

    Auditor(String appName, String appVersion, LocalhostFacade localhostFacade, AuditEventWriter auditEventWriter, boolean includeCorrelationIdInLogs, CorrelationIdProvider correlationIdProvider, AuthenticationAdapterFactory authenticationAdapterFactory) {
        this.appName = appName;
        this.appVersion = appVersion;
        this.localhostFacade = localhostFacade;
        this.auditEventWriter = auditEventWriter;
        this.includeCorrelationIdInLogs = includeCorrelationIdInLogs;
        this.correlationIdProvider = correlationIdProvider;
        this.authenticationAdapterFactory = authenticationAdapterFactory;
    }

    @Around(value="@annotation(com.spt.development.audit.spring.Audited)")
    public Object audit(ProceedingJoinPoint point) throws Throwable {
        Object result = point.proceed();
        MethodSignature signature = (MethodSignature)point.getSignature();
        Audited audited = (Audited)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)signature.getMethod(), Audited.class);
        if ("NONE".equals(Optional.of(audited).map(Audited::type).orElse("NONE"))) {
            throw new IllegalStateException("Programming error: @Audited annotation must have type set");
        }
        this.audit(audited, result, signature, point.getArgs());
        return result;
    }

    private void audit(Audited audited, Object result, MethodSignature signature, Object[] args) {
        AuthenticationAdapter authentication = this.authenticationAdapterFactory.createAdapter();
        Parameter[] parameters = signature.getMethod().getParameters();
        Audited.Id auditedId = (Audited.Id)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)signature.getMethod(), Audited.Id.class);
        AuditEvent auditEvent = AuditEvent.builder().type(audited.type()).subType(audited.subType()).correlationId(this.correlationIdProvider.getCorrelationId()).id(auditedId == null ? this.getIdFromFirstAnnotatedMethodParameter(parameters, args) : this.getIdFromAnnotatedValue("Return value", result, auditedId)).details(this.getDetailsFromAnnotatedParametersAsJson(parameters, args)).userId(authentication.getUserId()).username(authentication.getUsername()).originatingIP(HttpRequestUtils.getClientIpAddress()).serviceId(this.appName).serviceVersion(this.appVersion).serverHostName(this.getServerHostName()).created(OffsetDateTime.now(ZoneOffset.UTC)).build();
        this.onAuditEvent(auditEvent);
    }

    private String getIdFromFirstAnnotatedMethodParameter(Parameter[] parameters, Object[] args) {
        for (int i = 0; i < args.length; ++i) {
            Audited.Id auditedId = (Audited.Id)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)parameters[i], Audited.Id.class);
            if (auditedId == null) continue;
            return this.getIdFromAnnotatedValue("Parameter " + (i + 1), args[i], auditedId);
        }
        this.debug("No parameters annotated with @Audited.Id annotation", new Object[0]);
        return null;
    }

    private String getIdFromAnnotatedValue(String annotationPosition, Object value, Audited.Id auditedId) {
        if (value == null) {
            this.warn("{} was annotated with @Audit.Id annotation but is null", annotationPosition);
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)auditedId.field())) {
            return value.toString();
        }
        return this.readIdFromValue(annotationPosition, value, auditedId.field());
    }

    private String readIdFromValue(String annotationPosition, Object value, String fieldName) {
        try {
            Field field = value.getClass().getDeclaredField(fieldName);
            Object fieldValue = this.makeAccessibleAndGetField(field, value);
            if (fieldValue == null) {
                this.warn("{} was annotated with @Audit.Id(field = \"{}\") annotation but the '{}' field is null", annotationPosition, fieldName, fieldName);
                return null;
            }
            return fieldValue.toString();
        }
        catch (NoSuchFieldException ex) {
            throw new IllegalStateException(String.format("Programming error: %s of type: %s was annotated with @Audited.Id(field = \"%s\"), but no field with the name: '%s' could be found", annotationPosition, value.getClass(), fieldName, fieldName), ex);
        }
    }

    private Object makeAccessibleAndGetField(Field field, Object obj) {
        ReflectionUtils.makeAccessible((Field)field);
        return ReflectionUtils.getField((Field)field, (Object)obj);
    }

    private String getDetailsFromAnnotatedParametersAsJson(Parameter[] parameters, Object[] args) {
        Map<String, Object> details = this.getDetailsFromAnnotatedParameters(parameters, args);
        if (details.isEmpty()) {
            return null;
        }
        return this.auditDetailsToJson(details);
    }

    private Map<String, Object> getDetailsFromAnnotatedParameters(Parameter[] parameters, Object[] args) {
        HashMap<String, Object> details = new HashMap<String, Object>();
        for (int i = 0; i < parameters.length; ++i) {
            Audited.Detail auditedDetail = (Audited.Detail)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)parameters[i], Audited.Detail.class);
            if (auditedDetail == null) continue;
            String detailName = auditedDetail.name();
            if (StringUtils.isEmpty((CharSequence)detailName) && !details.isEmpty()) {
                throw new IllegalStateException(String.format("Programming error: If multiple method parameters are annotated with @Audited.Detail, they must all have their name set. Name was not set for parameter %d", i));
            }
            details.put(StringUtils.isEmpty((CharSequence)detailName) ? DEFAULT_DETAILS_KEY : detailName, args[i]);
        }
        return details;
    }

    private String auditDetailsToJson(Map<String, Object> details) {
        if (details.containsKey(DEFAULT_DETAILS_KEY)) {
            return GSON.toJson(details.get(DEFAULT_DETAILS_KEY));
        }
        return GSON.toJson(details);
    }

    private String getServerHostName() {
        try {
            return this.localhostFacade.getServerHostName();
        }
        catch (UnknownHostException ex) {
            this.warn("Failed to determine server host name for auditing purposes", ex);
            return null;
        }
    }

    private void onAuditEvent(AuditEvent auditEvent) {
        this.debug("Generated audit event: {}", auditEvent);
        try {
            this.auditEventWriter.write(auditEvent);
        }
        catch (Throwable t) {
            this.error("Failed to send audit event: {}", auditEvent);
        }
    }

    private void debug(String format, Object ... arguments) {
        this.log((arg_0, arg_1) -> ((Logger)LOG).debug(arg_0, arg_1), format, arguments);
    }

    private void warn(String format, Object ... arguments) {
        this.log((arg_0, arg_1) -> ((Logger)LOG).warn(arg_0, arg_1), format, arguments);
    }

    private void error(String format, Object ... arguments) {
        this.log((arg_0, arg_1) -> ((Logger)LOG).error(arg_0, arg_1), format, arguments);
    }

    private void log(BiConsumer<String, Object[]> log, String format, Object[] arguments) {
        if (this.includeCorrelationIdInLogs) {
            log.accept("[{}] " + format, CorrelationIdUtils.addCorrelationIdToArguments(this.correlationIdProvider.getCorrelationId(), arguments));
            return;
        }
        log.accept(format, arguments);
    }
}

