/*
 * Decompiled with CFR 0.152.
 */
package com.spt.development.audit.spring.security;

import com.spt.development.audit.spring.security.AnonymousAuthenticationAdapter;
import com.spt.development.audit.spring.security.AuthenticationAdapter;
import com.spt.development.audit.spring.security.AuthenticationAdapterFactory;
import com.spt.development.audit.spring.security.DefaultUsernamePasswordAuthenticationAdapter;
import java.util.function.Function;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class DefaultAuthenticationAdapterFactory
implements AuthenticationAdapterFactory {
    private Function<Authentication, AuthenticationAdapter> usernamePasswordFactory = auth -> new DefaultUsernamePasswordAuthenticationAdapter(auth.getPrincipal());

    public AuthenticationAdapterFactory withUsernamePasswordFactory(Function<Authentication, AuthenticationAdapter> usernamePasswordFactory) {
        this.usernamePasswordFactory = usernamePasswordFactory;
        return this;
    }

    @Override
    public AuthenticationAdapter createAdapter() {
        return this.createAdapter(SecurityContextHolder.getContext().getAuthentication());
    }

    private AuthenticationAdapter createAdapter(Authentication authentication) {
        if (this.isAnonymousAuthentication(authentication)) {
            return new AnonymousAuthenticationAdapter();
        }
        if (this.isUsernamePasswordAuthentication(authentication)) {
            return this.usernamePasswordFactory.apply(authentication);
        }
        throw new UnsupportedOperationException("Only anonymous users or users authenticated via simple username/password authentication are currently supported");
    }

    private boolean isAnonymousAuthentication(Authentication authentication) {
        return authentication == null || authentication instanceof AnonymousAuthenticationToken;
    }

    private boolean isUsernamePasswordAuthentication(Authentication authentication) {
        return authentication instanceof UsernamePasswordAuthenticationToken;
    }
}

