/*
 * Decompiled with CFR 0.152.
 */
package com.spt.development.audit.spring.util;

import jakarta.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public final class HttpRequestUtils {
    private static final String[] IP_HEADER_CANDIDATES = new String[]{"X-Forwarded-For", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_X_FORWARDED_FOR", "HTTP_X_FORWARDED", "HTTP_X_CLUSTER_CLIENT_IP", "HTTP_CLIENT_IP", "HTTP_FORWARDED_FOR", "HTTP_FORWARDED", "HTTP_VIA", "REMOTE_ADDR"};

    public static String getClientIpAddress() {
        RequestAttributes requestAttribute = RequestContextHolder.getRequestAttributes();
        if (requestAttribute == null) {
            return null;
        }
        return HttpRequestUtils.getClientIpAddress((ServletRequestAttributes)requestAttribute);
    }

    private static String getClientIpAddress(ServletRequestAttributes requestAttributes) {
        HttpServletRequest request = requestAttributes.getRequest();
        for (String header : IP_HEADER_CANDIDATES) {
            String ipList = request.getHeader(header);
            if (!StringUtils.isNotEmpty((CharSequence)ipList) || "unknown".equalsIgnoreCase(ipList)) continue;
            return ipList.split(",")[0];
        }
        return request.getRemoteAddr();
    }

    @Generated
    private HttpRequestUtils() {
    }
}

