/*
 * Decompiled with CFR 0.152.
 */
package com.spt.development.cid.jms.spring;

import com.spt.development.cid.CorrelationId;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.messaging.handler.annotation.Header;

@Aspect
@Order(value=0)
public class CorrelationIdSetter {
    private static final Logger LOG = LoggerFactory.getLogger(CorrelationIdSetter.class);

    @Before(value="@annotation(org.springframework.jms.annotation.JmsListener)")
    public void setCorrelationId(JoinPoint point) throws NoSuchMethodException, JMSException {
        MethodSignature signature = (MethodSignature)point.getSignature();
        String methodName = signature.getMethod().getName();
        Class<?>[] parameterTypes = signature.getMethod().getParameterTypes();
        Annotation[][] annotations = point.getTarget().getClass().getMethod(methodName, parameterTypes).getParameterAnnotations();
        for (int i = 0; i < annotations.length; ++i) {
            boolean isCorrelationId = Arrays.stream(annotations[i]).filter(a -> a instanceof Header).map(Header.class::cast).anyMatch(h -> "jms_correlationId".equals(h.value()));
            if (isCorrelationId) {
                CorrelationId.set((String)point.getArgs()[i].toString());
                LOG.debug("[{}] Set correlationId from JMS Listener parameter annotated as correlation ID header", (Object)CorrelationId.get());
                return;
            }
            if (!Message.class.isAssignableFrom(parameterTypes[i])) continue;
            CorrelationId.set((String)((Message)Message.class.cast(point.getArgs()[i])).getJMSCorrelationID());
            LOG.debug("[{}] Set correlationId from JMS message correlationId", (Object)CorrelationId.get());
            return;
        }
        CorrelationId.reset();
        LOG.warn("[{}] Unable to set correlation ID. Method annotated with JmsListener annotation must have a parameter annotated with the Header annotation with its value set to JmsHeaders.CORRELATION_ID *or* a parameter of type Message", (Object)CorrelationId.get());
    }
}

