/*
 * Decompiled with CFR 0.152.
 */
package com.spt.development.cid.jms.spring;

import com.spt.development.cid.CorrelationId;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.MDC;
import org.springframework.core.annotation.Order;

@Aspect
@Order(value=1)
public class MdcCorrelationIdPutter {
    public static final String MDC_CID_KEY = "cid";
    private final String cidKey;

    public MdcCorrelationIdPutter() {
        this(MDC_CID_KEY);
    }

    public MdcCorrelationIdPutter(String cidKey) {
        this.cidKey = cidKey;
    }

    @Around(value="@annotation(org.springframework.jms.annotation.JmsListener)")
    public Object putCorrelationId(ProceedingJoinPoint point) throws Throwable {
        try (MDC.MDCCloseable mdc = MDC.putCloseable((String)this.cidKey, (String)CorrelationId.get());){
            assert (mdc != null);
            Object object = point.proceed();
            return object;
        }
    }
}

