/*
 * Decompiled with CFR 0.152.
 */
package com.spt.development.cid.web.spring.boot.autoconfigure;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="spt.cid.web")
public class CidWebProperties {
    private final String cidHeader;
    private final Boolean useRequestHeader;
    private final MdcProperties mdc;
    private final RegistrationBean registrationBean;

    public CidWebProperties(String cidHeader, Boolean useRequestHeader, MdcProperties mdc, RegistrationBean registrationBean) {
        this.cidHeader = cidHeader;
        this.useRequestHeader = useRequestHeader;
        this.mdc = Optional.ofNullable(mdc).orElse(new MdcProperties(null));
        this.registrationBean = Optional.ofNullable(registrationBean).orElse(new RegistrationBean(null, null, null));
    }

    public String getCidHeader() {
        return this.cidHeader;
    }

    public Boolean getUseRequestHeader() {
        return this.useRequestHeader;
    }

    public MdcProperties getMdc() {
        return this.mdc;
    }

    public RegistrationBean getBean() {
        return this.registrationBean;
    }

    public static class MdcProperties {
        private final RegistrationBean registrationBean;

        public MdcProperties(RegistrationBean registrationBean) {
            this.registrationBean = Optional.ofNullable(registrationBean).orElse(new RegistrationBean(null, null, null));
        }

        public RegistrationBean getBean() {
            return this.registrationBean;
        }
    }

    public static class RegistrationBean {
        private final String name;
        private final Integer order;
        private final List<String> urlPatterns;

        public RegistrationBean(String name, Integer order, List<String> urlPatterns) {
            this.name = name;
            this.order = order;
            this.urlPatterns = Optional.ofNullable(urlPatterns).map(Collections::unmodifiableList).orElse(Collections.emptyList());
        }

        public String getName() {
            return this.name;
        }

        public Integer getOrder() {
            return this.order;
        }

        public List<String> getUrlPatterns() {
            return this.urlPatterns;
        }
    }
}

